package data.scripts.campaign.econ;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.econ.ConditionData;
import com.fs.starfarer.api.impl.campaign.ids.Commodities;

public class UW_CabalInfluence extends BaseMarketConditionPlugin {

    @Override
    public void apply(String id) {
        if (!market.hasSubmarket("uw_cabalmarket")) {
            market.addSubmarket("uw_cabalmarket");
        }

        float mult = getBaseSizeMult();

        float stabilityMult = getLowStabilityBonusMult(market) * getHighStabilityPenaltyMult(market);
        mult *= stabilityMult;

        market.getDemand(Commodities.VOLATILES).getDemand().modifyFlat(id, mult *
                                                                       ConditionData.ORGANIZED_CRIME_VOLATILES);
        market.getDemand(Commodities.ORGANICS).getDemand().modifyFlat(id, mult * ConditionData.ORGANIZED_CRIME_ORGANICS);

        float productionMult = getProductionMult(market, Commodities.VOLATILES, Commodities.ORGANICS);
        market.getCommodityData(Commodities.DRUGS).getSupply().modifyFlat(id,
                                                                          mult * ConditionData.ORGANIZED_CRIME_DRUGS *
                                                                          productionMult);
    }

    @Override
    public void unapply(String id) {
        market.getDemand(Commodities.VOLATILES).getDemand().unmodify(id);
        market.getDemand(Commodities.ORGANICS).getDemand().unmodify(id);

        market.getCommodityData(Commodities.DRUGS).getSupply().unmodify(id);
    }
}
