package data.scripts.campaign.econ;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UW_Pillaged extends BaseMarketConditionPlugin {

    private ConditionInfo info = new ConditionInfo(0, 1f);

    @Override
    public void apply(String id) {
        market.getStability().modifyFlat(id, -1f * info.stabilityImpact, "Pillaged");
    }

    @Override
    public String[] getHighlights() {
        List<String> highlights = new ArrayList<>(1);
        addTokensToList(highlights, "$stabilityPenalty");
        return highlights.toArray(new String[highlights.size()]);
    }

    public ConditionInfo getInfo() {
        return info;
    }

    @Override
    public void setParam(Object param) {
        info = (ConditionInfo) param;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> tokens = super.getTokenReplacements();
        tokens.put("$stabilityPenalty", "" + (int) info.stabilityImpact);
        if (info.sizeImpact > 1) {
            tokens.put("$sizeImpact", "- Market strength reduced significantly");
        } else if (info.sizeImpact == 1) {
            tokens.put("$sizeImpact", "- Market strength reduced");
        } else {
            tokens.put("$sizeImpact", "");
        }

        return tokens;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void unapply(String id) {
        market.getStability().unmodify(id);
    }

    public static final class ConditionInfo {

        public int sizeImpact;
        public float stabilityImpact;

        public ConditionInfo(int sizeImpact, float stabilityImpact) {
            this.sizeImpact = sizeImpact;
            this.stabilityImpact = stabilityImpact;
        }
    }
}
