package data.scripts.campaign.econ;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.econ.ConditionData;
import com.fs.starfarer.api.impl.campaign.ids.Commodities;

public class UW_Scrapyard extends BaseMarketConditionPlugin {

    public static final float FUEL_PRODUCTION_FUEL = 10000;

    public static final float SHIPBREAKING_CREW = 2000f;
    public static final float SHIPBREAKING_MACHINERY = 400f;
    public static final float SHIPBREAKING_METALS = 4000f;
    public static final float SHIPBREAKING_RARE_METALS = 400;
    public static final float SHIPBREAKING_SUPPLIES = 4000f;

    @Override
    public void apply(String id) {
        if (!market.hasSubmarket("uw_scrapyard_submarket")) {
            market.addSubmarket("uw_scrapyard_submarket");
        }

        float mult = getBaseSizeMult();
        float crewDemandMet = getCrewDemandMet(market);
        market.getCommodityData(Commodities.FUEL).getSupply().modifyFlat(id, FUEL_PRODUCTION_FUEL * crewDemandMet * mult);
        market.getDemand(Commodities.CREW).getDemand().modifyFlat(id, SHIPBREAKING_CREW * mult);
        market.getDemand(Commodities.CREW).getNonConsumingDemand().modifyFlat(id, SHIPBREAKING_CREW * mult *
                                                                              ConditionData.CREW_MARINES_NON_CONSUMING_FRACTION);
        market.getCommodityData(Commodities.HEAVY_MACHINERY).getSupply().modifyFlat(id, SHIPBREAKING_MACHINERY *
                                                                                    crewDemandMet * mult);
        market.getCommodityData(Commodities.SUPPLIES).getSupply().modifyFlat(id, SHIPBREAKING_SUPPLIES * crewDemandMet *
                                                                             mult);
        market.getCommodityData(Commodities.METALS).getSupply().modifyFlat(id, SHIPBREAKING_METALS * crewDemandMet *
                                                                           mult);
        market.getCommodityData(Commodities.RARE_METALS).getSupply().modifyFlat(id, SHIPBREAKING_RARE_METALS *
                                                                                crewDemandMet * mult);
    }

    @Override
    public void unapply(String id) {
        market.getCommodityData(Commodities.FUEL).getSupply().unmodify(id);
        market.getDemand(Commodities.CREW).getDemand().unmodify(id);
        market.getDemand(Commodities.CREW).getNonConsumingDemand().unmodify(id);
        market.getCommodityData(Commodities.HEAVY_MACHINERY).getSupply().unmodify(id);
        market.getCommodityData(Commodities.SUPPLIES).getSupply().unmodify(id);
        market.getCommodityData(Commodities.METALS).getSupply().unmodify(id);
        market.getCommodityData(Commodities.RARE_METALS).getSupply().unmodify(id);
    }
}
