package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.ids.Conditions;
import com.fs.starfarer.api.impl.campaign.ids.Factions;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.UnderworldModPlugin;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class UW_EventManager extends BaseCampaignEventListener implements EveryFrameScript {

    public static final float EXTORT_MURDEROUS_PENALTY_KNOWN_MULT = 4;
    public static final float EXTORT_MURDEROUS_PENALTY_TIME = 20f;
    public static float PILLAGE_FREQUENCY = 200f;

    public static Logger log = Global.getLogger(UW_EventManager.class);

    private static final String SETTINGS_FILE = "UNDERWORLD_OPTIONS.ini";

    public static void reloadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);

        PILLAGE_FREQUENCY = (float) settings.getDouble("pillageAverageFrequency");
    }

    public float timeToPillageEvent;

    private SectorEntityToken previousPreviousTarget = null;
    private SectorEntityToken previousTarget = null;
    private CampaignEventTarget target = null;

    public UW_EventManager() {
        super(true);

        timeToPillageEvent = PILLAGE_FREQUENCY * ((float) Math.random() * 0.5f + 0.25f);
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);

        if (UnderworldModPlugin.Module_PillageFleets) {
            if (timeToPillageEvent > 0f) {
                timeToPillageEvent -= days;
                if (timeToPillageEvent <= 0f) {
                    SectorEntityToken origin = pickOrigin();
                    SectorEntityToken pick = pickTarget(origin);
                    if (pick == null) {
                        timeToPillageEvent = 1f;
                        return;
                    }
                    previousPreviousTarget = previousTarget;
                    previousTarget = pick;
                    target = new CampaignEventTarget(pick);
                    Map<String, Object> params = new HashMap<>(20);
                    params.put("origin", origin);
                    Global.getSector().getEventManager().startEvent(target, "uw_pillage", params);
                }
            } else {
                if (!Global.getSector().getEventManager().isOngoing(target, "uw_pillage")) {
                    timeToPillageEvent += PILLAGE_FREQUENCY * ((float) Math.random() * 0.8f + 0.6f);
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    // if we rob people and then kill them anyway, others will refuse to give in to our extortion for a while
    // put this here because CBA to make a new script
    @Override
    public void reportPlayerEngagement(EngagementResultAPI result) {

        if (!result.getBattle().isPlayerInvolvedAtStart()) {
            return;
        }
        if (result.getBattle().getNonPlayerSide().isEmpty()) {
            return;
        }

        CampaignFleetAPI otherMain = result.getBattle().getNonPlayerSide().get(0);
        if (otherMain.getMemoryWithoutUpdate().getBoolean("$uw_extorted")) {
            float time = EXTORT_MURDEROUS_PENALTY_TIME;
            if (otherMain.knowsWhoPlayerIs()) {
                time *= EXTORT_MURDEROUS_PENALTY_KNOWN_MULT;
            }
            Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$uw_extortMurderous", true, time);
        }
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    private SectorEntityToken pickOrigin() {
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<>();

        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFaction().getId().equals(Factions.PIRATES)) {
                continue;
            }
            float weight = (float) Math.pow(2, (6f - Math.abs(6f - market.getSize())) / 2.0) *
                  (float) Math.sqrt(2f + market.getStabilityValue());
            float boost = 1f;
            if (market.hasCondition(Conditions.HEADQUARTERS)) {
                boost += 0.2f;
            }
            if (market.hasCondition(Conditions.MILITARY_BASE)) {
                boost += 0.3f;
            }
            if (market.hasCondition(Conditions.REGIONAL_CAPITAL)) {
                boost += 0.2f;
            }
            if (market.hasCondition(Conditions.SPACEPORT)) {
                boost += 0.1f;
            }
            if (market.hasCondition(Conditions.ORBITAL_STATION)) {
                boost += 0.1f;
            }
            weight *= boost;

            picker.add(market, weight);
        }
        if (picker.isEmpty()) {
            return null;
        }
        return picker.pick().getPrimaryEntity();
    }

    private SectorEntityToken pickTarget(SectorEntityToken origin) {
        if (origin == null) {
            return null;
        }
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<>();

        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFaction().isAtBest(Factions.PIRATES, RepLevel.HOSTILE)) {
                continue;
            }
            if (market.hasCondition("cabal_influence")) {
                continue;
            }
            if (market.getStarSystem() == null || market.getPrimaryEntity() == previousTarget ||
                    market.getPrimaryEntity() == previousPreviousTarget) {
                continue;
            }
            if (market.getSize() < 4 || market.hasCondition(Conditions.DECIVILIZED)) {
                continue;
            }
            float dist = Misc.getDistance(market.getLocationInHyperspace(), origin.getLocationInHyperspace());
            if (dist > 100000f) {
                continue;
            }

            float weight = (float) Math.pow(2, (6f - Math.abs(6f - market.getSize())) / 2.0) *
                  (float) Math.sqrt(2f + market.getStabilityValue());
            float boost = 1f;
            if (market.hasCondition(Conditions.HEADQUARTERS)) {
                //boost += 0.2f;
            }
            if (market.hasCondition(Conditions.MILITARY_BASE)) {
                boost -= 0.5f;    // pirates don't try to tangle with military units head-on
            }
            if (market.hasCondition(Conditions.REGIONAL_CAPITAL)) {
                boost += 0.3f;
            }
            if (market.hasCondition(Conditions.SPACEPORT)) {
                boost += 0.1f;
            }
            if (market.hasCondition(Conditions.ORBITAL_STATION)) {
                boost += 0.1f;
            }
            boost *= 5000f / Math.max(5000f, dist);

            weight *= boost;
            if (market.getFaction().isAtBest(Factions.PIRATES, RepLevel.VENGEFUL)) {
                weight *= 2f;
            }

            picker.add(market, weight);
        }
        if (picker.isEmpty()) {
            return null;
        }
        return picker.pick().getPrimaryEntity();
    }

}
