package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.BuffManagerAPI.Buff;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionPlugin;
import com.fs.starfarer.api.campaign.econ.MarketConnectionAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin.CustomRepImpact;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin.RepActionEnvelope;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin.RepActions;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin.RepRewards;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.RecentUnrestEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.ids.Commodities;
import com.fs.starfarer.api.impl.campaign.ids.Events;
import com.fs.starfarer.api.impl.campaign.ids.Factions;
import com.fs.starfarer.api.impl.campaign.ids.FleetTypes;
import com.fs.starfarer.api.impl.campaign.ids.MemFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import data.scripts.campaign.UW_FleetFactory;
import data.scripts.campaign.UW_FleetFactory.FleetFactoryDelegate;
import data.scripts.campaign.econ.UW_Pillaged;
import data.scripts.util.DS_Defs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

// crudely copied from II siege event
// TODO: support Junk Pirates (but probably not Ahriman) as well?
public class UW_PillageEvent extends BaseEventPlugin {

    public static final Logger log = Global.getLogger(UW_PillageEvent.class);

    private static void causeRecentUnrest(MarketAPI target, int stabilityPenalty) {
        if (stabilityPenalty <= 0) {
            return;
        }
        CampaignEventManagerAPI manager = Global.getSector().getEventManager();
        RecentUnrestEvent event = (RecentUnrestEvent) manager.getOngoingEvent(new CampaignEventTarget(target),
                                                                              Events.RECENT_UNREST);
        if (event == null) {
            event = (RecentUnrestEvent) manager.startEvent(new CampaignEventTarget(target), Events.RECENT_UNREST, null);
        }
        event.increaseStabilityPenalty(stabilityPenalty);
    }

    private static void setCRBuff(CampaignFleetAPI fleet, float buffAmount) {
        if (buffAmount <= 0f) {
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                member.getBuffManager().removeBuff("uw_pillagebuff");
            }
        } else {
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                Buff buff = member.getBuffManager().getBuff("uw_pillagebuff");
                if (buff instanceof CRBuff) {
                    CRBuff crBuff = (CRBuff) buff;
                    crBuff.setBuffAmount(buffAmount, member);
                } else if (buff == null) {
                    member.getBuffManager().addBuff(new CRBuff(buffAmount));
                }
            }
        }
    }

    private final List<CampaignFleetAPI> activeFleets = new LinkedList<>();

    private float creditsPaid = 0f;
    private int currentStabilityImpact = 0;
    private float daysPillaged = 0f;
    private boolean done = false;
    private SectorEntityToken origin = null;
    private CampaignFleetAPI pillageFleet = null;
    private int playerContrib = 0;
    private float remainingDaysInStage;
    private int stage;

    private final IntervalUtil tracker = new IntervalUtil(0.75f, 1.25f);

    @Override
    public void advance(float amount) {
        if (!isEventStarted()) {
            return;
        }
        if (isDone()) {
            return;
        }

        if (!origin.getMarket().getFactionId().contentEquals(Factions.PIRATES)) {
            endEvent();
            return;
        }

        float days = Global.getSector().getClock().convertToDays(amount);
        if (stage == 2 || stage == 3) {
            daysPillaged += days;
            if ((int) (daysPillaged / 8) > currentStabilityImpact) {
                currentStabilityImpact = (int) (daysPillaged / 8);
                for (MarketConditionAPI condition : market.getConditions()) {
                    MarketConditionPlugin plugin = condition.getPlugin();
                    if (plugin instanceof UW_Pillaged) {
                        ((UW_Pillaged) plugin).getInfo().stabilityImpact = currentStabilityImpact;
                    }
                    condition.getPlugin().apply(condition.getIdForPluginModifications());
                }
                market.updatePriceMult();
            }

            tracker.advance(days);
            if (tracker.intervalElapsed()) {
                for (MarketConnectionAPI connection : Global.getSector().getEconomy().getConnectionsCopy()) {
                    if (connection.getMarketIdOne().contentEquals(market.getId()) ||
                            connection.getMarketIdTwo().contentEquals(market.getId())) {
                        connection.getPriceMod().modifyMult(getStatModId(), 1.5f);
                        connection.getSmugglingMod().modifyMult(getStatModId(), 0.5f);
                    }
                }
                for (CommodityOnMarketAPI commodity : market.getAllCommodities()) {
                    float stockpile = commodity.getStockpile();
                    if (commodity.isNonEcon() || stockpile <= 1f) {
                        continue;
                    }
                    commodity.removeFromStockpile(stockpile / (40f + (float) Math.random() * 10f));
                }
                for (CampaignFleetAPI fleet : eventTarget.getLocation().getFleets()) {
                    if (fleet.isAlive() && fleet.getAI() != null && fleet.getAI().getCurrentAssignment() != null &&
                            fleet.getAI().getCurrentAssignment().getTarget() != null &&
                            fleet.getAI().getCurrentAssignment().getTarget().getMarket() ==
                            eventTarget.getMarket()) {
                        if (fleet.getAI().getCurrentAssignment().getAssignment() == FleetAssignment.ORBIT_PASSIVE ||
                                fleet.getAI().getCurrentAssignment().getAssignment() ==
                                FleetAssignment.GO_TO_LOCATION_AND_DESPAWN ||
                                fleet.getAI().getCurrentAssignment().getAssignment() == FleetAssignment.DELIVER_CREW ||
                                fleet.getAI().getCurrentAssignment().getAssignment() == FleetAssignment.DELIVER_FUEL ||
                                fleet.getAI().getCurrentAssignment().getAssignment() ==
                                FleetAssignment.DELIVER_RESOURCES) {
                            if (fleet.getFaction().isAtWorst(eventTarget.getFaction(), RepLevel.FRIENDLY) &&
                                    fleet.getFleetPoints() >= 30 &&
                                    !fleet.getMemoryWithoutUpdate().contains(MemFlags.MEMORY_KEY_TRADE_FLEET) &&
                                    !fleet.getMemoryWithoutUpdate().contains(MemFlags.MEMORY_KEY_SMUGGLER)) {
                                fleet.getAI().addAssignmentAtStart(FleetAssignment.DEFEND_LOCATION, entity, 5f,
                                                                   "defending " + eventTarget.getEntity().getName(),
                                                                   null);
                            } else if (fleet.getFaction() != faction) {
                                int bound = 100;
                                while (bound > 0) {
                                    bound--;
                                    if (fleet.getAI().getCurrentAssignment() != null &&
                                            fleet.getAI().getCurrentAssignment().getTarget() != null &&
                                            fleet.getAI().getCurrentAssignment().getTarget().getMarket() ==
                                            eventTarget.getMarket()) {
                                        fleet.getAI().removeFirstAssignment();
                                    } else {
                                        break;
                                    }
                                }
                                if (fleet.getAI().getCurrentAssignment() == null ||
                                        fleet.getAI().getCurrentAssignment().isExipred()) {
                                    List<MarketAPI> markets = Global.getSector().getEconomy().getMarketsCopy();
                                    Collections.shuffle(markets);
                                    SectorEntityToken token = null;
                                    for (MarketAPI mkt : markets) {
                                        if (market.getFaction().isAtWorst(fleet.getFaction(), RepLevel.SUSPICIOUS)) {
                                            token = mkt.getPrimaryEntity();
                                            break;
                                        }
                                    }
                                    if (token != null) {
                                        fleet.getAI().addAssignmentAtStart(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN,
                                                                           token, 5f, "retreating to " +
                                                                           token.getName(), null);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        remainingDaysInStage -= days;

        if (stage == 1) {
            if (pillageFleet == null || pillageFleet.getAI() == null || !pillageFleet.isAlive() ||
                    pillageFleet.getFleetPoints() < 50) {
                for (CampaignFleetAPI fleet : activeFleets) {
                    if (!fleet.isAlive()) {
                        continue;
                    }
                    fleet.clearAssignments();
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, origin, 1000, "returning to " + origin.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "standing down");
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, origin, 1000);
                }
                if (playerContrib >= 100) {
                    creditsPaid = playerContrib * 300f;
                    if (eventTarget.getFaction().isAtBest(Factions.PLAYER, RepLevel.HOSTILE)) {
                        creditsPaid *= 0f;
                    } else if (eventTarget.getFaction().isAtBest(Factions.PLAYER, RepLevel.INHOSPITABLE)) {
                        creditsPaid *= 0.3f;
                    } else if (eventTarget.getFaction().isAtBest(Factions.PLAYER, RepLevel.SUSPICIOUS)) {
                        creditsPaid *= 0.8f;
                    } else if (eventTarget.getFaction().isAtWorst(Factions.PLAYER, RepLevel.COOPERATIVE)) {
                        creditsPaid *= 1.5f;
                    } else if (eventTarget.getFaction().isAtWorst(Factions.PLAYER, RepLevel.FRIENDLY)) {
                        creditsPaid *= 1.35f;
                    } else if (eventTarget.getFaction().isAtWorst(Factions.PLAYER, RepLevel.WELCOMING)) {
                        creditsPaid *= 1.2f;
                    }
                    Global.getSector().reportEventStage(this, "end_intercepted_by_player", entity,
                                                        MessagePriority.ENSURE_DELIVERY,
                                                        new BaseOnMessageDeliveryScript() {
                                                            @Override
                                                            public void beforeDelivery(CommMessageAPI message) {
                                                                CampaignFleetAPI playerFleet =
                                                                                 Global.getSector().getPlayerFleet();
                                                                playerFleet.getCargo().getCredits().add(creditsPaid);
                                                                CustomRepImpact impact = new CustomRepImpact();
                                                                impact.delta = RepRewards.EXTREME;
                                                                impact.limit = RepLevel.COOPERATIVE;
                                                                Global.getSector().adjustPlayerReputation(
                                                                        new RepActionEnvelope(
                                                                                RepActions.CUSTOM, impact, message,
                                                                                false), eventTarget.getFaction().getId());
                                                            }
                                                        });
                } else {
                    Global.getSector().reportEventStage(this, "end_intercepted", entity, MessagePriority.ENSURE_DELIVERY);
                }
                endEvent();
            } else if (!origin.getFaction().isHostileTo(eventTarget.getFaction())) {
                for (CampaignFleetAPI fleet : activeFleets) {
                    if (!fleet.isAlive()) {
                        continue;
                    }
                    fleet.clearAssignments();
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, origin, 1000, "returning to " + origin.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "standing down");
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, origin, 1000);
                }
                endEvent();
            } else if (pillageFleet.getAI().getCurrentAssignment() == null) {
                remainingDaysInStage = (float) Math.random() * 5f + 10f;
                stage = 2;

                market.getMemoryWithoutUpdate().set("$pillaged", true);
                market.addCondition("uw_pillaged", true);

                for (CampaignFleetAPI fleet : activeFleets) {
                    fleet.clearAssignments();
                    if (fleet == pillageFleet) {
                        fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, entity, 1000, "pillaging " + entity.getName());
                    } else {
                        fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, entity, 1000, "blockading " +
                                            entity.getName());
                    }
                }

                if (market.getSize() >= 6) {
                    Global.getSector().reportEventStage(this, "start", entity, MessagePriority.SECTOR);
                } else {
                    Global.getSector().reportEventStage(this, "start", entity, MessagePriority.CLUSTER);
                }

                market.getDemand(Commodities.HAND_WEAPONS).getDemand().modifyMult(getStatModId(), 1.5f);
                market.getDemand(Commodities.FOOD).getDemand().modifyMult(getStatModId(), 1.5f);
                market.getDemand(Commodities.FUEL).getDemand().modifyMult(getStatModId(), 1.25f);
                market.getDemand(Commodities.CREW).getDemand().modifyMult(getStatModId(), 1.25f);
                market.getDemand(Commodities.SUPPLIES).getDemand().modifyMult(getStatModId(), 1.5f);
            } else {
                for (CampaignFleetAPI fleet : activeFleets) {
                    if (fleet != pillageFleet) {
//                        if (Misc.getDistance(pillageFleet.getLocation(), fleet.getLocation()) > 1500) {
//                            AbilityPlugin burn = fleet.getAbility("emergency_burn");
//                            if (burn != null && burn.isUsable()) {
//                                burn.activate();
//                            }
//                        }
                        if ((((Misc.getDistance(pillageFleet.getLocation(), fleet.getLocation()) > 1500) ||
                              (pillageFleet.getContainingLocation() != fleet.getContainingLocation())) &&
                             (fleet.getAI().getCurrentAssignmentType() != FleetAssignment.DELIVER_CREW))) {
                            fleet.clearAssignments();
                            fleet.addAssignment(FleetAssignment.DELIVER_CREW, pillageFleet, 1000, "protecting " +
                                                pillageFleet.getName());
                        } else if (((Misc.getDistance(pillageFleet.getLocation(), fleet.getLocation()) < 750) &&
                                    (pillageFleet.getContainingLocation() == fleet.getContainingLocation()) &&
                                    (fleet.getAI().getCurrentAssignmentType() != FleetAssignment.ORBIT_AGGRESSIVE))) {
                            fleet.clearAssignments();
                            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, pillageFleet, 1000, "protecting " +
                                                pillageFleet.getName());
                        }
                    }
                }
            }
        } else if (stage == 2 || stage == 3) {
            if (pillageFleet == null || pillageFleet.getAI() == null || !pillageFleet.isAlive() ||
                    pillageFleet.getFleetPoints() < 50) {
                for (CampaignFleetAPI fleet : activeFleets) {
                    if (!fleet.isAlive()) {
                        continue;
                    }
                    fleet.clearAssignments();
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, origin, 1000, "returning to " + origin.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "standing down");
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, origin, 1000);
                }
                if (pillageFleet != null) {
                    setCRBuff(pillageFleet, 0f);
                }
                if (playerContrib >= 100) {
                    creditsPaid = playerContrib * 1000f;
                    if (eventTarget.getFaction().isAtBest(Factions.PLAYER, RepLevel.HOSTILE)) {
                        creditsPaid *= 0f;
                    } else if (eventTarget.getFaction().isAtBest(Factions.PLAYER, RepLevel.INHOSPITABLE)) {
                        creditsPaid *= 0.3f;
                    } else if (eventTarget.getFaction().isAtBest(Factions.PLAYER, RepLevel.SUSPICIOUS)) {
                        creditsPaid *= 0.8f;
                    } else if (eventTarget.getFaction().isAtWorst(Factions.PLAYER, RepLevel.COOPERATIVE)) {
                        creditsPaid *= 1.5f;
                    } else if (eventTarget.getFaction().isAtWorst(Factions.PLAYER, RepLevel.FRIENDLY)) {
                        creditsPaid *= 1.35f;
                    } else if (eventTarget.getFaction().isAtWorst(Factions.PLAYER, RepLevel.WELCOMING)) {
                        creditsPaid *= 1.2f;
                    }
                    if (stage == 2) {
                        Global.getSector().reportEventStage(this, "end_by_player", entity,
                                                            MessagePriority.ENSURE_DELIVERY,
                                                            new BaseOnMessageDeliveryScript() {
                                                                @Override
                                                                public void beforeDelivery(CommMessageAPI message) {
                                                                    CampaignFleetAPI playerFleet =
                                                                                     Global.getSector().getPlayerFleet();
                                                                    playerFleet.getCargo().getCredits().add(creditsPaid);
                                                                    CustomRepImpact impact = new CustomRepImpact();
                                                                    impact.delta = RepRewards.EXTREME * 1.5f;
                                                                    impact.limit = RepLevel.COOPERATIVE;
                                                                    Global.getSector().adjustPlayerReputation(
                                                                            new RepActionEnvelope(RepActions.CUSTOM,
                                                                                                  impact, message, false),
                                                                            eventTarget.getFaction().getId());
                                                                }
                                                            });
                    } else {
                        creditsPaid *= 0.5f;
                        Global.getSector().reportEventStage(this, "end_late_by_player", entity,
                                                            MessagePriority.ENSURE_DELIVERY,
                                                            new BaseOnMessageDeliveryScript() {
                                                                @Override
                                                                public void beforeDelivery(CommMessageAPI message) {
                                                                    CampaignFleetAPI playerFleet =
                                                                                     Global.getSector().getPlayerFleet();
                                                                    playerFleet.getCargo().getCredits().add(creditsPaid);
                                                                    CustomRepImpact impact = new CustomRepImpact();
                                                                    impact.delta = RepRewards.VERY_HIGH;
                                                                    impact.limit = RepLevel.COOPERATIVE;
                                                                    Global.getSector().adjustPlayerReputation(
                                                                            new RepActionEnvelope(
                                                                                    RepActions.CUSTOM, impact, message,
                                                                                    false),
                                                                            eventTarget.getFaction().getId());
                                                                }
                                                            });
                    }
                } else {
                    if (stage == 2) {
                        Global.getSector().reportEventStage(this, "end", entity, MessagePriority.ENSURE_DELIVERY);
                    } else {
                        Global.getSector().reportEventStage(this, "end_late", entity, MessagePriority.ENSURE_DELIVERY);
                    }
                }
                if (stage == 2) {
                    if (market.getSize() >= 6) {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        15f + market.getSize() * 2f,
                                        20f + market.getSize() * 2f),
                                1, market));
                    } else {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        20f + market.getSize() * 3f,
                                        30f + market.getSize() * 3f),
                                1, market));
                    }
                } else {
                    if (market.getSize() >= 6) {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        20f + market.getSize() * 3f,
                                        30f + market.getSize() * 3f),
                                1, market));
                    } else {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        30f + market.getSize() * 4f,
                                        45f + market.getSize() * 4f),
                                1, market));
                    }
                }
                endEvent();
            } else if (!origin.getFaction().isHostileTo(eventTarget.getFaction())) {
                for (CampaignFleetAPI fleet : activeFleets) {
                    if (!fleet.isAlive()) {
                        continue;
                    }
                    fleet.clearAssignments();
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, origin, 1000, "returning to " + origin.getName());
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "standing down");
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, origin, 1000);
                }
                if (pillageFleet != null) {
                    setCRBuff(pillageFleet, 0f);
                }
                if (stage == 2) {
                    Global.getSector().reportEventStage(this, "end_peace", entity, MessagePriority.ENSURE_DELIVERY);
                } else {
                    Global.getSector().reportEventStage(this, "end_late_peace", entity, MessagePriority.ENSURE_DELIVERY);
                }
                if (stage == 2) {
                    if (market.getSize() >= 6) {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        15f + market.getSize() * 2f,
                                        20f + market.getSize() * 2f),
                                1, market));
                    } else {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        20f + market.getSize() * 3f,
                                        30f + market.getSize() * 3f),
                                1, market));
                    }
                } else {
                    if (market.getSize() >= 6) {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        20f + market.getSize() * 3f,
                                        30f + market.getSize() * 3f),
                                1, market));
                    } else {
                        market.getPrimaryEntity().addScript(new MarketDamage(
                                MathUtils.getRandomNumberInRange(
                                        30f + market.getSize() * 4f,
                                        45f + market.getSize() * 4f),
                                1, market));
                    }
                }
                endEvent();
            } else {
                if (pillageFleet != null) {
                    float buffAmount = 0f;
                    for (CampaignFleetAPI fleet : activeFleets) {
                        if (fleet != pillageFleet) {
                            buffAmount += 30f * Math.min(1f,
                                                         fleet.getFleetPoints() / (50f + pillageFleet.getFleetPoints()));
                        }
                    }
                    setCRBuff(pillageFleet, buffAmount);
                }

                for (CampaignFleetAPI fleet : activeFleets) {
                    if (fleet != pillageFleet) {
                        if (Misc.getDistance(entity.getLocation(), fleet.getLocation()) > 5000) {
                            AbilityPlugin burn = fleet.getAbility("emergency_burn");
                            if (burn != null && burn.isUsable()) {
                                burn.activate();
                            }
                        }
                        if ((((Misc.getDistance(entity.getLocation(), fleet.getLocation()) > 3000) ||
                              (pillageFleet.getContainingLocation() != fleet.getContainingLocation())) &&
                             (fleet.getAI().getCurrentAssignmentType() == FleetAssignment.ORBIT_AGGRESSIVE))) {
                            fleet.clearAssignments();
                            fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, entity, 1000, "blockading " +
                                                entity.getName());
                        } else if (((Misc.getDistance(entity.getLocation(), fleet.getLocation()) < 1000) &&
                                    (pillageFleet.getContainingLocation() == fleet.getContainingLocation()) &&
                                    (fleet.getAI().getCurrentAssignmentType() == FleetAssignment.ORBIT_PASSIVE))) {
                            fleet.clearAssignments();
                            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, entity, 1000, "blockading " +
                                                entity.getName());
                        }
                    }
                }
            }
        }

        if (stage == -1) {
            stage = 0;

            Global.getSector().reportEventStage(this, "planning", origin, MessagePriority.CLUSTER);
        } else if (remainingDaysInStage <= 0f && stage == 0) {
            stage = 1;

            Global.getSector().reportEventStage(this, "coming", origin, MessagePriority.CLUSTER);

            float qf = origin.getMarket().getShipQualityFactor();
            float sizeBonus = entity.getMarket().getSize() + entity.getMarket().getStabilityValue();
            int maxPts = 24 + Math.round(qf * 12f) + MathUtils.getRandomNumberInRange(0, 12) + (int) sizeBonus;
            final FleetParams params = new FleetParams(null, // location
                                                       market, // market
                                                       Factions.PIRATES,
                                                       null, // fleet's faction, if different from above, which is also used for source market picking
                                                       FleetTypes.PATROL_LARGE,
                                                       maxPts, // combatPts
                                                       maxPts / 15f, // freighterPts
                                                       maxPts / 15f, // tankerPts
                                                       maxPts / 10f, // transportPts
                                                       0f, // linerPts
                                                       0f, // civilianPts
                                                       maxPts / 15f, // utilityPts
                                                       0f, // qualityBonus
                                                       -1f, // qualityOverride
                                                       0.5f, // officer num mult
                                                       0);
            pillageFleet = UW_FleetFactory.enhancedCreateFleet(Global.getSector().getFaction(Factions.PIRATES), maxPts,
                                                               new FleetFactoryDelegate() {
                                                                   @Override
                                                                   public CampaignFleetAPI createFleet() {
                                                                       return FleetFactoryV2.createFleet(
                                                                               params);
                                                                   }
                                                               });
            if (pillageFleet == null) {
                endEvent();
                return;
            }

            Misc.makeImportant(pillageFleet, "iw_pe", 1000f);
            pillageFleet.setName("Pillager Fleet");
            //pillageFleet.setNoFactionInName(true);
            pillageFleet.getMemoryWithoutUpdate().set(MemFlags.MEMORY_KEY_FLEET_TYPE, "uw_piratePillageFleet");
            pillageFleet.getStats().getDynamic().
                    getMod(DS_Defs.STAT_BATTLE_DEBRIS_CHANCE).modifyMult("uw_spawner", 0.25f);
            pillageFleet.getStats().getDynamic().
                    getMod(DS_Defs.STAT_BATTLE_DERELICTS_CHANCE).modifyMult("uw_spawner", 0.25f);
            pillageFleet.getStats().getDynamic().
                    getMod(DS_Defs.STAT_FLEET_DERELICTS_SCALE).modifyMult("uw_spawner", 0.5f);

            origin.getContainingLocation().addEntity(pillageFleet);
            pillageFleet.setLocation(origin.getLocation().x + MathUtils.getRandomNumberInRange(-100f, 100f),
                                     origin.getLocation().y + MathUtils.getRandomNumberInRange(-100f, 100f));

            activeFleets.add(pillageFleet);

            Vector2f dest = Misc.getPointAtRadius(entity.getLocationInHyperspace(), 500);
            SectorEntityToken token = Global.getSector().getHyperspace().createToken(dest.x, dest.y);
            pillageFleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "preparing for expedition");
            if (origin.getContainingLocation() != entity.getContainingLocation()) {
                pillageFleet.addAssignment(FleetAssignment.DELIVER_CREW, token, 1000, "traveling to " +
                                           entity.getContainingLocation().getName());
            }
            pillageFleet.addAssignment(FleetAssignment.DELIVER_CREW, entity, 1000, "traveling to " + entity.getName());

            for (int i = 0; i < 2; i++) {
                maxPts = 12 + Math.round(qf * 6f) + MathUtils.getRandomNumberInRange(0, 6) + (int) (sizeBonus * 0.5f);
                final FleetParams escortParams = new FleetParams(null, // location
                                                                 market, // market
                                                                 Factions.PIRATES,
                                                                 null,
                                                                 FleetTypes.PATROL_MEDIUM,
                                                                 maxPts, // combatPts
                                                                 0f, // freighterPts
                                                                 0f, // tankerPts
                                                                 0f, // transportPts
                                                                 0f, // linerPts
                                                                 0f, // civilianPts
                                                                 0f, // utilityPts
                                                                 0.25f, // qualityBonus
                                                                 -1f, // qualityOverride
                                                                 1f, // officer num mult
                                                                 5);
                CampaignFleetAPI escort = UW_FleetFactory.enhancedCreateFleet(Global.getSector().getFaction(
                                 Factions.PIRATES), maxPts, new FleetFactoryDelegate() {
                                     @Override
                                     public CampaignFleetAPI createFleet() {
                                         return FleetFactoryV2.createFleet(
                                                 escortParams);
                                     }
                                 });

                if (escort != null) {
                    escort.setName("Raid Fleet");
                    //escort.setNoFactionInName(true);
                    escort.getMemoryWithoutUpdate().set(MemFlags.MEMORY_KEY_FLEET_TYPE, "uw_piratePillageEscort");
                    escort.getStats().getDynamic().
                            getMod(DS_Defs.STAT_BATTLE_DEBRIS_CHANCE).modifyMult("uw_spawner", 0.25f);
                    escort.getStats().getDynamic().
                            getMod(DS_Defs.STAT_BATTLE_DERELICTS_CHANCE).modifyMult("uw_spawner", 0.25f);
                    escort.getStats().getDynamic().
                            getMod(DS_Defs.STAT_FLEET_DERELICTS_SCALE).modifyMult("uw_spawner", 0.5f);

                    origin.getContainingLocation().addEntity(escort);
                    escort.setLocation(origin.getLocation().x + MathUtils.getRandomNumberInRange(-250f, 250f),
                                       origin.getLocation().y + MathUtils.getRandomNumberInRange(-250f, 250f));

                    activeFleets.add(escort);

                    escort.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "preparing for expedition");
                    escort.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, pillageFleet, 1000, "protecting " +
                                         pillageFleet.getName());
                }
            }
        } else if (remainingDaysInStage <= 0f && stage == 2) {
            remainingDaysInStage = (float) Math.random() * 5f + 10f;
            stage = 3;
        } else if (remainingDaysInStage <= 0f && stage == 3) {
            stage = 4;

            for (CampaignFleetAPI fleet : activeFleets) {
                if (!fleet.isAlive()) {
                    continue;
                }
                fleet.clearAssignments();
                fleet.addAssignment(FleetAssignment.DELIVER_CREW, origin, 1000, "returning to " + origin.getName());
                fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, origin, 4f, "standing down");
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, origin, 1000);
            }

            if (pillageFleet != null) {
                setCRBuff(pillageFleet, 0f);
            }

            if (market.getSize() >= 6) {
                Global.getSector().reportEventStage(this, "end_victory", entity, MessagePriority.SECTOR);
            } else {
                Global.getSector().reportEventStage(this, "end_victory", entity, MessagePriority.CLUSTER);
            }

            if (market.getSize() >= 6) {
                market.getPrimaryEntity().addScript(new MarketDamage(
                        MathUtils.getRandomNumberInRange(
                                30f + market.getSize() * 4f,
                                45f + market.getSize() * 4f),
                        2, market));
            } else {
                market.getPrimaryEntity().addScript(new MarketDamage(
                        MathUtils.getRandomNumberInRange(
                                45f + market.getSize() * 6f,
                                60f + market.getSize() * 6f),
                        2, market));
            }

            endEvent();
        }
    }

    @Override
    public String getEventName() {
        return "Pirates pillaging " + entity.getName();
    }

    @Override
    public String[] getHighlights(String stageId) {
        List<String> result = new ArrayList<>(1);
        addTokensToList(result, "$credits");
        return result.toArray(new String[result.size()]);
    }

    @Override
    @SuppressWarnings("unchecked")
    public void setParam(Object param) {
        Map<String, Object> params = (Map) param;
        origin = (SectorEntityToken) params.get("origin");
    }

    public CampaignFleetAPI getPillageFleet() {
        return pillageFleet;
    }

    public SectorEntityToken getPillageTarget() {
        return market.getPrimaryEntity();
    }

    public int getStage() {
        return stage;
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> tokens = super.getTokenReplacements();
        tokens.put("$origin", origin.getName());
        tokens.put("$planet", eventTarget.getEntity().getName());
        tokens.put("$system", ((StarSystemAPI) eventTarget.getLocation()).getBaseName());
        tokens.put("$sender", origin.getFaction().getDisplayName());
        tokens.put("$market", eventTarget.getMarket().getName());
        tokens.put("$targetFaction", eventTarget.getFaction().getDisplayName());
        tokens.put("$TargetFaction", Misc.ucFirst(eventTarget.getFaction().getDisplayName()));
        tokens.put("$theTargetFaction", eventTarget.getFaction().getDisplayNameWithArticle());
        tokens.put("$TheTargetFaction", Misc.ucFirst(eventTarget.getFaction().getDisplayNameWithArticle()));
        tokens.put("$faction", faction.getDisplayName());
        tokens.put("$Faction", Misc.ucFirst(faction.getDisplayName()));
        tokens.put("$theFaction", faction.getDisplayNameWithArticle());
        tokens.put("$TheFaction", Misc.ucFirst(faction.getDisplayNameWithArticle()));
        tokens.put("$factionLong", faction.getDisplayNameLong());
        tokens.put("$FactionLong", Misc.ucFirst(faction.getDisplayNameLong()));
        tokens.put("$theFactionLong", faction.getDisplayNameLongWithArticle());
        tokens.put("$TheFactionLong", Misc.ucFirst(faction.getDisplayNameLongWithArticle()));
        if (creditsPaid <= 1f) {
            tokens.put("$payment", "Due to your history with " + eventTarget.getFaction().getDisplayNameWithArticle() +
                       ", they were unwilling to reward you.");
            tokens.put("$credits", "");
        } else {
            tokens.put("$payment", Misc.ucFirst(eventTarget.getFaction().getDisplayNameWithArticle()) +
                       " rewarded your heroism with a payment of");
            tokens.put("$credits", Misc.getDGSCredits(creditsPaid));
        }
        return tokens;
    }

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
        faction = Global.getSector().getFaction(Factions.PIRATES);
        remainingDaysInStage = (float) Math.random() * 10f + 10f;
        stage = -1;
        playerContrib = 0;

        Global.getSector().getPersistentData().put("uw_currentPillageEvent", this);
    }

    @Override
    public boolean isDone() {
        return done;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        super.reportBattleOccurred(primaryWinner, battle);
        if (!isEventStarted()) {
            return;
        }
        if (isDone()) {
            return;
        }
        if (!battle.onPlayerSide(primaryWinner)) {
            return;
        }
        if (!Global.getSector().getPlayerFleet().isTransponderOn()) {
            return;
        }

        for (CampaignFleetAPI loser : battle.getOtherSideFor(primaryWinner)) {
            if (activeFleets.contains(loser)) {
                playerContrib += (Misc.getSnapshotFPLost(loser) / (pillageFleet == loser ? 1 : 2)) *
                battle.getPlayerInvolvementFraction();
            }
        }
    }

    @Override
    public void reportFleetDespawned(CampaignFleetAPI fleet, FleetDespawnReason reason, Object param) {
        activeFleets.remove(fleet);
    }

    @Override
    public void startEvent() {
        super.startEvent(true);
    }

    private void endEvent() {
        done = true;
        if (pillageFleet != null) {
            Misc.makeUnimportant(pillageFleet, "uw_pe");
        }
        activeFleets.clear();
        market.getMemoryWithoutUpdate().unset("$pillaged");
        for (MarketConnectionAPI connection : Global.getSector().getEconomy().getConnectionsCopy()) {
            if (connection.getMarketIdOne().contentEquals(market.getId()) || connection.getMarketIdTwo().contentEquals(
                    market.getId())) {
                connection.getPriceMod().unmodify(getStatModId());
            }
        }
        Global.getSector().getPersistentData().remove("uw_currentPillageEvent");
        market.getDemand(Commodities.HAND_WEAPONS).getDemand().unmodify(getStatModId());
        market.getDemand(Commodities.FOOD).getDemand().unmodify(getStatModId());
        market.getDemand(Commodities.FUEL).getDemand().unmodify(getStatModId());
        market.getDemand(Commodities.METALS).getDemand().unmodify(getStatModId());
        market.getDemand(Commodities.CREW).getDemand().unmodify(getStatModId());
        market.getDemand(Commodities.SUPPLIES).getDemand().unmodify(getStatModId());
    }

    private static class CRBuff implements Buff {

        private float buffAmount;
        private boolean expired = false;
        private final IntervalUtil interval = new IntervalUtil(1f, 1f);
        private transient FleetMemberAPI lastMember = null;

        CRBuff(float buffAmount) {
            this.buffAmount = buffAmount;
        }

        @Override
        public void advance(float days) {
            interval.advance(days);
            if (interval.intervalElapsed()) {
                if (lastMember != null) {
                    if (lastMember.getFleetData() == null ||
                            lastMember.getFleetData().getFleet() == null ||
                            !lastMember.getFleetData().getFleet().isAlive()) {
                        expired = true;
                    }
                }
            }
        }

        @Override
        public void apply(FleetMemberAPI member) {
            lastMember = member;
            member.getStats().getBaseCRRecoveryRatePercentPerDay().modifyPercent("uw_pillagebuff", buffAmount);
            member.getStats().getCRLossPerSecondPercent().modifyMult("uw_pillagebuff", 100f / (100f + buffAmount));
            member.getStats().getCRPerDeploymentPercent().modifyPercent("uw_pillagebuff", 100f / (100f + buffAmount));
            member.getStats().getPeakCRDuration().modifyPercent("uw_pillagebuff", buffAmount);
            member.getStats().getRepairRatePercentPerDay().modifyPercent("uw_pillagebuff", buffAmount);
        }

        @Override
        public String getId() {
            return "uw_pillagebuff";
        }

        @Override
        public boolean isExpired() {
            return expired;
        }

        void setBuffAmount(float buffAmount, FleetMemberAPI member) {
            if (buffAmount != this.buffAmount) {
                apply(member);
            }
            this.buffAmount = buffAmount;
        }
    }

    private static class MarketDamage implements EveryFrameScript {

        private boolean done = false;
        private final float duration;
        private boolean halved = false;
        private final IntervalUtil interval = new IntervalUtil(5f, 10f);
        private final MarketAPI market;
        private final int severity;
        private float timer;

        MarketDamage(float duration, int severity, MarketAPI market) {
            this.duration = duration;
            timer = duration;
            this.severity = severity;
            this.market = market;

            for (CommodityOnMarketAPI commodity : market.getAllCommodities()) {
                float stockpile = commodity.getStockpile();
                if (commodity.isNonEcon() || stockpile <= 1f) {
                    continue;
                }
                if (severity == 1) {
                    commodity.removeFromStockpile(stockpile * 0.2f);
                } else {
                    commodity.removeFromStockpile(stockpile * 0.3f);
                }
            }
            for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
                if (curr == market) {
                    continue;
                }
                MarketConnectionAPI conn = Global.getSector().getEconomy().getConnection(market, curr);
                conn.getPriceMod().modifyMult("uw_pillage", MathUtils.getRandomNumberInRange(2f, 3f));
                conn.getSmugglingMod().modifyMult("uw_pillage", MathUtils.getRandomNumberInRange(1f, 2f));
            }

            //market.setSize(market.getSize() - severity);
            for (MarketConditionAPI condition : market.getConditions()) {
                MarketConditionPlugin plugin = condition.getPlugin();
                if (plugin instanceof UW_Pillaged) {
                    plugin.setParam(new UW_Pillaged.ConditionInfo(severity,
                                                                  ((UW_Pillaged) plugin).getInfo().stabilityImpact));
                }
            }
        }

        @Override
        public void advance(float amount) {
            if (timer <= 0f) {
                done = true;
                return;
            }

            float days = Global.getSector().getClock().convertToDays(amount);
            interval.advance(days);
            if (interval.intervalElapsed()) {
                for (CommodityOnMarketAPI commodity : market.getAllCommodities()) {
                    float stockpile = commodity.getStockpile();
                    if (commodity.isNonEcon() || stockpile <= 1f) {
                        continue;
                    }
                    if (severity == 1) {
                        commodity.removeFromStockpile(stockpile * 0.1f);
                    } else {
                        commodity.removeFromStockpile(stockpile * 0.15f);
                    }
                }
            }

            timer -= days;
            if (timer <= 0f) {
                done = true;

                if (halved) {
                    //market.setSize(market.getSize() + severity / 2);
                } else {
                    //market.setSize(market.getSize() + severity);
                }
                int unrest = 0;
                for (MarketConditionAPI condition : market.getConditions()) {
                    MarketConditionPlugin plugin = condition.getPlugin();
                    if (plugin instanceof UW_Pillaged) {
                        unrest = (int) ((UW_Pillaged) plugin).getInfo().stabilityImpact;
                    }
                }
                for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (curr == market) {
                        continue;
                    }
                    MarketConnectionAPI conn = Global.getSector().getEconomy().getConnection(market, curr);
                    conn.getPriceMod().unmodify("uw_pillage");
                    conn.getSmugglingMod().unmodify("uw_pillage");
                }
                causeRecentUnrest(market, unrest);
                market.removeCondition("uw_pillaged");
            }

            if (timer <= duration / 2f && !halved && severity > 1) {
                halved = true;

                //market.setSize((market.getSize() + severity) - severity / 2);
                for (MarketConditionAPI condition : market.getConditions()) {
                    MarketConditionPlugin plugin = condition.getPlugin();
                    if (plugin instanceof UW_Pillaged) {
                        plugin.setParam(new UW_Pillaged.ConditionInfo(severity / 2,
                                                                      ((UW_Pillaged) plugin).getInfo().stabilityImpact));
                    }
                }
            }
        }

        @Override
        public boolean isDone() {
            return done;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }
}
