package data.scripts.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin.ReputationAdjustmentResult;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin.RepActionEnvelope;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin.RepActions;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

public class UW_RepTrackerEvent extends BaseEventPlugin {

    private String otherFleetName = null;
    private CampaignEventTarget tempTarget = null;

    @Override
    public CampaignEventCategory getEventCategory() {
        return CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    @Override
    public CampaignEventTarget getEventTarget() {
        if (tempTarget != null) {
            return tempTarget;
        }
        return super.getEventTarget();
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        if (otherFleetName != null) {
            map.put("$otherFleetName", otherFleetName);
        }
        if (Global.getSector().getPersistentData().get("uw_currentPillageEvent") != null) {
			UW_PillageEvent event = ((UW_PillageEvent) Global.getSector().getPersistentData().get("uw_currentPillageEvent"));
            map.put("$planet", event.getEventTarget().getEntity().getName());
            map.put("$pillageFleet", event.getPillageFleet().getFullName());
			map.put("$sender", event.getPillageFleet().getFaction().getDisplayName());
        }

        return map;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void reportBattleFinished(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (Global.getSector().getPersistentData().get("uw_currentPillageEvent") == null) {
            return;
        }

        if (!battle.isPlayerInvolved()) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!battle.knowsWhoPlayerIs(battle.getSideFor(playerFleet)) || battle.getPlayerSide().size() <= 1) {
            return;
        }

        final CampaignFleetAPI pillageFleet = ((UW_PillageEvent) Global.getSector().getPersistentData().get("uw_currentPillageEvent")).getPillageFleet();
        if (pillageFleet == null || !pillageFleet.isAlive() || !battle.isInvolved(pillageFleet) || !battle.isOnPlayerSide(pillageFleet)) {
            return;
        }

        String[] names = new String[battle.getOtherSideFor(playerFleet).size()];
        int i = 0;
        for (CampaignFleetAPI other : battle.getOtherSideFor(playerFleet)) {
            names[i] = other.getNameWithFaction();
            i++;
        }
        otherFleetName = Misc.getAndJoined(names);

        float fpDestroyed = 0;
        for (CampaignFleetAPI fleet : battle.getOtherSideFor(playerFleet)) {
            fpDestroyed += Misc.getSnapshotFPLost(fleet) * battle.getPlayerInvolvementFraction();
        }

        tempTarget = new CampaignEventTarget(pillageFleet);
        RepLevel level = playerFleet.getFaction().getRelationshipLevel(pillageFleet.getFaction());
        final float fp = fpDestroyed;
        if (fp > 0 && level.isAtWorst(RepLevel.HOSTILE)) {
            Global.getSector().reportEventStage(this, "battle_rep_positive", pillageFleet, MessagePriority.ENSURE_DELIVERY, new BaseOnMessageDeliveryScript() {
                boolean deliver = true;

                @Override
                public void beforeDelivery(CommMessageAPI message) {
                    ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation(new RepActionEnvelope(
                                               RepActions.COMBAT_WITH_ENEMY, new Float(fp), message, true), pillageFleet.getFaction().getId());
                    deliver = Math.abs(result.delta) >= 0.01f;
                }

                @Override
                public boolean shouldDeliver() {
                    return deliver;
                }
            });
        }
    }

    @Override
    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}