
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
        Asset( "ANIM", "anim/rin.zip" ),
		Asset("SOUND", "sound/wathgrithr.fsb"),
		Asset( "ANIM", "anim/ghost_rin_build.zip" ),

}
local prefabs = {}



local function common_postinit(inst)

	inst:AddTag("spiderwhisperer")
    inst:AddTag("monster")
	
	inst.MiniMapEntity:SetIcon("rin.tex")
end

local function master_postinit(inst)
	
	inst.components.locomotor.walkspeed = 4.8
	inst.components.locomotor.runspeed = 7.2
	
	inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	inst.components.health:SetMaxHealth(110)
	inst.components.hunger:SetMax(130)
	inst.components.sanity:SetMax(150)
	
	
	inst.soundsname = "wathgrithr"
	
	
	inst:RemoveTag("scarytoprey")
	inst:AddTag('<span class="searchlite">birdwhisperer</span>')
	inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODTYPE.MEAT })
	
	

end



local start_inv = 
{
	
}


STRINGS.CHARACTER_TITLES.rin = "Hoshizora Rin"
STRINGS.CHARACTER_NAMES.rin = "Rin"
STRINGS.CHARACTER_DESCRIPTIONS.rin = "*Neko Idol. \n Love Live School Idol"
STRINGS.CHARACTER_QUOTES.rin = "\"Nya~!\""

return MakePlayerCharacter("rin", prefabs, assets, common_postinit, master_postinit, start_inv)
