﻿-- ======================================================================================================================= --
-- ------------------------------------- BATTLEGROUND : ARMORED PACKS - by 2S v2.3.7 ------------------------------------- --
-- ----------------------------------------------------------------------------------------------------------------------- --
-- NOTE:														   --
-- Please do not distribute this code without permission. 								   --
-- You may modify this code only for personal use.									   --
-- But if you use this code as source code for your mod, please credit me when you do that. I will really happy for that.  --
-- Thank you for using this mod, have fun..										   --
-- ----------------------------------------------------------------------------------------------------------------- 2S -- --
-- ======================================================================================================================= --

local BattlegroundBSs7 = {}
function BattlegroundBSs7.unload()
end

local Notification = {}

function Notification.unload() end
function Notification.init() end
function Notification.tick() end

function notify(msg) 
	UI._SET_NOTIFICATION_TEXT_ENTRY("STRING")
	UI._ADD_TEXT_COMPONENT_STRING(msg)
	UI._DRAW_NOTIFICATION(FALSE, FALSE)
end

-------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

AssaultSquadFollow = true
AssaultSquadStay = false

SNIPERSquadFollow = true
SNIPERSquadStay = false

ATSquadFollow = true
ATSquadStay = false

allSquadRoE = false
AssaultSquadRoE = false
SNIPERSquadRoE = false
ATSquadRoE = false

local showSCSMenu = false
openSCSMenu = false

------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainSCSInit()
	APSCSGUI = APSCSGUIinit()

	--MENU
	APSCSGUI.mainMenu("main", "", "~gl~~h~SQUAD COMMAND SYSTEM", 0.26, 0.598, 0.137, 0.0292, 0.003, 0.35, 2)
	APSCSGUI.addButton("main", "[ RoE :", allSquadRoEscs,"", true, 0.35, 6)
	APSCSGUI.addButton("main", "ALL SQUAD", APSCSGUI.setActiveMenu, "menu2", false, 0.35, 2)
	APSCSGUI.addButton("main", "ASSAULT SQUAD", APSCSGUI.setActiveMenu, "menu3", false, 0.35, 2)
	APSCSGUI.addButton("main", "SNIPER SQUAD", APSCSGUI.setActiveMenu, "menu4", false, 0.35, 2)
	APSCSGUI.addButton("main", "AT SQUAD", APSCSGUI.setActiveMenu, "menu5", false, 0.35, 2)

	APSCSGUI.mainMenu("menu2", "main", "~gl~~h~ALL SQUAD", 0.26, 0.662, 0.137, 0.0292, 0.003, 0.35, 2)
	APSCSGUI.addButton("menu2", "Follow", allSquadFollow,"", false, 0.35, 0)
	APSCSGUI.addButton("menu2", "Stay", allSquadStay,"", false, 0.35, 0)
	APSCSGUI.addButton("menu2", "PREV <<<", APSCSGUI.setActiveMenu, "main", false, 0.35, 2)

	APSCSGUI.mainMenu("menu3", "main", "~gl~~h~Assault SQUAD", 0.26, 0.662, 0.137, 0.0292, 0.003, 0.35, 2)
	APSCSGUI.addButton("menu3", "Follow", AssaultSquadFollow,"", false, 0.35, 0)
	APSCSGUI.addButton("menu3", "Stay", AssaultSquadStay,"", false, 0.35, 0)
	APSCSGUI.addButton("menu3", "PREV <<<", APSCSGUI.setActiveMenu, "main", false, 0.35, 2)

	APSCSGUI.mainMenu("menu4", "main", "~gl~~h~SNIPER SQUAD", 0.26, 0.662, 0.137, 0.0292, 0.003, 0.35, 2)
	APSCSGUI.addButton("menu4", "Follow", SNIPERSquadFollow,"", false, 0.35, 0)
	APSCSGUI.addButton("menu4", "Stay", SNIPERSquadStay,"", false, 0.35, 0)
	APSCSGUI.addButton("menu4", "PREV <<<", APSCSGUI.setActiveMenu, "main", false, 0.35, 2)

	APSCSGUI.mainMenu("menu5", "main", "~gl~~h~SNIPER SQUAD", 0.26, 0.662, 0.137, 0.0292, 0.003, 0.35, 2)
	APSCSGUI.addButton("menu5", "Follow", ATSquadFollow,"", false, 0.35, 0)
	APSCSGUI.addButton("menu5", "Stay", ATSquadStay,"", false, 0.35, 0)
	APSCSGUI.addButton("menu5", "PREV <<<", APSCSGUI.setActiveMenu, "main", false, 0.35, 2)
end

-------------------------------------------------------------------------------------------------------------------

local BattlegroundBSs7 = {}
function BattlegroundBSs7.unload()
end
function BattlegroundBSs7.init()
mainSCSInit()
end
function BattlegroundBSs7.tick()
	APSCSGUI.tick()	
end

function APSCSGUIinit()
	APSCSGUI = {}
	APSCSGUI.menu = {}
	APSCSGUI.buttons = {}
	APSCSGUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APSCSGUI.activeButton = 1
	APSCSGUI.activeMenu = ""
	APSCSGUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APSCSGUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if (APSCSGUI.menu[menuName] == nil) then
			APSCSGUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APSCSGUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APSCSGUI.addButton(mainMenu, text, funct, args, selectable, textScale, font)
		if (APSCSGUI.buttons[mainMenu] == nil or APSCSGUI.buttons[mainMenu]["settings"] == nil) then
			APSCSGUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APSCSGUI.buttons[mainMenu].settings + 1
		APSCSGUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APSCSGUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APSCSGUI.menu[mainMenu].xmin,
			["ymin"] = APSCSGUI.menu[mainMenu].lastOffset,["xmax"] = APSCSGUI.menu[mainMenu].xmax,
			["ymax"] = APSCSGUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APSCSGUI.menu[mainMenu]["lastOffset"] = (APSCSGUI.menu[mainMenu].lastOffset + APSCSGUI.menu[mainMenu].ymax + APSCSGUI.menu[mainMenu].spacing)
	end

	function APSCSGUI.setActiveMenu(menuName)
		APSCSGUI.activeButton = 1
		APSCSGUI.activeMenu = menuName
	end

	function APSCSGUI.drawIndex()
		if (nextDrawTime == nil or prevText ~= APSCSGUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APSCSGUI.IndexStatus.time
		end

		if (nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APSCSGUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APSCSGUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APSCSGUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButtonText(text, xmin, ymin, textScale, font)
		if (text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.25)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APSCSGUI.setActiveMenu("")
		end
	end

	function APSCSGUI.drawAPSCSGUI()
		if (APSCSGUI.activeMenu ~= "" and APSCSGUI.activeMenu ~= nil) then
			local name = APSCSGUI.activeMenu

			if(APSCSGUI.menu[name] ~= nil) then
				local xmin = APSCSGUI.menu[name].xmin
				local ymin = APSCSGUI.menu[name].ymin
				local xmax = APSCSGUI.menu[name].xmax
				local ymax = APSCSGUI.menu[name].ymax
				
				local text = APSCSGUI.menu[name].title
				local textScale = APSCSGUI.menu[name].textScale
				local font = APSCSGUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 170}

				addButtonText(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if (APSCSGUI.buttons[name] ~= nil) then
					for i, v in pairs(APSCSGUI.buttons[name].settings) do
						local buttonSettings = APSCSGUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 80, ["g"] = 80, ["b"] = 80, ["o"] = 100}

						if (buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " Hold Fire ]"

						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " Return Fire ]"
						end
						
						if (i == APSCSGUI.activeButton) then
							colors = {["r"] = 80, ["g"] = 170, ["b"] = 120, ["o"] = 125}
						end

						addButtonText(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APSCSGUI.setActiveMenu("")
				end
			else
				APSCSGUI.setActiveMenu("")
			end
		end
	end

	function APSCSGUI.updateIndexStatus(text, time)
		APSCSGUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APSCSGUI.isButtonselectableOn()
		local activeButton = APSCSGUI.buttons[APSCSGUI.activeMenu].settings[APSCSGUI.activeButton]
		if (activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == false) then
			--print("Button \"", APSCSGUI.buttons[APSCSGUI.activeMenu].settings[APSCSGUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APSCSGUI.toggleButtonState()
		local activeButton = APSCSGUI.buttons[APSCSGUI.activeMenu].settings[APSCSGUI.activeButton]
		
		if (APSCSGUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
			print("toggled off")
		elseif(APSCSGUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APSCSGUI.tick()
		APSCSGUI.drawIndex()
		APSCSGUI.drawAPSCSGUI()

		for i, key in pairs(APSCSGUI.updateSelection.menuOpen.keys) do
			if (get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if (APSCSGUI.activeMenu == APSCSGUI.updateSelection.menuOpen.menu) then
						openSCSMenu = false
						APSCSGUI.setActiveMenu(APSCSGUI.menu[APSCSGUI.activeMenu].prevMenu)
						AUDIO.PLAY_SOUND_FRONTEND(-1, "TRAFFIC_CONTROL_LIGHT_SWITCH_BACK", "BIG_SCORE_3A_SOUNDS", true)
					else
						openSCSMenu = true
						APSCSGUI.setActiveMenu(APSCSGUI.updateSelection.menuOpen.menu)
						APSCSGUI.currentSelection = 1
						AUDIO.PLAY_SOUND_FRONTEND(-1, "ERROR", "HUD_AMMO_SHOP_SOUNDSET", true)
					end
				end
			
			end
		end

		for k, key in pairs(APSCSGUI.updateSelection.menuUp.keys) do
			if (get_key_pressed(key) and APSCSGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSCSGUI.activeButton = APSCSGUI.activeButton - 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "PIN_BUTTON", "ATM_SOUNDS", true)
					if (APSCSGUI.activeButton <= 0) then
						APSCSGUI.activeButton = APSCSGUI.menu[APSCSGUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APSCSGUI.updateSelection.menuDown.keys) do
			if (get_key_pressed(key) and APSCSGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSCSGUI.activeButton = APSCSGUI.activeButton + 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "PIN_BUTTON", "ATM_SOUNDS", true)
					if (APSCSGUI.activeButton > APSCSGUI.menu[APSCSGUI.activeMenu].numButtons) then
						APSCSGUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APSCSGUI.updateSelection.select.keys) do
			if (get_key_pressed(key) and APSCSGUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APSCSGUI.buttons[APSCSGUI.activeMenu].settings[APSCSGUI.activeButton]
				AUDIO.PLAY_SOUND_FRONTEND(0, "PIN_BUTTON", "ATM_SOUNDS", true)

				if (type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APSCSGUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif (type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APSCSGUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif (currButton.args == nil) then
					APSCSGUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APSCSGUI.updateSelection.menuCancel.keys) do
			if (get_key_pressed(key) and APSCSGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSCSGUI.setActiveMenu(APSCSGUI.menu[APSCSGUI.activeMenu].prevMenu)
					AUDIO.PLAY_SOUND_FRONTEND(0, "PIN_BUTTON", "ATM_SOUNDS", true)
				end
			
			end
		end
	end

	return APSCSGUI
end

-------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

--PRICES
local PMC1Cost = 38000
local PMC2Cost = 50000
local PMC3Cost = 63000
local PMCSuV1Cost = 43000
local PMCSuV2Cost = 95000
local PMCSuT1Cost = 70000
local PMCSuT2Cost = 65000
local PMCSUheli1Cost = 72000
local PMCSUheli2Cost = 28000
local PMCSUjet1Cost = 105000
local PMCSUjet2Cost = 155000

local timeHeal = 5
local healingCost = 500

local timeStrikes = 5
local strikePredator = true
local strikePrecision = false
local strikeArty1 = false
local strikeArty2 = false

strikeZero = false
strikeRange15 = false
strikeRange25 = true
strikeRange50 = false
strikeRange75 = false
strikeRange100 = false

--NAME
local PMCSU1SuName  = "Ground Technical"
local PMCSU2SuName  = "Ground Infantry"
local PMCSUtank1SuName  = "Armored Cavalry"
local PMCSUheli1SuName  = "Air"
local PMCSUjet1SuName  = "Air"
local PMCSUjet2SuName  = "Advanced Air"

local buy = false
local SuName = "not set"

local spawned = false

------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------

function BattlegroundBSs7.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)
	local playerPosition = ENTITY.GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(playerPed, 0.0, 5.0, 0.0)
	local playerGroup = PED.GET_PED_GROUP_INDEX(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )

	--OPEN MENU
	if (playerExists and get_key_pressed(SCSMKey) and showSCSMenu == false and 
	not PED._IS_PED_DEAD(playerPed, true) and spawnBASBu == true or
	playerExists and get_key_pressed(SCSMKey) and showSCSMenu == false and 
	not PED._IS_PED_DEAD(playerPed, true) and spawnBASBu1 == true or
	playerExists and get_key_pressed(SCSMKey) and showSCSMenu == false and 
	not PED._IS_PED_DEAD(playerPed, true) and spawnBASBu2 == true or
	playerExists and get_key_pressed(SCSMKey) and showSCSMenu == false and 
	not PED._IS_PED_DEAD(playerPed, true) and spawnBASBu3 == true or
	playerExists and get_key_pressed(SCSMKey) and showSCSMenu == false and 
	not PED._IS_PED_DEAD(playerPed, true) and spawnBASBu4 == true or
	playerExists and get_key_pressed(SCSMKey) and showSCSMenu == false and 
	not PED._IS_PED_DEAD(playerPed, true) and spawnBASBu5 == true) then
		showSCSMenu = true
	end

	if (playerExists and get_key_pressed(SCSMKey) and showSCSMenu == true) then
		showSCSMenu = true
	elseif (spawnBASBu == false and spawnBASBu1 == false and spawnBASBu2 == false and
	spawnBASBu3 == false and spawnBASBu4 == false and spawnBASBu5 == false) then
		showSCSMenu = false
	end

	--SHOW MENU
	if(showSCSMenu == true and not PED.IS_PED_RUNNING_MOBILE_PHONE_TASK(playerPed)) then
		APSCSGUI.tick()
	end
end
-----------------------------------------------------------------------
------------------------------ SCS ------------------------------------
---------- ALL SQUAD ----------------
-------------------------------------
function allSquadFollow()
	notify("~gl~~h~Roger. Able team, regrouping.")
	AssaultSquadFollow = true
	SNIPERSquadFollow = true
	ATSquadFollow = true

	AssaultSquadStay = false
	SNIPERSquadStay = false
	ATSquadStay = false
	print("All Follow")
end

function allSquadStay()
	notify("~gl~~h~Roger. Able team, holding position.")
	AssaultSquadFollow = false
	SNIPERSquadFollow = false
	ATSquadFollow = false

	AssaultSquadStay = true
	SNIPERSquadStay = true
	ATSquadStay = true
	print("All Stay")
end

function allSquadRoEscs()
	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)

	if playerExists and AssaultSquadRoE == true and SNIPERSquadRoE == true and ATSquadRoE == true then
		allSquadRoE = false
	end

	if playerExists and AssaultSquadRoE == false and SNIPERSquadRoE == false and ATSquadRoE == false then
		allSquadRoE = true
	end
end
-------------------------------------
---------- ASSAULT SQUAD ----------------
-------------------------------------
function AssaultSquadFollow()
	if (spawnBASBu == true and spawnBASBu1 == true and spawnBASBu2 == true) then
		notify("~gl~~h~This is assault squad, going to your location.")
		AssaultSquadFollow = true
		AssaultSquadStay = false
		print("Assault Follow")
	else
		notify("~gl~~h~No assault squad available.")
	end
end

function AssaultSquadStay()
	if (spawnBASBu == true or spawnBASBu1 == true or spawnBASBu2 == true) then
		notify("~gl~~h~Roger, assault squad holding position.")
		AssaultSquadFollow = false
		AssaultSquadStay = true
		print("Assault Stay")
	else
		notify("~gl~~h~No assault squad available.")
	end
end

-------------------------------------
--------- SNIPER SQUAD --------------
-------------------------------------
function SNIPERSquadFollow()
	if (spawnBASBu3 == true and spawnBASBu4 == true) then
		notify("~gl~~h~Copy that. Sniper team, regrouping.")
		SNIPERSquadFollow = true
		SNIPERSquadStay = false
		print("SNIPER Follow")
	else
		notify("~gl~~h~No sniper team available.")
	end
end

function SNIPERSquadStay()
	if (spawnBASBu3 == true and spawnBASBu4 == true) then
		notify("~gl~~h~Copy that sir, sniper team hold and waiting.")
		SNIPERSquadFollow = false
		SNIPERSquadStay = true
		print("SNIPER Stay")
	else
		notify("~gl~~h~No sniper team available.")
	end
end

-------------------------------------
------------ AT SQUAD ---------------
-------------------------------------
function ATSquadFollow()
	if (spawnBASBu5 == true and spawnBASBu6 == true) then
		notify("~gl~~h~Roger that sir, following.")
		ATSquadFollow = true
		ATSquadStay = false
		print("AT Follow")
	else
		notify("~gl~~h~No AT troops available.")
	end
end

function ATSquadStay(i)
	if (spawnBASBu5 == true and spawnBASBu6 == true) then
		notify("~gl~~h~Roger that sir, We stay in position.")
		ATSquadFollow = false
		ATSquadStay = true
		print("AT Stay")
	else
		notify("~gl~~h~No AT soldiers available.")
	end
end


------------------------------------------------------------------------------
return BattlegroundBSs7

-- Credits to: Alexander Blade & headscript--