﻿-- ======================================================================================================================= --
-- ------------------------------------- BATTLEGROUND : ARMORED PACKS - by 2S v2.3.7 ------------------------------------- --
-- ----------------------------------------------------------------------------------------------------------------------- --
-- NOTE:														   --
-- Please do not distribute this code without permission. 								   --
-- You may modify this code only for personal use.									   --
-- But if you use this code as source code for your mod, please credit me when you do that. I will really happy for that.  --
-- Thank you for using this mod, have fun..										   --
-- ----------------------------------------------------------------------------------------------------------------- 2S -- --
-- ======================================================================================================================= --

local ArmoredPacksGcfMod = {}
function ArmoredPacksGcfMod.unload()
end

local Notification = {}

function Notification.unload() end
function Notification.init() end
function Notification.tick() end

function notify(msg) 
	UI._SET_NOTIFICATION_TEXT_ENTRY("STRING")
	UI._ADD_TEXT_COMPONENT_STRING(msg)
	UI._DRAW_NOTIFICATION(FALSE, FALSE)
end

--DISPLAY BLIP
blipGcf = UI.ADD_BLIP_FOR_COORD(-1757.880,427.758,127.685)
		UI.SET_BLIP_COLOUR(blipGcf, 1)
		UI.SET_BLIP_SPRITE(blipGcf, 426)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blipGcf, "Gambetti Crime Family")
		UI.SET_BLIP_SCALE(blipGcf, 1)
		UI.SET_BLIP_AS_SHORT_RANGE(blipGcf, true)

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainGcfInit()
	APGcfGUI = APGcfGUIinit()

	--MENU
	APGcfGUI.mainMenu("main", "", "Italian Crime Synd - CLASSIC", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APGcfGUI.addButton1("main", "Vapid Peyote $150000", spawnItalianVehicle,"peyote", false, 0.35, 0)
	APGcfGUI.addButton1("main", "Truffade Z-Type $10000000", spawnItalianVehicle,"ztype", false, 0.35, 0)
	APGcfGUI.addButton1("main", "Pegassi Monroe $490000", spawnItalianVehicle,"monroe", false, 0.35, 0)
	APGcfGUI.addButton1("main", "Lampadati Pigalle $400000", spawnItalianVehicle,"pigalle", false, 0.35, 0)
	APGcfGUI.addButton1("main", "Invetero Coquette Classic $395000", spawnItalianVehicle,"coquette2", false, 0.35, 0)
	APGcfGUI.addButton1("main", "NEXT >", APGcfGUI.setActiveMenu, "menu2", false, 0.35, 1)
	
	APGcfGUI.mainMenu("menu2", "main", "Italian Crime Synd - CLASSIC", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APGcfGUI.addButton1("menu2", "Grotti Stinger GT $1000000", spawnItalianVehicle,"stingergt", false, 0.35, 0)
	APGcfGUI.addButton1("menu2", "Dewbauchee JB 700 $475000", spawnItalianVehicle,"jb700", false, 0.35, 0)
	APGcfGUI.addButton1("menu2", "Declasse Tornado $380000", spawnItalianVehicle,"tornado", false, 0.35, 0)
	APGcfGUI.addButton1("menu2", "Albany Manana $341742", spawnItalianVehicle,"manana", false, 0.35, 0)
	APGcfGUI.addButton1("menu2", "Albany Roosevelt $6341245", spawnItalianVehicle,"btype", false, 0.35, 0)
	APGcfGUI.addButton1("menu2", "PREV <", APGcfGUI.setActiveMenu, "main", false, 0.35, 1)
end

-------------------------------------------------------------------------------------------------------------------

local ArmoredPacksGcfMod = {}
function ArmoredPacksGcfMod.unload()
end
function ArmoredPacksGcfMod.init()
mainGcfInit()
end
function ArmoredPacksGcfMod.tick()
		APGcfGUI.tick()		
end

function APGcfGUIinit()
	APGcfGUI = {}
	APGcfGUI.menu = {}
	APGcfGUI.buttons = {}
	APGcfGUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APGcfGUI.activeButton = 1
	APGcfGUI.activeMenu = ""
	APGcfGUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APGcfGUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APGcfGUI.menu[menuName] == nil) then
			APGcfGUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APGcfGUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APGcfGUI.addButton1(mainMenu, text, funct, args, selectable, textScale, font)
		if(APGcfGUI.buttons[mainMenu] == nil or APGcfGUI.buttons[mainMenu]["settings"] == nil) then
			APGcfGUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APGcfGUI.buttons[mainMenu].settings + 1
		APGcfGUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APGcfGUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APGcfGUI.menu[mainMenu].xmin,
			["ymin"] = APGcfGUI.menu[mainMenu].lastOffset,["xmax"] = APGcfGUI.menu[mainMenu].xmax,
			["ymax"] = APGcfGUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APGcfGUI.menu[mainMenu]["lastOffset"] = (APGcfGUI.menu[mainMenu].lastOffset + APGcfGUI.menu[mainMenu].ymax + APGcfGUI.menu[mainMenu].spacing)
	end

	function APGcfGUI.setActiveMenu(menuName)
		APGcfGUI.activeButton = 1
		APGcfGUI.activeMenu = menuName
	end

	function APGcfGUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APGcfGUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APGcfGUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APGcfGUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APGcfGUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APGcfGUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButton1Text(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APGcfGUI.setActiveMenu("")
		end
	end

	function APGcfGUI.drawAPGcfGUI()
		if(APGcfGUI.activeMenu ~= "" and APGcfGUI.activeMenu ~= nil) then
			local name = APGcfGUI.activeMenu

			if(APGcfGUI.menu[name] ~= nil) then
				local xmin = APGcfGUI.menu[name].xmin
				local ymin = APGcfGUI.menu[name].ymin
				local xmax = APGcfGUI.menu[name].xmax
				local ymax = APGcfGUI.menu[name].ymax
				
				local text = APGcfGUI.menu[name].title
				local textScale = APGcfGUI.menu[name].textScale
				local font = APGcfGUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButton1Text(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APGcfGUI.buttons[name] ~= nil) then
					for i, v in pairs(APGcfGUI.buttons[name].settings) do
						local buttonSettings = APGcfGUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 90, ["g"] = 90, ["b"] = 90, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APGcfGUI.activeButton) then
							colors = {["r"] = 120, ["g"] = 120, ["b"] = 120, ["o"] = 200}
						end

						addButton1Text(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APGcfGUI.setActiveMenu("")
				end
			else
				APGcfGUI.setActiveMenu("")
			end
		end
	end

	function APGcfGUI.updateIndexStatus(text, time)
		APGcfGUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APGcfGUI.isButtonselectableOn()
		local activeButton = APGcfGUI.buttons[APGcfGUI.activeMenu].settings[APGcfGUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APGcfGUI.buttons[APGcfGUI.activeMenu].settings[APGcfGUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APGcfGUI.toggleButtonState()
		local activeButton = APGcfGUI.buttons[APGcfGUI.activeMenu].settings[APGcfGUI.activeButton]
		
		if(APGcfGUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APGcfGUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APGcfGUI.tick()
		APGcfGUI.drawIndex()
		APGcfGUI.drawAPGcfGUI()

		for i, key in pairs(APGcfGUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APGcfGUI.activeMenu == APGcfGUI.updateSelection.menuOpen.menu) then
						APGcfGUI.setActiveMenu(APGcfGUI.menu[APGcfGUI.activeMenu].prevMenu)
						AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
					else
					  	APGcfGUI.setActiveMenu(APGcfGUI.updateSelection.menuOpen.menu)
					   	APGcfGUI.currentSelection = 1
						AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
					end
				end
			
			end
		end

		for k, key in pairs(APGcfGUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APGcfGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APGcfGUI.activeButton = APGcfGUI.activeButton - 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APGcfGUI.activeButton <= 0) then
						APGcfGUI.activeButton = APGcfGUI.menu[APGcfGUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APGcfGUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APGcfGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APGcfGUI.activeButton = APGcfGUI.activeButton + 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APGcfGUI.activeButton > APGcfGUI.menu[APGcfGUI.activeMenu].numButtons) then
						APGcfGUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APGcfGUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APGcfGUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APGcfGUI.buttons[APGcfGUI.activeMenu].settings[APGcfGUI.activeButton]
				AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APGcfGUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APGcfGUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APGcfGUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APGcfGUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APGcfGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APGcfGUI.setActiveMenu(APGcfGUI.menu[APGcfGUI.activeMenu].prevMenu)
					AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
				end
			
			end
		end
	end

	return APGcfGUI
end

-------------------------------------------------------------------------------------------------------------------

--PRICES
	--CLASSIC
local clspeyoteCost = 150000
local clsztypeCost = 10000000
local clsmonroeCost = 490000
local clspigalleCost = 400000
local clscoquetteclassicCost = 395000
local clsstingergtCost = 1000000
local clsjb700Cost = 475000
local clstornadoCost = 380000
local clsmananaCost = 341742 
local clsrooseveltCost = 631245

--CARNAME
	--CLASSIC
local clspeyoteCarName = "Vapid Peyote"
local clsztypeCarName = "Truffade Z-Type"
local clsmonroeCarName = "Pegassi Monroe"
local clspigalleCarName = "Lampadati Pigalle"
local clscoquetteclassicCarName = "Invetero Coquette Classic"
local clsstingergtCarName = "Grotti Stinger GT"
local clsjb700CarName = "Dewbauchee JB 700"
local clstornadoCarName = "Declasse Tornado"
local clsmananaCarName = "Albany Manana"
local clsrooseveltCarName = "Albany Roosevelt"

local showMenu = false

local buy = false
local timebuy = 99999
local buyLimitGCF = false
local CarName = "not set"

local spawned = false
local gb5Ped
local sentinelGCF1
local washingtonGCF1

--DO NOT EDIT BEYOND THIS POINT
-------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------

function ArmoredPacksGcfMod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, -1757.880, 427.758, 127.685, true	)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(gb5Ped, true) then
			BGAP2SHUD.DrawTextNotif1("The dealer is not here. Please come", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif1("back later.", renHUDyNotif + 0.0265, renHUDxNotif, 0.355)
			GRAPHICS.DRAW_RECT(0.158, 0.084, 0.215, 0.0685, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
		else
			BGAP2SHUD.DrawTextNotif1("Press      to browse clasic cars.", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif2("~u~E", renHUDyNotif + 0.0025, renHUDxNotif + 0.035, 0.31)
			GRAPHICS.DRAW_RECT(0.138, 0.074, 0.175, 0.0485, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
			GRAPHICS.DRAW_RECT(0.095, 0.071, 0.0134, 0.0235, redHUDNotif2, greenHUDNotif2, blueHUDNotif2, alphaHUDNotif2)
		
			if (get_key_pressed(DFMKey) and showMenu == false) then
				notify("Hello, you have something in your mind?")
				showMenu = true
			end
		end
	end

	--SHOW MENU
	if(showMenu == true) then
		APGcfGUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and showMenu == true) then
		showMenu = false
	end

	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-1757.880, 427.758, 127.685, false ) < 150 ) then
		spawnGCFDealer()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-1757.880, 427.758, 127.685, false ) > 150 ) then
		PED.DELETE_PED(gb5Ped)
		PED.DELETE_PED(gg5Ped[0])
		PED.DELETE_PED(gg5Ped[1])
		PED.DELETE_PED(gg5Ped[2])
		PED.DELETE_PED(gg5Ped[3])
		PED.DELETE_PED(gg5Ped[4])
		PED.DELETE_PED(gg5Ped[5])
		PED.DELETE_PED(gg5Ped[6])
		PED.DELETE_PED(gg5Ped[7])
		PED.DELETE_PED(gg5Ped[8])
		PED.DELETE_PED(gg5Ped[9])
		PED.DELETE_PED(gg5Ped[10])
		PED.DELETE_PED(gg5Ped[11])
		PED.DELETE_PED(gg5Ped[12])
		PED.DELETE_PED(gg5Ped[13])
		PED.DELETE_PED(gg5Ped[14])
		PED.DELETE_PED(gg5Ped[15])
		PED.DELETE_PED(gg5Ped[16])
		PED.DELETE_PED(gg5Ped[17])
		PED.DELETE_PED(gg5Ped[18])
		PED.DELETE_PED(gg5Ped[19])
		PED.DELETE_PED(gg5Ped[20])
		PED.DELETE_PED(gg5Ped[21])
		GCFbossMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GCFboss)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GCFgoon)
		spawned = false
	end
		if (buyLimitGCF == true and TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
		buyLimitGCF = false
	end
end

--DEALER SPAWN
function ArmoredPacksGcfMod.unload()
	UI.REMOVE_BLIP(blipGcf)
	if spawned == true then
		PED.DELETE_PED(gb5Ped)
		PED.DELETE_PED(gg5Ped[0])
		PED.DELETE_PED(gg5Ped[1])
		PED.DELETE_PED(gg5Ped[2])
		PED.DELETE_PED(gg5Ped[3])
		PED.DELETE_PED(gg5Ped[4])
		PED.DELETE_PED(gg5Ped[5])
		PED.DELETE_PED(gg5Ped[6])
		PED.DELETE_PED(gg5Ped[7])
		PED.DELETE_PED(gg5Ped[8])
		PED.DELETE_PED(gg5Ped[9])
		PED.DELETE_PED(gg5Ped[10])
		PED.DELETE_PED(gg5Ped[11])
		PED.DELETE_PED(gg5Ped[12])
		PED.DELETE_PED(gg5Ped[13])
		PED.DELETE_PED(gg5Ped[14])
		PED.DELETE_PED(gg5Ped[15])
		PED.DELETE_PED(gg5Ped[16])
		PED.DELETE_PED(gg5Ped[17])
		PED.DELETE_PED(gg5Ped[18])
		PED.DELETE_PED(gg5Ped[19])
		PED.DELETE_PED(gg5Ped[20])
		PED.DELETE_PED(gg5Ped[21])
		GCFbossMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GCFboss)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GCFgoon)
	end
end

function spawnGCFDealer()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_GUSENBERG")
	local weapon2 = GAMEPLAY.GET_HASH_KEY("WEAPON_SMG")
	local weapon3 = GAMEPLAY.GET_HASH_KEY("WEAPON_SNIPERRIFLE")
	local weapon4 = GAMEPLAY.GET_HASH_KEY("WEAPON_RPG")

	---GCFBOSS---
	GCFboss = GAMEPLAY.GET_HASH_KEY("S_M_M_HighSec_01")
	STREAMING.REQUEST_MODEL(GCFboss)
	while(not STREAMING.HAS_MODEL_LOADED(GCFboss)) do
		wait(50)
	end
	gb5Ped = PED.CREATE_PED(1, GCFboss, -1757.880, 427.758, 127.685, 73, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gb5Ped, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gb5Ped, weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gb5Ped, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gb5Ped, false)
	PED.SET_PED_RANDOM_PROPS(gb5Ped)
	GCFbossMoney = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(8000,100000))
	PED.SET_PED_MONEY(gb5Ped, GCFbossMoney)

	---GCFGOON---
	GCFgoon = GAMEPLAY.GET_HASH_KEY("S_M_M_HighSec_02")

	STREAMING.REQUEST_MODEL(GCFgoon)
	
	while(not STREAMING.HAS_MODEL_LOADED(GCFgoon)) do
		wait(50)
	end
	
	gg5Ped = {}
	
	gg5Ped[0] = PED.CREATE_PED(1, GCFgoon, -1780, 421.629, 122.641, 181, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[0], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[0])
	
	gg5Ped[1] = PED.CREATE_PED(1, GCFgoon, -1791.245, 410.551, 113.453, 174, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[1], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[1])
	
	gg5Ped[2] = PED.CREATE_PED(1, GCFgoon, -1821.457, 421.538, 121.516, 171, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[2], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[2], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[2], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[2], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[2])
	
	gg5Ped[3] = PED.CREATE_PED(1, GCFgoon, -1844.453, 431.076, 126.109, 162, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[3], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[3], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[3], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[3], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[3])

	gg5Ped[4] = PED.CREATE_PED(1, GCFgoon, -1839.982, 437.087, 126.109, 152, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[4], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[4], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[4], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[4], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[4])

	gg5Ped[5] = PED.CREATE_PED(1, GCFgoon, -1818.585, 427.861, 132.307, 178, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[5], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[5], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[5], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[5], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[5])

	gg5Ped[6] = PED.CREATE_PED(1, GCFgoon, -1805.766, 427.729, 128.508, 175, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[6], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[6], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[6], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[6], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[6])

	gg5Ped[7] = PED.CREATE_PED(1, GCFgoon, -1812.339, 438.740, 128.707, 265, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[7], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[7], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[7], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[7], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[7])
	
	gg5Ped[8] = PED.CREATE_PED(1, GCFgoon, -1804.017, 437.517, 128.707, 359, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[8], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[8], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[8], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[8], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[8])

	gg5Ped[9] = PED.CREATE_PED(1, GCFgoon, -1763.980, 444.456, 127.281, 171, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[9], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[9], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[9], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[9], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[9])

	gg5Ped[10] = PED.CREATE_PED(1, GCFgoon, -1774.621, 454.489, 129.149, 208, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[10], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[10], weapon4, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[10], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[10], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[10])

	gg5Ped[11] = PED.CREATE_PED(1, GCFgoon, -1784.365, 433.374, 128.108, 271, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[11], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[11], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[11], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[11], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[11])

	gg5Ped[12] = PED.CREATE_PED(1, GCFgoon, -1786.713, 445.725, 128.108, 176, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[12], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[12], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[12], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[12], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[12])

	gg5Ped[13] = PED.CREATE_PED(1, GCFgoon, -1787.180, 426.949, 122.641, 265, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[13], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[13], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[13], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[13], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[13])

	gg5Ped[14] = PED.CREATE_PED(1, GCFgoon, -1787.476, 417.822, 132.303, 220, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[14], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[14], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[14], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[14], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[14])

	gg5Ped[15] = PED.CREATE_PED(1, GCFgoon, -1790.556, 409.721, 116.320, 173, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[15], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[15], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[15], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[15], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[15])

	gg5Ped[16] = PED.CREATE_PED(1, GCFgoon, -1794.483, 409.871, 116.320, 179, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[16], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[16], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[16], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[16], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[16])

	gg5Ped[17] = PED.CREATE_PED(1, GCFgoon, -1818.910, 412.457, 128.307, 139, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[17], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[17], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[17], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[17], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[17])

	gg5Ped[18] = PED.CREATE_PED(1, GCFgoon, -1799.962, 408.000, 128.308, 167, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[18], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[18], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[18], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[18], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[18])

	gg5Ped[19] = PED.CREATE_PED(1, GCFgoon, -1791.061, 417.555, 132.303, 182, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[19], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[19], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[19], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[19], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[19])

	gg5Ped[20] = PED.CREATE_PED(1, GCFgoon, -1787.686, 421.376, 132.303, 293, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[20], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[20], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[20], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[20], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[20])

	gg5Ped[21] = PED.CREATE_PED(1, GCFgoon, -1788.061, 435.491, 132.303, 272, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(gg5Ped[21], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(gg5Ped[21], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(gg5Ped[21], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(gg5Ped[21], false)
	PED.SET_PED_RANDOM_PROPS(gg5Ped[21])
	
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY("sentinel"))
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY("washington"))
	
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY("sentinel"))) do
		wait(50)
	end

	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY("washington"))) do
		wait(50)
	end
	
	sentinelGCF1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("sentinel"), -1792.100, 395.652, 112.791, 81, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(sentinelGCF1)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(sentinelGCF1, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(sentinelGCF1, false)
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(sentinelGCF1)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(sentinelGCF1))

	washingtonGCF1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("washington"), -1791.769, 460.964, 128.308, 101, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(washingtonGCF1)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(washingtonGCF1, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(washingtonGCF1, false)
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(washingtonGCF1)	
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(washingtonGCF1))
	
end

-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--VEHICLE SPAWN
function spawnItalianVehicle(modelString)

	if (buyLimitGCF == false and (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("peyote")) then cost = clspeyoteCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ztype")) then cost = clsztypeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("monroe")) then cost = clsmonroeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("pigalle")) then cost = clspigalleCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("coquette2")) then cost = clscoquetteclassicCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("stingergt")) then cost = clsstingergtCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("jb700")) then cost = clsjb700Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("tornado")) then cost = clstornadoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("manana")) then cost = clsmananaCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("btype")) then cost = clsrooseveltCost
		end
		
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("peyote")) then CarName = clspeyoteCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ztype")) then CarName = clsztypeCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("monroe")) then CarName = clsmonroeCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("pigalle")) then CarName = clspigalleCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("coquette2")) then CarName = clscoquetteclassicCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("stingergt")) then CarName = clsstingergtCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("jb700")) then CarName = clsjb700CarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("tornado")) then CarName = clstornadoCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("manana")) then CarName = clsmananaCarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("btype")) then CarName = clsrooseveltCarName
		end

	Pay(cost)

		if (buyFalse == false and buyLimitGCF == false) then
		spawnItalianVehicleNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry but you don't have enough money.")
		buyFalse = false
		end

	elseif(buyLimitGCF == true and TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
		notify("Wait for another shipment, come back tomorrow.")
	end

end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnItalianVehicleNow(modelString)

	print (timebuy)
	print (TIME.GET_CLOCK_DAY_OF_MONTH())
	print (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

	if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	buyLimitGCF = true
	
	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)

	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
		
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehI = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), -1794.194, 404.243, 113.122, 162, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehI)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehI, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehI, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehI, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehI, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehI, 0)
	VEHICLE.SET_VEHICLE_MOD(vehI, 16, 4, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehI, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehI, 3) 
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehI, true) 
	VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(vehI, true) 
	VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(vehI, true) 			
	VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehI, 0, 0, 0)
	VEHICLE.SET_VEHICLE_CUSTOM_SECONDARY_COLOUR(vehI, 0, 0, 0)
	VEHICLE.SET_VEHICLE_NUMBER_PLATE_TEXT(vehI, "5YND1C4T")
		
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehI)
		
	buy = true
	notify("Your " .. CarName .. " is already delivered. Thank you!")
	end
	end
		wait(5)
				
end


------------------------------------------------------------------------------
return ArmoredPacksGcfMod

-- Credits to: Alexander Blade & headscript--