﻿-- ======================================================================================================================= --
-- ------------------------------------- BATTLEGROUND : ARMORED PACKS - by 2S v2.3.7 ------------------------------------- --
-- ----------------------------------------------------------------------------------------------------------------------- --
-- NOTE:														   --
-- Please do not distribute this code without permission. 								   --
-- You may modify this code only for personal use.									   --
-- But if you use this code as source code for your mod, please credit me when you do that. I will really happy for that.  --
-- Thank you for using this mod, have fun..										   --
-- ----------------------------------------------------------------------------------------------------------------- 2S -- --
-- ======================================================================================================================= --

local ArmoredPacksLmcMod = {}
function ArmoredPacksLmcMod.unload()
end

local Notification = {}

function Notification.unload() end
function Notification.init() end
function Notification.tick() end

function notify(msg) 
	UI._SET_NOTIFICATION_TEXT_ENTRY("STRING")
	UI._ADD_TEXT_COMPONENT_STRING(msg)
	UI._DRAW_NOTIFICATION(FALSE, FALSE)
end

--DISPLAY BLIP
blipLmc = UI.ADD_BLIP_FOR_COORD(718.895,-621.118,27.949)
		UI.SET_BLIP_COLOUR(blipLmc, 1)
		UI.SET_BLIP_SPRITE(blipLmc, 426)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blipLmc, "The Lost MC")
		UI.SET_BLIP_SCALE(blipLmc, 1)		
		UI.SET_BLIP_AS_SHORT_RANGE(blipLmc, true)

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainLmcInit()
	APLmcGUI = APLmcGUIinit()

	--MENU
	APLmcGUI.mainMenu("main", "", "THE LOST MC - MOTORCYCLE", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APLmcGUI.addButton1("main", "Dinka Akuma $9400", spawnTLMCMoto,"akuma", false, 0.35, 0)
	APLmcGUI.addButton1("main", "WMC Bagger $7700", spawnTLMCMoto,"bagger", false, 0.35, 0)	
	APLmcGUI.addButton1("main", "Bati 801 $12000", spawnTLMCMoto,"bati", false, 0.35, 0)
	APLmcGUI.addButton1("main", "Bati 801RR $15500", spawnTLMCMoto,"bati2", false, 0.35, 0)
	APLmcGUI.addButton1("main", "Nagasaki Carbon RS $42000", spawnTLMCMoto,"carbonrs", false, 0.35, 0)
	APLmcGUI.addButton1("main", "WMC Daemon $22200", spawnTLMCMoto,"daemon", false, 0.35, 0)
	APLmcGUI.addButton1("main", "Dinka Double-T $12300", spawnTLMCMoto,"double", false, 0.35, 0)
	APLmcGUI.addButton1("main", "Principe Faggio $5050", spawnTLMCMoto,"faggio2", false, 0.35, 0)
	APLmcGUI.addButton1("main", "NEXT >", APLmcGUI.setActiveMenu, "menu2", false, 0.35, 1)
	
	APLmcGUI.mainMenu("menu2", "main", "THE LOST MC - MOTORCYCLE", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APLmcGUI.addButton1("menu2", "Principe Nemesis $13000", spawnTLMCMoto,"nemesis", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "Shitzu PCJ-600 $9600", spawnTLMCMoto,"pcj", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "Pegassi Ruffian $11000", spawnTLMCMoto,"ruffian", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "Maibatsu Sanchez Atomic $8500", spawnTLMCMoto,"sanchez", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "Maibatsu Sanchez $8400", spawnTLMCMoto,"sanchez2", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "Shitzu Vader $9200", spawnTLMCMoto,"vader", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "Dinka Thrust 76000", spawnTLMCMoto,"thrust", false, 0.35, 0)
	APLmcGUI.addButton1("menu2", "PREV <", APLmcGUI.setActiveMenu, "main", false, 0.35, 1)
	APLmcGUI.addButton1("menu2", "NEXT >", APLmcGUI.setActiveMenu, "menu3", false, 0.35, 1)

	APLmcGUI.mainMenu("menu3", "main", "THE LOST MC - MOTORCYCLE", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APLmcGUI.addButton1("menu3", "WMC Sovereign $125000", spawnTLMCMoto,"sovereign", false, 0.35, 0)	
	APLmcGUI.addButton1("menu3", "LCC Innovation $97000", spawnTLMCMoto,"innovation", false, 0.35, 0)
	APLmcGUI.addButton1("menu3", "Shitzu Hakuchou $195000", spawnTLMCMoto,"hakuchou", false, 0.35, 0)
	APLmcGUI.addButton1("menu3", "Dinka Enduro $155000", spawnTLMCMoto,"enduro", false, 0.35, 0)
	APLmcGUI.addButton1("menu3", "Principe Lectro $777000", spawnTLMCMoto,"lectro", false, 0.35, 0)
	APLmcGUI.addButton1("menu3", "PREV <", APLmcGUI.setActiveMenu, "menu2", false, 0.35, 1)
end

-------------------------------------------------------------------------------------------------------------------

local ArmoredPacksLmcMod = {}
function ArmoredPacksLmcMod.unload()
end
function ArmoredPacksLmcMod.init()
mainLmcInit()
end
function ArmoredPacksLmcMod.tick()	
		APLmcGUI.tick()		
end

function APLmcGUIinit()
	APLmcGUI = {}
	APLmcGUI.menu = {}
	APLmcGUI.buttons = {}
	APLmcGUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APLmcGUI.activeButton = 1
	APLmcGUI.activeMenu = ""
	APLmcGUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APLmcGUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APLmcGUI.menu[menuName] == nil) then
			APLmcGUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APLmcGUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APLmcGUI.addButton1(mainMenu, text, funct, args, selectable, textScale, font)
		if(APLmcGUI.buttons[mainMenu] == nil or APLmcGUI.buttons[mainMenu]["settings"] == nil) then
			APLmcGUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APLmcGUI.buttons[mainMenu].settings + 1
		APLmcGUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APLmcGUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APLmcGUI.menu[mainMenu].xmin,
			["ymin"] = APLmcGUI.menu[mainMenu].lastOffset,["xmax"] = APLmcGUI.menu[mainMenu].xmax,
			["ymax"] = APLmcGUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APLmcGUI.menu[mainMenu]["lastOffset"] = (APLmcGUI.menu[mainMenu].lastOffset + APLmcGUI.menu[mainMenu].ymax + APLmcGUI.menu[mainMenu].spacing)
	end

	function APLmcGUI.setActiveMenu(menuName)
		APLmcGUI.activeButton = 1
		APLmcGUI.activeMenu = menuName
	end

	function APLmcGUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APLmcGUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APLmcGUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APLmcGUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APLmcGUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APLmcGUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButton1Text(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APLmcGUI.setActiveMenu("")
		end
	end

	function APLmcGUI.drawAPLmcGUI()
		if(APLmcGUI.activeMenu ~= "" and APLmcGUI.activeMenu ~= nil) then
			local name = APLmcGUI.activeMenu

			if(APLmcGUI.menu[name] ~= nil) then
				local xmin = APLmcGUI.menu[name].xmin
				local ymin = APLmcGUI.menu[name].ymin
				local xmax = APLmcGUI.menu[name].xmax
				local ymax = APLmcGUI.menu[name].ymax
				
				local text = APLmcGUI.menu[name].title
				local textScale = APLmcGUI.menu[name].textScale
				local font = APLmcGUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButton1Text(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APLmcGUI.buttons[name] ~= nil) then
					for i, v in pairs(APLmcGUI.buttons[name].settings) do
						local buttonSettings = APLmcGUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 90, ["g"] = 20, ["b"] = 20, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APLmcGUI.activeButton) then
							colors = {["r"] = 120, ["g"] = 50, ["b"] = 50, ["o"] = 200}
						end

						addButton1Text(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APLmcGUI.setActiveMenu("")
				end
			else
				APLmcGUI.setActiveMenu("")
			end
		end
	end

	function APLmcGUI.updateIndexStatus(text, time)
		APLmcGUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APLmcGUI.isButtonselectableOn()
		local activeButton = APLmcGUI.buttons[APLmcGUI.activeMenu].settings[APLmcGUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APLmcGUI.buttons[APLmcGUI.activeMenu].settings[APLmcGUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APLmcGUI.toggleButtonState()
		local activeButton = APLmcGUI.buttons[APLmcGUI.activeMenu].settings[APLmcGUI.activeButton]
		
		if(APLmcGUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APLmcGUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APLmcGUI.tick()
		APLmcGUI.drawIndex()
		APLmcGUI.drawAPLmcGUI()

		for i, key in pairs(APLmcGUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APLmcGUI.activeMenu == APLmcGUI.updateSelection.menuOpen.menu) then
						APLmcGUI.setActiveMenu(APLmcGUI.menu[APLmcGUI.activeMenu].prevMenu)
						AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
					else
					  	APLmcGUI.setActiveMenu(APLmcGUI.updateSelection.menuOpen.menu)
					   	APLmcGUI.currentSelection = 1
						AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
					end
				end
			
			end
		end

		for k, key in pairs(APLmcGUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APLmcGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APLmcGUI.activeButton = APLmcGUI.activeButton - 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APLmcGUI.activeButton <= 0) then
						APLmcGUI.activeButton = APLmcGUI.menu[APLmcGUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APLmcGUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APLmcGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APLmcGUI.activeButton = APLmcGUI.activeButton + 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APLmcGUI.activeButton > APLmcGUI.menu[APLmcGUI.activeMenu].numButtons) then
						APLmcGUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APLmcGUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APLmcGUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APLmcGUI.buttons[APLmcGUI.activeMenu].settings[APLmcGUI.activeButton]
				AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APLmcGUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APLmcGUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APLmcGUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APLmcGUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APLmcGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APLmcGUI.setActiveMenu(APLmcGUI.menu[APLmcGUI.activeMenu].prevMenu)
					AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
				end
			
			end
		end
	end

	return APLmcGUI
end

-------------------------------------------------------------------------------------------------------------------

--PRICES
	--MOTORCYCLE
local MotoAkumaCost = 9400
local MotoBaggerCost = 7700
local MotoBatiCost = 12000
local MotoBatiRRCost = 15500
local MotoCarbonRSCost = 42000
local MotoDaemonCost = 22200
local MotoDoubleTCost = 12300
local MotoFaggioCost = 5050
local MotoHexerCost = 15800
local MotoNemesisCost = 13000
local MotoPCJ600Cost = 9600
local MotoRuffianCost = 11000
local MotoSanchezCost = 8500
local MotoSanchez2Cost = 8400
local MotoVaderCost = 9200
local MotoThrustCost = 76000
local MotoSovereignCost = 125000
local MotoInnovationCost = 97000
local MotoHakuchouCost = 195000
local MotoEnduroCost = 155000
local MotoLectroCost = 777000

--MOTONAME
	--MOTORCYCLE
local MotoAkumaMotoName = "Dinka Akuma"
local MotoBaggerMotoName = "WMC Bagger"
local MotoBatiMotoName = "Bati 801"
local MotoBatiRRMotoName = "Bati 801RR"
local MotoCarbonRSMotoName = "Nagasaki Carbon RS"
local MotoDaemonMotoName = "WMC Daemon"
local MotoDoubleTMotoName = "Dinka Double-T"
local MotoFaggioMotoName = "Principe Faggio"
local MotoHexerMotoName = "LCC Hexer"
local MotoNemesisMotoName = "Principe Nemesis"
local MotoPCJ600MotoName = "Shitzu PCJ-600"
local MotoRuffianMotoName = "Pegassi Ruffian"
local MotoSanchezMotoName = "Maibatsu Sanchez Atomic"
local MotoSanchez2MotoName = "Maibatsu Sanchez"
local MotoVaderMotoName = "Shitzu Vader"
local MotoThrustMotoName = "Dinka Thrust"
local MotoSovereignMotoName = "WMC Sovereign"
local MotoInnovationMotoName = "LCC Innovation"
local MotoHakuchouMotoName = "Shitzu Hakuchou"
local MotoEnduroMotoName = "Dinka Enduro"
local MotoLectroMotoName = "Principe Lectro"

local showMenu = false

local buy = false
local timebuy = 99999
local buyLimitLMC = false
local MotoName = "not set"

local spawned = false
local tl2Ped
local burritoL1
local burritoL2
local burritoL3
local burritoL4
local hexerL1

-------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------

function ArmoredPacksLmcMod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, 718.895, -621.118, 27.949, true	)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(tl2Ped, true) then
			BGAP2SHUD.DrawTextNotif1("The dealer is not here. Please come", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif1("back later.", renHUDyNotif + 0.0265, renHUDxNotif, 0.355)
			GRAPHICS.DRAW_RECT(0.158, 0.084, 0.215, 0.0685, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
		else
			BGAP2SHUD.DrawTextNotif1("Press      to browse motorcycle.", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif2("~u~E", renHUDyNotif + 0.0025, renHUDxNotif + 0.035, 0.31)
			GRAPHICS.DRAW_RECT(0.138, 0.074, 0.175, 0.0485, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
			GRAPHICS.DRAW_RECT(0.095, 0.071, 0.0134, 0.0235, redHUDNotif2, greenHUDNotif2, blueHUDNotif2, alphaHUDNotif2)
		
			if (get_key_pressed(DFMKey) and showMenu == false) then
				notify("Hello my friend, what can i get for you?")
				showMenu = true
			end
		end
	end

	--SHOW MENU
	if(showMenu == true) then
		APLmcGUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and showMenu == true) then
		showMenu = false
	end

	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,718.895, -621.118, 27.949, false ) < 150 ) then
		spawnTLMCDealer()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,718.895, -621.118, 27.949, false ) > 150 ) then
		PED.DELETE_PED(tl2Ped)
		PED.DELETE_PED(tlt2Ped[0])
		PED.DELETE_PED(tlt2Ped[1])
		PED.DELETE_PED(tlt2Ped[2])
		PED.DELETE_PED(tlt2Ped[3])
		PED.DELETE_PED(tlt2Ped[4])
		PED.DELETE_PED(tlt2Ped[5])
		PED.DELETE_PED(tlt2Ped[6])
		PED.DELETE_PED(tlt2Ped[7])
		PED.DELETE_PED(tlt2Ped[8])
		PED.DELETE_PED(tlt2Ped[9])
		PED.DELETE_PED(tlt2Ped[10])
		PED.DELETE_PED(tlt2Ped[11])
		PED.DELETE_PED(tlt2Ped[12])
		PED.DELETE_PED(tlt2Ped[13])
		PED.DELETE_PED(tlt2Ped[14])
		tlboosMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(tlboos)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(tlthug)
		spawned = false
	end
		
	if (buyLimitLMC == true and TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
		buyLimitLMC = false
	end
end

--DEALER SPAWN
function ArmoredPacksLmcMod.unload()
	UI.REMOVE_BLIP(blipLmc)
	if spawned == true then
		PED.DELETE_PED(tl2Ped)
		PED.DELETE_PED(tlt2Ped[0])
		PED.DELETE_PED(tlt2Ped[1])
		PED.DELETE_PED(tlt2Ped[2])
		PED.DELETE_PED(tlt2Ped[3])
		PED.DELETE_PED(tlt2Ped[4])
		PED.DELETE_PED(tlt2Ped[5])
		PED.DELETE_PED(tlt2Ped[6])
		PED.DELETE_PED(tlt2Ped[7])
		PED.DELETE_PED(tlt2Ped[8])
		PED.DELETE_PED(tlt2Ped[9])
		PED.DELETE_PED(tlt2Ped[10])
		PED.DELETE_PED(tlt2Ped[11])
		PED.DELETE_PED(tlt2Ped[12])
		PED.DELETE_PED(tlt2Ped[13])
		PED.DELETE_PED(tlt2Ped[14])
		tlboosMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(tlboos)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(tlthug)
	end
end

function spawnTLMCDealer()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_MICROSMG")
	local weapon2 = GAMEPLAY.GET_HASH_KEY("WEAPON_PUMPSHOTGUN")
	local weapon3 = GAMEPLAY.GET_HASH_KEY("WEAPON_PISTOL")

	---TLBOSS---
	tlboos = GAMEPLAY.GET_HASH_KEY("G_M_Y_Lost_02")
	STREAMING.REQUEST_MODEL(tlboos)
	while(not STREAMING.HAS_MODEL_LOADED(tlboos)) do
		wait(50)
	end
	tl2Ped = PED.CREATE_PED(1, tlboos, 718.895, -621.118, 27.949, 198, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tl2Ped, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tl2Ped, weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tl2Ped, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tl2Ped, false)
	PED.SET_PED_RANDOM_PROPS(tl2Ped)
	tlboosMoney = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(5000,50000))
	PED.SET_PED_MONEY(tl2Ped, tlboosMoney)

	---TLTHUG---
	tlthug = GAMEPLAY.GET_HASH_KEY("G_M_Y_Lost_01")

	STREAMING.REQUEST_MODEL(tlthug)
	
	while(not STREAMING.HAS_MODEL_LOADED(tlthug)) do
		wait(50)
	end
	
	tlt2Ped = {}
	
	tlt2Ped[0] = PED.CREATE_PED(1, tlthug, 715.608, -624.204, 27.153, 263, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[0], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[0])
	
	tlt2Ped[1] = PED.CREATE_PED(1, tlthug, 729.779, -621.168, 28.168, 179, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[1], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[1])
	
	tlt2Ped[2] = PED.CREATE_PED(1, tlthug, 706.407, -624.635, 27.258, 95, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[2], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[2], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[2], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[2], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[2])
	
	tlt2Ped[3] = PED.CREATE_PED(1, tlthug, 697.918, -632.228, 26.297, 76, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[3], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[3], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[3], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[3], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[3])

	tlt2Ped[4] = PED.CREATE_PED(1, tlthug, 704.080, -645.546, 26.980, 322, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[4], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[4], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[4], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[4], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[4])

	tlt2Ped[5] = PED.CREATE_PED(1, tlthug, 715.280, -635.025, 27.964, 209, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[5], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[5], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[5], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[5], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[5])

	tlt2Ped[6] = PED.CREATE_PED(1, tlthug, 731.564, -632.874, 28.443, 25, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[6], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[6], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[6], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[6], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[6])

	tlt2Ped[7] = PED.CREATE_PED(1, tlthug, 751.883, -621.884, 28.765, 276, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[7], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[7], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[7], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[7], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[7])
	
	tlt2Ped[8] = PED.CREATE_PED(1, tlthug, 735.779, -620.477, 28.597, 7, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[8], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[8], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[8], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[8], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[8])

	tlt2Ped[9] = PED.CREATE_PED(1, tlthug, 711.944, -621.621, 30.250, 234, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[9], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[9], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[9], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[9], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[9])

	tlt2Ped[10] = PED.CREATE_PED(1, tlthug, 728.049, -650.737, 28.101, 174, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[10], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[10], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[10], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[10], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[10])

	tlt2Ped[11] = PED.CREATE_PED(1, tlthug, 737.227, -649.613, 28.312, 320, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[11], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[11], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[11], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[11], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[11])

	tlt2Ped[12] = PED.CREATE_PED(1, tlthug, 735.162, -644.149, 28.514, 280, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[12], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[12], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[12], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[12], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[12])

	tlt2Ped[13] = PED.CREATE_PED(1, tlthug, 707.965, -621.558, 27.626, 270, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[13], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[13], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[13], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[13], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[13])

	tlt2Ped[14] = PED.CREATE_PED(1, tlthug, 749.027, -634.887, 28.628, 60, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(tlt2Ped[14], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(tlt2Ped[14], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(tlt2Ped[14], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(tlt2Ped[14], false)
	PED.SET_PED_RANDOM_PROPS(tlt2Ped[14])
	
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY("gburrito"))
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY("hexer"))	

	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY("gburrito"))) do
		wait(50)
	end
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY("hexer"))) do
		wait(50)
	end

	burritoL1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("gburrito"), 740.660, -629.133, 28.794, 82, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(burritoL1)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(burritoL1, true) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(burritoL1, false)	
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(burritoL1)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(burritoL1))

	burritoL2 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("gburrito"), 703.249, -629.628, 27.097, 34, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(burritoL2)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(burritoL2, true) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(burritoL2, false)	
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(burritoL2)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(burritoL2))
	
	burritoL3 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("gburrito"), 704.089, -638.196, 27.185, 68, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(burritoL3)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(burritoL3, true) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(burritoL3, false)	
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(burritoL3)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(burritoL3))

	burritoL4 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("gburrito"), 719.081, -653.040, 27.867, 181, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(burritoL4)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(burritoL4, true) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(burritoL4, false)	
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(burritoL4)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(burritoL4))

	hexerL1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY("hexer"), 725.464, -622.879, 28.292, 174, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(hexerL1)
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(hexerL1, true) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(hexerL1, false)	
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(hexerL1)
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(hexerL1))
end

--MOTO SPAWN
function spawnTLMCMoto(modelString)

	if (buyLimitLMC == false and (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("akuma")) then cost = MotoAkumaCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bagger")) then cost = MotoBaggerCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bati")) then cost = MotoBatiCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bati2")) then cost = MotoBatiRRCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("carbonrs")) then cost = MotoCarbonRSCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("daemon")) then cost = MotoDaemonCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("double")) then cost = MotoDoubleTCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("faggio2")) then cost = MotoFaggioCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hexer")) then cost = MotoHexerCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("nemesis")) then cost = MotoNemesisCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("pcj")) then cost = MotoPCJ600Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ruffian")) then cost = MotoRuffianCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sanchez")) then cost = MotoSanchezCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sanchez2")) then cost = MotoSanchez2Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vader")) then cost = MotoVaderCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("thrust")) then cost = MotoThrustCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sovereign")) then cost = MotoSovereignCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("innovation")) then cost = MotoInnovationCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hakuchou")) then cost = MotoHakuchouCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("enduro")) then cost = MotoEnduroCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lectro")) then cost = MotoLectroCost
		end
	
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("akuma")) then MotoName = MotoAkumaMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bagger")) then MotoName = MotoBaggerMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bati")) then MotoName = MotoBatiMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bati2")) then MotoName = MotoBatiRRMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("carbonrs")) then MotoName = MotoCarbonRSMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("daemon")) then MotoName = MotoDaemonMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("double")) then MotoName = MotoDoubleTMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("faggio2")) then MotoName = MotoFaggioMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hexer")) then MotoName = MotoHexerMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("nemesis")) then MotoName = MotoNemesisMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("pcj")) then MotoName = MotoPCJ600MotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("ruffian")) then MotoName = MotoRuffianMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sanchez")) then MotoName = MotoSanchezMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sanchez2")) then MotoName = MotoSanchez2MotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vader")) then MotoName = MotoVaderMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("thrust")) then MotoName = MotoThrustMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("sovereign")) then MotoName = MotoSovereignMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("innovation")) then MotoName = MotoInnovationMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hakuchou")) then MotoName = MotoHakuchouMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("enduro")) then MotoName = MotoEnduroMotoName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lectro")) then MotoName = MotoLectroMotoName
		end

	Pay(cost)

		if (buyFalse == false and buyLimitLMC == false) then
		spawnTLMCMotoNow(modelString)
		end

		if (buyFalse == true) then
		notify("You don't have enough money.")
		buyFalse = false
		end

	elseif(buyLimitLMC == true and TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
		notify("Wait for another shipment.")
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnTLMCMotoNow(modelString)

	print (timebuy)
	print (TIME.GET_CLOCK_DAY_OF_MONTH())
	print (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

	if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	buyLimitLMC = true
	
	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)

	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
	
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then
		
	local motoLMC = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString),  720.558, -627.389, 28.021, 176, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(motoLMC)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(motoLMC, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(motoLMC, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(motoLMC, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(motoLMC, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(motoLMC, 0)
	VEHICLE.SET_VEHICLE_MOD(motoLMC, 16, 3, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(motoLMC, 120)
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(motoLMC, true)
	VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(motoLMC, false) 
	VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(motoLMC, false) 			
	VEHICLE.SET_VEHICLE_NUMBER_PLATE_TEXT(motoLMC, "L057")
		
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(motoLMC)
		
	buy = true
	notify("Your " .. MotoName .. " is already delivered. Lost forever!")
	end
	end
		wait(5)
end

------------------------------------------------------------------------------
return ArmoredPacksLmcMod

-- Credits to: Alexander Blade & headscript--