﻿-- ======================================================================================================================= --
-- ------------------------------------- BATTLEGROUND : ARMORED PACKS - by 2S v2.3.7 ------------------------------------- --
-- ----------------------------------------------------------------------------------------------------------------------- --
-- NOTE:														   --
-- Please do not distribute this code without permission. 								   --
-- You may modify this code only for personal use.									   --
-- But if you use this code as source code for your mod, please credit me when you do that. I will really happy for that.  --
-- Thank you for using this mod, have fun..										   --
-- ----------------------------------------------------------------------------------------------------------------- 2S -- --
-- ======================================================================================================================= --

local ArmoredPacksm4hPMod = {}
function ArmoredPacksm4hPMod.unload()
end

--DISPLAY BLIP
blipm4hP = UI.ADD_BLIP_FOR_COORD(857.989,2877.070,57.983)
		UI.SET_BLIP_COLOUR(blipm4hP, 1)
		UI.SET_BLIP_SPRITE(blipm4hP, 84)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blipm4hP, "Men4Hired")
		UI.SET_BLIP_SCALE(blipm4hP, 1)
		UI.SET_BLIP_AS_SHORT_RANGE(blipm4hP, true)

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainM4hPInit()
	APM4hPGUI = APM4hPGUIinit()

	--MENU
	APM4hPGUI.mainMenu("main", "", "MERRYWEATHER SECURITY - MEN 4 HIRED", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APM4hPGUI.addButton1("main", "Burrito & 3 Men $20000", spawnM4H,"gburrito2", false, 0.35, 0)
	APM4hPGUI.addButton1("main", "Bison & 5 Men $32000", spawnM4H,"bison", false, 0.35, 0)	
	APM4hPGUI.addButton1("main", "Sadler & 7 Men $39000", spawnM4H,"granger", false, 0.35, 0)
end

-------------------------------------------------------------------------------------------------------------------

local ArmoredPacksm4hPMod = {}
function ArmoredPacksm4hPMod.unload()
end
function ArmoredPacksm4hPMod.init()
mainM4hPInit()
end
function ArmoredPacksm4hPMod.tick()
		APM4hPGUI.tick()
end

function APM4hPGUIinit()
	APM4hPGUI = {}
	APM4hPGUI.menu = {}
	APM4hPGUI.buttons = {}
	APM4hPGUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APM4hPGUI.activeButton = 1
	APM4hPGUI.activeMenu = ""
	APM4hPGUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APM4hPGUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APM4hPGUI.menu[menuName] == nil) then
			APM4hPGUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APM4hPGUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APM4hPGUI.addButton1(mainMenu, text, funct, args, selectable, textScale, font)
		if(APM4hPGUI.buttons[mainMenu] == nil or APM4hPGUI.buttons[mainMenu]["settings"] == nil) then
			APM4hPGUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APM4hPGUI.buttons[mainMenu].settings + 1
		APM4hPGUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APM4hPGUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APM4hPGUI.menu[mainMenu].xmin,
			["ymin"] = APM4hPGUI.menu[mainMenu].lastOffset,["xmax"] = APM4hPGUI.menu[mainMenu].xmax,
			["ymax"] = APM4hPGUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APM4hPGUI.menu[mainMenu]["lastOffset"] = (APM4hPGUI.menu[mainMenu].lastOffset + APM4hPGUI.menu[mainMenu].ymax + APM4hPGUI.menu[mainMenu].spacing)
	end

	function APM4hPGUI.setActiveMenu(menuName)
		APM4hPGUI.activeButton = 1
		APM4hPGUI.activeMenu = menuName
	end

	function APM4hPGUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APM4hPGUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APM4hPGUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APM4hPGUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APM4hPGUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APM4hPGUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButton1Text(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APM4hPGUI.setActiveMenu("")
		end
	end

	function APM4hPGUI.drawAPM4hPGUI()
		if(APM4hPGUI.activeMenu ~= "" and APM4hPGUI.activeMenu ~= nil) then
			local name = APM4hPGUI.activeMenu

			if(APM4hPGUI.menu[name] ~= nil) then
				local xmin = APM4hPGUI.menu[name].xmin
				local ymin = APM4hPGUI.menu[name].ymin
				local xmax = APM4hPGUI.menu[name].xmax
				local ymax = APM4hPGUI.menu[name].ymax
				
				local text = APM4hPGUI.menu[name].title
				local textScale = APM4hPGUI.menu[name].textScale
				local font = APM4hPGUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButton1Text(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APM4hPGUI.buttons[name] ~= nil) then
					for i, v in pairs(APM4hPGUI.buttons[name].settings) do
						local buttonSettings = APM4hPGUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 170, ["g"] = 160, ["b"] = 130, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APM4hPGUI.activeButton) then
							colors = {["r"] = 220, ["g"] = 200, ["b"] = 180, ["o"] = 200}
						end

						addButton1Text(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APM4hPGUI.setActiveMenu("")
				end
			else
				APM4hPGUI.setActiveMenu("")
			end
		end
	end

	function APM4hPGUI.updateIndexStatus(text, time)
		APM4hPGUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APM4hPGUI.isButtonselectableOn()
		local activeButton = APM4hPGUI.buttons[APM4hPGUI.activeMenu].settings[APM4hPGUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APM4hPGUI.buttons[APM4hPGUI.activeMenu].settings[APM4hPGUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APM4hPGUI.toggleButtonState()
		local activeButton = APM4hPGUI.buttons[APM4hPGUI.activeMenu].settings[APM4hPGUI.activeButton]
		
		if(APM4hPGUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APM4hPGUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APM4hPGUI.tick()
		APM4hPGUI.drawIndex()
		APM4hPGUI.drawAPM4hPGUI()

		for i, key in pairs(APM4hPGUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APM4hPGUI.activeMenu == APM4hPGUI.updateSelection.menuOpen.menu) then
						APM4hPGUI.setActiveMenu(APM4hPGUI.menu[APM4hPGUI.activeMenu].prevMenu)
						AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
					else
					  	APM4hPGUI.setActiveMenu(APM4hPGUI.updateSelection.menuOpen.menu)
					   	APM4hPGUI.currentSelection = 1
						AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
					end
				end
			
			end
		end

		for k, key in pairs(APM4hPGUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APM4hPGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APM4hPGUI.activeButton = APM4hPGUI.activeButton - 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APM4hPGUI.activeButton <= 0) then
						APM4hPGUI.activeButton = APM4hPGUI.menu[APM4hPGUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APM4hPGUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APM4hPGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APM4hPGUI.activeButton = APM4hPGUI.activeButton + 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APM4hPGUI.activeButton > APM4hPGUI.menu[APM4hPGUI.activeMenu].numButtons) then
						APM4hPGUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APM4hPGUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APM4hPGUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APM4hPGUI.buttons[APM4hPGUI.activeMenu].settings[APM4hPGUI.activeButton]
				AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APM4hPGUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APM4hPGUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APM4hPGUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APM4hPGUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APM4hPGUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APM4hPGUI.setActiveMenu(APM4hPGUI.menu[APM4hPGUI.activeMenu].prevMenu)
					AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
				end
			
			end
		end
	end

	return APM4hPGUI
end

-------------------------------------------------------------------------------------------------------------------

--PRICES
local m4h1Cost = 18000
local m4h2Cost = 30000
local m4h3Cost = 43000

--CARNAME
local m4h1CarName = "Burrito"
local m4h2CarName = "Bison"
local m4h3CarName = "Granger"

local timeDead = 5
local showMenu = false

local buy = false
local timebuy = 99999
local buyLimitM4HP = false
local CarName = "not set"

local spawned = false
local mercSpawned = false
local ML4Ped

local guards = {}
local men4hiredInvincibleEnabled = false

local RndModels = true
local RndWeapons = true

--M4H NUMBERS
local m4hpCount = 0
local amountAllowed = 7
local amountAllowed2 = 5
local amountAllowed3 = 3

--M4H MODELS 1
local pedModel = "s_m_y_blackops_01"

--M4H WEAPONS 1
local meleeWeapon = "WEAPON_KNIFE"
local secondaryWeapon = "WEAPON_COMBATPISTOL"
local primaryWeapon = "WEAPON_CARBINERIFLE" 

--M4H MODELS 2
local RndModels_table = {"s_m_y_blackops_01", "s_m_y_blackops_02"}

--M4H WEAPONS 2
local rndMeleeWeapons = {"WEAPON_KNIFE", "WEAPON_HATCHET"}
local rndSecondaryWeapons = {"WEAPON_APPISTOL", "WEAPON_MICROSMG"}
local rndPrimaryWeapons = {"WEAPON_COMBATMG", "WEAPON_SPECIALCARBINE", "WEAPON_ASSAULTSMG"}

-------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------
--MODEL 1 LOAD
function ArmoredPacksm4hPMod.loadPedModel()
	model_hash = GAMEPLAY.GET_HASH_KEY(pedModel)

	if (not STREAMING.HAS_MODEL_LOADED(model_hash)) then
		STREAMING.REQUEST_MODEL(model_hash)
		print("[ArmoredPacksm4hPMod.loadPedModel]: Requesting Model: " .. pedModel .. "(" .. model_hash .. ")")

		while (true) do
			if (STREAMING.HAS_MODEL_LOADED(model_hash)) then
				print("[ArmoredPacksm4hPMod.loadPedModel]: Model: " .. pedModel .. "(" .. model_hash .. ")" .. " been loaded.")
				break
			end
			STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(Guard)
			wait(10)
		end
	end
end

--MODEL 1 UNLOAD
function ArmoredPacksm4hPMod.unloadPedModel()
	model_hash = GAMEPLAY.GET_HASH_KEY(pedModel)

	while (true) do
		if (STREAMING.HAS_MODEL_LOADED(model_hash)) then
			STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(model_hash)
			print("[ArmoredPacksm4hPMod.unloadPedModel]: Model: " .. pedModel .. "(" .. model_hash .. ")" .. 
			" has been set to 'NO LONGER NEEDED'." )
			break
		end
		wait(10)
	end
end

--MODELS 2 LOAD
function ArmoredPacksm4hPMod.loadRndPedModels()
	for k, v in pairs(RndModels_table) do
		model_hash = GAMEPLAY.GET_HASH_KEY(v)

		if (not STREAMING.HAS_MODEL_LOADED(model_hash)) then
			STREAMING.REQUEST_MODEL(model_hash)
			print("[ArmoredPacksm4hPMod.loadRndPedModels]: Requesting Model: " .. v .. "(" .. model_hash .. ")")

			while (true) do
				if (STREAMING.HAS_MODEL_LOADED(model_hash)) then
					print("[ArmoredPacksm4hPMod.loadRndPedModels]: Model: " .. v .. "(" .. model_hash .. ")" .. " been loaded.")
					break
				end
				wait(10)
			end
		end
	end
end

--MODELS 2 UNLOAD
function ArmoredPacksm4hPMod.unloadRndPedModels()
	for _, m in pairs(RndModels_table) do
		model_hash = GAMEPLAY.GET_HASH_KEY(m)

		while (true) do
			if (STREAMING.HAS_MODEL_LOADED(model_hash)) then
				STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(model_hash)
				print("[ArmoredPacksm4hPMod.unloadRndPedModels]: Model: " .. m .. "(" .. model_hash .. ")" .. 
				" has been set to 'NO LONGER NEEDED'." )
				break
			end
			wait(10)
		end
	end
end

--UNLOAD GUARD
function ArmoredPacksm4hPMod.unload()
	for k, guard in pairs(guards) do
		if (guard ~= nil) then 
			PED.DELETE_PED(guard)
			guards[k] = nil

			m4hpCount = 0
		end
	end
end

--DEAD GUARD
function ArmoredPacksm4hPMod.deleteOnDead()
	for k, guard in pairs(guards) do
		if (guard ~= nil) then
			if (ENTITY.IS_ENTITY_DEAD(guard) and TIME.GET_CLOCK_SECONDS() == timeDead) then
				PED.DELETE_PED(guard)
				guards[k] = nil
				m4hpCount = m4hpCount - 1
				print("[ArmoredPacksm4hPMod.deleteOnDead]: men4hired: " .. m4hpCount)
			end
		end
	end
end

function ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
	local rndMWeapon = math.random(#rndMeleeWeapons)
	local rndSWeapon = math.random(#rndSecondaryWeapons)
	local rndPWeapon = math.random(#rndPrimaryWeapons)

	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guards[i], GAMEPLAY.GET_HASH_KEY(rndMeleeWeapons[rndMWeapon]), 500, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guards[i], GAMEPLAY.GET_HASH_KEY(rndSecondaryWeapons[rndSWeapon]), 500, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guards[i], GAMEPLAY.GET_HASH_KEY(rndPrimaryWeapons[rndPWeapon]), 500, true)
end

function ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guards[i], GAMEPLAY.GET_HASH_KEY(meleeWeapon), 500, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guards[i], GAMEPLAY.GET_HASH_KEY(secondaryWeapon), 500, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(guards[i], GAMEPLAY.GET_HASH_KEY(primaryWeapon), 500, true)
end

function ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
   	local playerPed = PLAYER.PLAYER_PED_ID()
    	local playerGroup = PED.GET_PED_GROUP_INDEX(playerPed)
	local guardsBlip = UI.ADD_BLIP_FOR_ENTITY(guards[i])
		UI.SET_BLIP_SPRITE(guardsBlip, 1)
		UI.SET_BLIP_COLOUR(guardsBlip, 2)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(guardsBlip, "Friendly Unit")
		UI.SET_BLIP_AS_SHORT_RANGE(guardsBlip, false)
	
   	PED.SET_PED_CAN_SWITCH_WEAPON(guards[i], true)
	PED.SET_PED_AS_GROUP_MEMBER(guards[i], playerGroup)
	PED.SET_PED_FIRING_PATTERN(guards[i], GAMEPLAY.GET_HASH_KEY("FIRING_PATTERN_FULL_AUTO"))
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(guards[i], GAMEPLAY.GET_HASH_KEY("PLAYER"))
	PED.SET_PED_NEVER_LEAVES_GROUP(guards[i], true)
    	PED.SET_PED_ACCURACY(guards[i], 100)
	PED.ADD_ARMOUR_TO_PED(guards[i],1200)

  	ENTITY.SET_ENTITY_INVINCIBLE(guards[i], men4hiredInvincibleEnabled)
    	PED.SET_PED_CAN_BE_SHOT_IN_VEHICLE(guards[i], true)
	PED.SET_PED_RANDOM_PROPS(guards[i])
    	WEAPON.SET_PED_DROPS_WEAPONS_WHEN_DEAD(guards[i], true)

   	AI.SET_PED_PATH_CAN_USE_CLIMBOVERS(guards[i], true)
   	AI.SET_PED_PATH_CAN_USE_LADDERS(guards[i], true)
   	AI.SET_PED_PATH_CAN_DROP_FROM_HEIGHT(guards[i], true)
end

function ArmoredPacksm4hPMod.GetRndModel()
	local rndMod_1 = RndModels_table[math.random(#RndModels_table)]
	local rndMod_2 = RndModels_table[math.random(#RndModels_table)]

	if (RndMod_1 == RndMod_2 and RndMod_2 == RndMod_1) then
		return RndModels_table[math.random(#RndModels_table)]
	elseif (not RndMod_1 == RndMod_2 and not RndMod_2 == RndMod_1) then
		return RndMod_1 or RndMod_2
	end
end

function ArmoredPacksm4hPMod.teleportmen4hiredToPlayer()
	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerPosition = ENTITY.GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(playerPed, 0.0, 2.5, 0.0)

	for k, guard in pairs(guards) do
		if (guard ~= nil) then
			if (not PED.IS_PED_IN_ANY_VEHICLE(playerPed, false) and not PED.IS_PED_IN_ANY_VEHICLE(guard, false)) then
				ENTITY.SET_ENTITY_COORDS(guard, playerPosition.x, playerPosition.y,
				playerPosition.z, false, false, false, false)
			elseif(PED.IS_PED_IN_ANY_VEHICLE(playerPed, false) and not PED.IS_PED_IN_ANY_VEHICLE(guard, false)) then
				ENTITY.SET_ENTITY_COORDS(guard, playerPosition.x, playerPosition.y,
				playerPosition.z, false, false, false, false)
			end
		end
	end
end

------------------------------------------------------------------------------

function ArmoredPacksm4hPMod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, 857.989, 2877.070, 57.983, true	)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)
	local playerPosition = ENTITY.GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(playerPed, 0.0, 5.0, 0.0)
	local playerGroup = PED.GET_PED_GROUP_INDEX(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(ML4Ped, true) then
			BGAP2SHUD.DrawTextNotif1("There is no one for hired. Please come", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif1("back later.", renHUDyNotif + 0.0265, renHUDxNotif, 0.355)
			GRAPHICS.DRAW_RECT(0.158, 0.084, 0.215, 0.0685, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
		else
			BGAP2SHUD.DrawTextNotif1("Press      to hire bodyguard.", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif2("~u~E", renHUDyNotif + 0.0025, renHUDxNotif + 0.035, 0.31)
			GRAPHICS.DRAW_RECT(0.133, 0.074, 0.165, 0.0485, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
			GRAPHICS.DRAW_RECT(0.095, 0.071, 0.0134, 0.0235, redHUDNotif2, greenHUDNotif2, blueHUDNotif2, alphaHUDNotif2)
		
			if (get_key_pressed(DFMKey) and showMenu == false) then
				notify("Hello, you got any job for us?")
				showMenu = true
			end
		end
	end

	--SHOW MENU
	if(showMenu == true) then
		APM4hPGUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and showMenu == true) then
		showMenu = false
	end
	
	--M4H DISMISS/DEAD
	if (mercSpawned == true and get_key_pressed(Keys.Delete) and playerExists) then
		CAM.DO_SCREEN_FADE_OUT(250)
		ArmoredPacksm4hPMod.unload()
		mercSpawned = false
		wait(500)
		CAM.DO_SCREEN_FADE_IN(250)
	end
	
	if (mercSpawned == true and m4hpCount < 1) then
		mercSpawned = false
	end


	if (get_key_pressed(DFMKeynd) and playerExists) then
		ArmoredPacksm4hPMod.teleportmen4hiredToPlayer()
	end

	ArmoredPacksm4hPMod.deleteOnDead()

	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,857.989, 2877.070, 57.983, false ) < 150 ) then
		spawnMercM4H()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,857.989, 2877.070, 57.983, false ) > 150 ) then
		PED.DELETE_PED(ML4Ped)
		PED.DELETE_PED(MS4Ped[0])
		PED.DELETE_PED(MS4Ped[1])
		PED.DELETE_PED(MS4Ped[2])
		PED.DELETE_PED(MS4Ped[3])
		PED.DELETE_PED(MS4Ped[4])
		PED.DELETE_PED(MS4Ped[5])
		PED.DELETE_PED(MS4Ped[6])
		PED.DELETE_PED(MS4Ped[7])
		PED.DELETE_PED(MS4Ped[8])
		PED.DELETE_PED(MS4Ped[9])
		PED.DELETE_PED(MS4Ped[10])
		PED.DELETE_PED(MS4Ped[11])
		PED.DELETE_PED(MS4Ped[12])
		MercLeaderMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(MercLeader)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(MercSoldier)
		spawned = false
	end

	if (buyLimitM4HP == true and TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
		buyLimitM4HP = false
	end
end

------------------------------------------------------------------------------

--MERC SPAWN
function ArmoredPacksm4hPMod.unload()
	UI.REMOVE_BLIP(blipm4hP)
	if spawned == true then
		PED.DELETE_PED(ML4Ped)
		PED.DELETE_PED(MS4Ped[0])
		PED.DELETE_PED(MS4Ped[1])
		PED.DELETE_PED(MS4Ped[2])
		PED.DELETE_PED(MS4Ped[3])
		PED.DELETE_PED(MS4Ped[4])
		PED.DELETE_PED(MS4Ped[5])
		PED.DELETE_PED(MS4Ped[6])
		PED.DELETE_PED(MS4Ped[7])
		PED.DELETE_PED(MS4Ped[8])
		PED.DELETE_PED(MS4Ped[9])
		PED.DELETE_PED(MS4Ped[10])
		PED.DELETE_PED(MS4Ped[11])
		PED.DELETE_PED(MS4Ped[12])
		MercLeaderMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(MercLeader)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(MercSoldier)
	end
end

function spawnMercM4H()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_CARBINERIFLE")
	local weapon2 = GAMEPLAY.GET_HASH_KEY("WEAPON_HEAVYSNIPER")
	local weapon3 = GAMEPLAY.GET_HASH_KEY("WEAPON_COMBATMG")
	local weapon4 = GAMEPLAY.GET_HASH_KEY("WEAPON_HOMINGLAUNCHER")

	---MERCLEADER---
	MercLeader = GAMEPLAY.GET_HASH_KEY("S_M_Y_BLACKOPS_01")
	STREAMING.REQUEST_MODEL(MercLeader)
	while(not STREAMING.HAS_MODEL_LOADED(MercLeader)) do
		wait(50)
	end
	ML4Ped = PED.CREATE_PED(1, MercLeader, 857.989, 2877.070, 57.983, 248, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(ML4Ped, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(ML4Ped, weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(ML4Ped, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(ML4Ped, false)
	PED.SET_PED_RANDOM_PROPS(ML4Ped)
	MercLeaderMoney = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(8000,100000))
	PED.SET_PED_MONEY(ML4Ped, MercLeaderMoney)

	---MERCSOLDIER---
	MercSoldier = GAMEPLAY.GET_HASH_KEY("S_M_Y_BLACKOPS_02")

	STREAMING.REQUEST_MODEL(MercSoldier)
	
	while(not STREAMING.HAS_MODEL_LOADED(MercSoldier)) do
		wait(50)
	end
	
	MS4Ped = {}
	
	MS4Ped[0] = PED.CREATE_PED(1, MercSoldier, 887.665, 2852.783, 57.000, 138, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[0], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[0])
	
	MS4Ped[1] = PED.CREATE_PED(1, MercSoldier, 891.617, 2856.150, 57.000, 358, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[1], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[1])
	
	MS4Ped[2] = PED.CREATE_PED(1, MercSoldier, 885.721, 2874.162, 60.567, 127, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[2], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[2], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[2], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[2], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[2])
	
	MS4Ped[3] = PED.CREATE_PED(1, MercSoldier, 885.277, 2863.100, 60.129, 120, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[3], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[3], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[3], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[3], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[3])

	MS4Ped[4] = PED.CREATE_PED(1, MercSoldier, 887.196, 2880.141, 60.229, 355, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[4], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[4], weapon4, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[4], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[4], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[4])

	MS4Ped[5] = PED.CREATE_PED(1, MercSoldier, 857.607, 2860.004, 60.653, 210, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[5], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[5], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[5], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[5], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[5])

	MS4Ped[6] = PED.CREATE_PED(1, MercSoldier, 853.043, 2868.582, 60.774, 27, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[6], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[6], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[6], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[6], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[6])

	MS4Ped[7] = PED.CREATE_PED(1, MercSoldier, 863.414, 2877.791, 57.983, 185, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[7], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[7], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[7], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[7], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[7])

	MS4Ped[8] = PED.CREATE_PED(1, MercSoldier, 932.231, 2869.220, 60.918, 315, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[8], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[8], weapon2, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[8], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[8], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[8])

	MS4Ped[9] = PED.CREATE_PED(1, MercSoldier, 930.393, 2855.580, 60.288, 226, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[9], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[9], weapon3, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[9], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[9], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[9])

	MS4Ped[10] = PED.CREATE_PED(1, MercSoldier, 923.568, 2878.303, 58.727, 11, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[10], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[10], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[10], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[10], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[10])

	MS4Ped[11] = PED.CREATE_PED(1, MercSoldier, 917.940, 2862.782, 59.300, 115, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[11], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[11], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[11], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[11], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[11])

	MS4Ped[12] = PED.CREATE_PED(1, MercSoldier, 890.160, 2880.572, 56.108, 342, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(MS4Ped[12], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(MS4Ped[12], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(MS4Ped[12], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(MS4Ped[12], false)
	PED.SET_PED_RANDOM_PROPS(MS4Ped[12])
end

------------------------------------------------------------------------------

--M4H SPAWN
function spawnM4H(modelString)

	if (buyLimitM4HP == false and (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("gburrito2")) then cost = m4h1Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bison")) then cost = m4h2Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("granger")) then cost = m4h3Cost
		end
	
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("gburrito2")) then CarName = m4h1CarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bison")) then CarName = m4h2CarName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("granger")) then CarName = m4h3CarName
		end

	Pay(cost)

		if (buyFalse == false and buyLimitM4HP == false) then
		spawnAfricanVehicleNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry my friend. No money, no deal.")
		buyFalse = false
		end

	elseif(buyLimitM4HP == true and TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
		notify("There is no one available today.")
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnM4H(modelString)

	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)
	local playerPosition = ENTITY.GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(playerPed, 0.0, 5.0, 0.0)
	local playerGroup = PED.GET_PED_GROUP_INDEX(playerPed)
	
	print (timebuy)
	print(TIME.GET_CLOCK_DAY_OF_MONTH())
	print(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

	if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	buyLimitM4HP = true
	
	local cost
	
	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(250)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(250)

	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehMerc = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString),  878.890, 2878.566, 56.655, 160, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehMerc)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehMerc, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehMerc, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehMerc, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehMerc, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehMerc, 0)
	VEHICLE.SET_VEHICLE_MOD(vehMerc, 16, 3, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehMerc, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehMerc, 3) 
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehMerc, true)
	VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehMerc, 210, 180, 140) 
	VEHICLE.SET_VEHICLE_CUSTOM_SECONDARY_COLOUR(vehMerc, 222, 184, 135)
	VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(vehMerc, false) 
	VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(vehMerc, false) 			
	VEHICLE.SET_VEHICLE_NUMBER_PLATE_TEXT(vehMerc, "PMC")
		
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))

	--M4H SPAWN
	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("gburrito2")) then
		for i = 0, amountAllowed, 1 do
			if (m4hpCount < amountAllowed3) then
				ArmoredPacksm4hPMod.loadRndPedModels()
				ArmoredPacksm4hPMod.loadPedModel()

				if (RndModels == true) then
					guards[i] = PED.CREATE_PED(26, GAMEPLAY.GET_HASH_KEY(ArmoredPacksm4hPMod.GetRndModel()),873.392, 2880.991, 56.817,187, false, true)
					mercSpawned = true

					if (RndWeapons == true) then
						ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
					elseif (RndWeapons == false) then
						ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
					end

					ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
					ArmoredPacksm4hPMod.unloadRndPedModels()
				elseif (RndModels == false) then
					guards[i] = PED.CREATE_PED(26, GAMEPLAY.GET_HASH_KEY(pedModel),873.392, 2880.991, 56.817,187, false, true)
					mercSpawned = true

					if (RndWeapons == true) then
						ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
					elseif (RndWeapons == false) then
						ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
					end

					ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
					ArmoredPacksm4hPMod.unloadPedModel()
				end

				m4hpCount = m4hpCount + 1
				print("[ArmoredPacksm4hPMod.tick]: Number of men4hired: " .. m4hpCount)
			end
		end
	end
		
	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("bison")) then
		for i = 0, amountAllowed, 1 do
			if (m4hpCount < amountAllowed2) then
				ArmoredPacksm4hPMod.loadRndPedModels()
				ArmoredPacksm4hPMod.loadPedModel()

				if (RndModels == true) then
					guards[i] = PED.CREATE_PED(26, GAMEPLAY.GET_HASH_KEY(ArmoredPacksm4hPMod.GetRndModel()),873.392, 2880.991, 56.817,187, false, true)
					mercSpawned = true
					
					if (RndWeapons == true) then
						ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
					elseif (RndWeapons == false) then
						ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
					end

					ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
					ArmoredPacksm4hPMod.unloadRndPedModels()
				elseif (RndModels == false) then
					guards[i] = PED.CREATE_PED(26, GAMEPLAY.GET_HASH_KEY(pedModel),873.392, 2880.991, 56.817,187, false, true)
					mercSpawned = true

					if (RndWeapons == true) then
						ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
					elseif (RndWeapons == false) then
						ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
					end

					ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
					ArmoredPacksm4hPMod.unloadPedModel()
				end

				m4hpCount = m4hpCount + 1
				print("[ArmoredPacksm4hPMod.tick]: Number of men4hired: " .. m4hpCount)
			end
		end
	end
	
	if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("granger")) then
		for i = 0, amountAllowed, 1 do
			if (m4hpCount < amountAllowed) then
				ArmoredPacksm4hPMod.loadRndPedModels()
				ArmoredPacksm4hPMod.loadPedModel()

				if (RndModels == true) then
					guards[i] = PED.CREATE_PED(26, GAMEPLAY.GET_HASH_KEY(ArmoredPacksm4hPMod.GetRndModel()),873.392, 2880.991, 56.817,187, false, true)
					mercSpawned = true

					if (RndWeapons == true) then
						ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
					elseif (RndWeapons == false) then
						ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
					end

					ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
					ArmoredPacksm4hPMod.unloadRndPedModels()
				elseif (RndModels == false) then
					guards[i] = PED.CREATE_PED(26, GAMEPLAY.GET_HASH_KEY(pedModel),873.392, 2880.991, 56.817,187, false, true)
					mercSpawned = true

					if (RndWeapons == true) then
						ArmoredPacksm4hPMod.applyRndWeaponsTomen4hired(i)
					elseif (RndWeapons == false) then
						ArmoredPacksm4hPMod.applyWeaponsTomen4hired(i)
					end

					ArmoredPacksm4hPMod.applyNativesTomen4hired(i)
					ArmoredPacksm4hPMod.unloadPedModel()
				end

				m4hpCount = m4hpCount + 1
				print("[ArmoredPacksm4hPMod.tick]: men4hired: " .. m4hpCount)
			end
		end
	end	

	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehMerc)

	Pay(cost)
	buy = true
	notify("Pleasure doing bussines with you, Your " .. CarName .. " and your men is ready and waiting. Stay safe!")
	end
	end
		wait(5)
end

------------------------------------------------------------------------------
return ArmoredPacksm4hPMod

-- Credits to: Alexander Blade & headscript--