﻿-- ======================================================================================================================= --
-- ------------------------------------- BATTLEGROUND : ARMORED PACKS - by 2S v2.3.7 ------------------------------------- --
-- ----------------------------------------------------------------------------------------------------------------------- --
-- NOTE:														   --
-- Please do not distribute this code without permission. 								   --
-- You may modify this code only for personal use.									   --
-- But if you use this code as source code for your mod, please credit me when you do that. I will really happy for that.  --
-- Thank you for using this mod, have fun..										   --
-- ----------------------------------------------------------------------------------------------------------------- 2S -- --
-- ======================================================================================================================= --

local ArmoredPacksSr1Mod = {}
function ArmoredPacksSr1Mod.unload()
end

--DISPLAY BLIP
blipSr1 = UI.ADD_BLIP_FOR_COORD(-923.225,-2938.215,13.952)
		UI.SET_BLIP_COLOUR(blipSr1, 1)
		UI.SET_BLIP_SPRITE(blipSr1, 423)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blipSr1, "SKY RICH")
		UI.SET_BLIP_SCALE(blipSr1, 1)
		UI.SET_BLIP_AS_SHORT_RANGE(blipSr1, true)

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainSr1Init()
	APSr1GUI = APSr1GUIinit()

	--MENU
	APSr1GUI.mainMenu("main", "", "SKY RICH", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr1GUI.addButton1("main", "JET ENGINE AIRCRAFT", APSr1GUI.setActiveMenu, "menu2", false, 0.35, 1)
	APSr1GUI.addButton1("main", "PROPELLER ENGINE AIRCRAFT", APSr1GUI.setActiveMenu, "menu3", false, 0.35, 1)
	
	APSr1GUI.mainMenu("menu2", "main", "SKY RICH - JET AIRCRAFT", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr1GUI.addButton1("menu2", "Vestra $950000", spawnSr1Aircraft, "vestra", false, 0.35, 0)
	APSr1GUI.addButton1("menu2", "Vestra SC $1250000", spawnSrse1Aircraft, "vestra", false, 0.35, 0)
	APSr1GUI.addButton1("menu2", "Buckingham Luxor $1625000", spawnSr1Aircraft,"luxor", false, 0.35, 0)
	APSr1GUI.addButton1("menu2", "Buckingham Shamal $1150000", spawnSr1Aircraft,"shamal", false, 0.35, 0)
	APSr1GUI.addButton1("menu2", "PREV <", APSr1GUI.setActiveMenu, "main", false, 0.35, 1)
	APSr1GUI.addButton1("menu2", "NEXT >", APSr1GUI.setActiveMenu, "menu4", false, 0.35, 1)

	APSr1GUI.mainMenu("menu4", "main", "SKY RICH - MILITARY JET", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr1GUI.addButton1("menu4", "Besra $1150000", spawnSr1Aircraft,"besra", false, 0.35, 0)
	APSr1GUI.addButton1("menu4", "Besra SC $1450000", spawnSrse1Aircraft,"besra", false, 0.35, 0)
	APSr1GUI.addButton1("menu4", "Miljet $1700000", spawnSr1Aircraft,"miljet", false, 0.35, 0)
	APSr1GUI.addButton1("menu4", "P-996 Lazer $17000000", spawnSr1Aircraft,"lazer", false, 0.35, 0)
	APSr1GUI.addButton1("menu4", "Hydra V/STOL Fighter $25000000", spawnSr1Aircraft,"hydra", false, 0.35, 0)
	APSr1GUI.addButton1("menu4", "PREV <", APSr1GUI.setActiveMenu, "menu2", false, 0.35, 1)
	APSr1GUI.addButton1("menu4", "NEXT >", APSr1GUI.setActiveMenu, "menu6", false, 0.35, 1)
	
	APSr1GUI.mainMenu("menu6", "main", "SKY RICH - HUGE AIRCRAFT", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr1GUI.addButton1("menu6", "Cargo Plane $4000000", spawnSrcp1Aircraft,"cargoplane", false, 0.35, 0)
	APSr1GUI.addButton1("menu6", "Commercial Jet $3000000", spawnSrcp1Aircraft,"jet", false, 0.35, 0)
	APSr1GUI.addButton1("menu6", "PREV <", APSr1GUI.setActiveMenu, "menu4", false, 0.35, 1)

	APSr1GUI.mainMenu("menu3", "main", "SKY RICH - PROPELLER AIRCRAFT", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr1GUI.addButton1("menu3", "Cuban 800 $240000", spawnSr1Aircraft,"cuban800", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Cuban 800 SC $540000", spawnSrse1Aircraft,"cuban800", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Duster $275000", spawnSr1Aircraft,"duster", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Dodo $500000", spawnSr1Aircraft,"dodo", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Dodo SC $800000", spawnSrse1Aircraft,"dodo", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Mammatus $300000", spawnSr1Aircraft,"mammatus", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Velum $450000", spawnSr1Aircraft,"velum", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "Velum SC $750000", spawnSrse1Aircraft,"velum", false, 0.35, 0)
	APSr1GUI.addButton1("menu3", "PREV <", APSr1GUI.setActiveMenu, "main", false, 0.35, 1)
	APSr1GUI.addButton1("menu3", "NEXT >", APSr1GUI.setActiveMenu, "menu5", false, 0.35, 1)

	APSr1GUI.mainMenu("menu5", "main", "SKY RICH - MILITARY PROPELLER PLANE", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr1GUI.addButton1("menu5", "Titan $2000000", spawnSr1Aircraft,"titan", false, 0.35, 0)
	APSr1GUI.addButton1("menu5", "Titan SC $2300000", spawnSrse1Aircraft,"titan", false, 0.35, 0)
	APSr1GUI.addButton1("menu5", "PREV <", APSr1GUI.setActiveMenu, "menu3", false, 0.35, 1)
end

-------------------------------------------------------------------------------------------------------------------

local ArmoredPacksSr1Mod = {}
function ArmoredPacksSr1Mod.unload()
end
function ArmoredPacksSr1Mod.init()
mainSr1Init()
end
function ArmoredPacksSr1Mod.tick()
		APSr1GUI.tick()
end

function APSr1GUIinit()
	APSr1GUI = {}
	APSr1GUI.menu = {}
	APSr1GUI.buttons = {}
	APSr1GUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APSr1GUI.activeButton = 1
	APSr1GUI.activeMenu = ""
	APSr1GUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APSr1GUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APSr1GUI.menu[menuName] == nil) then
			APSr1GUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APSr1GUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APSr1GUI.addButton1(mainMenu, text, funct, args, selectable, textScale, font)
		if(APSr1GUI.buttons[mainMenu] == nil or APSr1GUI.buttons[mainMenu]["settings"] == nil) then
			APSr1GUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APSr1GUI.buttons[mainMenu].settings + 1
		APSr1GUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APSr1GUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APSr1GUI.menu[mainMenu].xmin,
			["ymin"] = APSr1GUI.menu[mainMenu].lastOffset,["xmax"] = APSr1GUI.menu[mainMenu].xmax,
			["ymax"] = APSr1GUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APSr1GUI.menu[mainMenu]["lastOffset"] = (APSr1GUI.menu[mainMenu].lastOffset + APSr1GUI.menu[mainMenu].ymax + APSr1GUI.menu[mainMenu].spacing)
	end

	function APSr1GUI.setActiveMenu(menuName)
		APSr1GUI.activeButton = 1
		APSr1GUI.activeMenu = menuName
	end

	function APSr1GUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APSr1GUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APSr1GUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APSr1GUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APSr1GUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APSr1GUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButton1Text(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APSr1GUI.setActiveMenu("")
		end
	end

	function APSr1GUI.drawAPSr1GUI()
		if(APSr1GUI.activeMenu ~= "" and APSr1GUI.activeMenu ~= nil) then
			local name = APSr1GUI.activeMenu

			if(APSr1GUI.menu[name] ~= nil) then
				local xmin = APSr1GUI.menu[name].xmin
				local ymin = APSr1GUI.menu[name].ymin
				local xmax = APSr1GUI.menu[name].xmax
				local ymax = APSr1GUI.menu[name].ymax
				
				local text = APSr1GUI.menu[name].title
				local textScale = APSr1GUI.menu[name].textScale
				local font = APSr1GUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButton1Text(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APSr1GUI.buttons[name] ~= nil) then
					for i, v in pairs(APSr1GUI.buttons[name].settings) do
						local buttonSettings = APSr1GUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 25, ["g"] = 50, ["b"] = 80, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APSr1GUI.activeButton) then
							colors = {["r"] = 140, ["g"] = 150, ["b"] = 200, ["o"] = 200}
						end

						addButton1Text(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APSr1GUI.setActiveMenu("")
				end
			else
				APSr1GUI.setActiveMenu("")
			end
		end
	end

	function APSr1GUI.updateIndexStatus(text, time)
		APSr1GUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APSr1GUI.isButtonselectableOn()
		local activeButton = APSr1GUI.buttons[APSr1GUI.activeMenu].settings[APSr1GUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APSr1GUI.buttons[APSr1GUI.activeMenu].settings[APSr1GUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APSr1GUI.toggleButtonState()
		local activeButton = APSr1GUI.buttons[APSr1GUI.activeMenu].settings[APSr1GUI.activeButton]
		
		if(APSr1GUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APSr1GUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APSr1GUI.tick()
		APSr1GUI.drawIndex()
		APSr1GUI.drawAPSr1GUI()

		for i, key in pairs(APSr1GUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APSr1GUI.activeMenu == APSr1GUI.updateSelection.menuOpen.menu) then
						APSr1GUI.setActiveMenu(APSr1GUI.menu[APSr1GUI.activeMenu].prevMenu)
						AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
					else
					  	APSr1GUI.setActiveMenu(APSr1GUI.updateSelection.menuOpen.menu)
					   	APSr1GUI.currentSelection = 1
						AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
					end
				end
			
			end
		end

		for k, key in pairs(APSr1GUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APSr1GUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSr1GUI.activeButton = APSr1GUI.activeButton - 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APSr1GUI.activeButton <= 0) then
						APSr1GUI.activeButton = APSr1GUI.menu[APSr1GUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APSr1GUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APSr1GUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSr1GUI.activeButton = APSr1GUI.activeButton + 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APSr1GUI.activeButton > APSr1GUI.menu[APSr1GUI.activeMenu].numButtons) then
						APSr1GUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APSr1GUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APSr1GUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APSr1GUI.buttons[APSr1GUI.activeMenu].settings[APSr1GUI.activeButton]
				AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APSr1GUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APSr1GUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APSr1GUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APSr1GUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APSr1GUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSr1GUI.setActiveMenu(APSr1GUI.menu[APSr1GUI.activeMenu].prevMenu)
					AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
				end
			
			end
		end
	end

	return APSr1GUI
end

-------------------------------------------------------------------------------------------------------------------

---STANDARD EDITION
--PRICES
	--JET
local aircVestraCost = 950000
local aircBesraCost = 1150000
local aircMiljetCost = 1700000
local aircLuxorCost = 1625000
local aircLuxorDeluxeCost = 10000000
local aircShamalCost = 1150000
local aircLazerCost = 17000000
local aircHydraCost = 25000000
local aircCargocpCost = 4000000
local aircjetcpCost = 3000000

	--PROPELLER
local aircCargoCost = 950000
local aircCuban800Cost = 240000
local aircDusterCost = 275000
local aircDodoCost = 500000
local aircMallardCost = 250000
local aircMammatusCost = 300000
local aircTitanCost = 2000000
local aircVelumCost = 450000

--AIRCRAFT NAME
	--JET
local aircVestraPlaneName = "Vestra"
local aircBesraPlaneName = "Besra"
local aircMiljetPlaneName = "Miljet"
local aircLuxorPlaneName = "Buckingham Luxor"
local aircLuxorDeluxePlaneName = "Buckingham Luxor Deluxe"
local aircShamalPlaneName = "Buckingham Shamal"
local aircLazerPlaneName = "P-996 Lazer"
local aircHydraPlaneName = "Hydra V/STOL Fighter"
local aircCargocpPlaneName = "Cargo Plane"
local aircjetcpPlaneName = "Commercial Jet"

	--PROPELLER
local aircCargoPlaneName = "Cargo Plane"
local aircCuban800PlaneName = "Cuban 800"
local aircDusterPlaneName = "Duster"
local aircDodoPlaneName = "Dodo"
local aircMallardPlaneName = "Mallard"
local aircMammatusPlaneName = "Mammatus"
local aircTitanPlaneName = "Titan"
local aircVelumPlaneName = "Velum"

---Stealth Camouflage
--PRICES SE
	--JET SE
local aircVestraSeCost = 1250000
local aircBesraSeCost = 1450000
local aircMiljetSeCost = 2000000
local aircLuxorSeCost = 1925000
local aircLuxorDeluxeSeCost = 10000000
local aircShamalSeCost = 1450000
local aircLazerSeCost = 17000000
local aircHydraSeCost = 25000000

	--PROPELLER SE
local aircCargoSeCost = 950000
local aircCuban800SeCost = 540000
local aircDusterSeCost = 575000
local aircDodoSeCost = 800000
local aircMallardSeCost = 550000
local aircMammatusSeCost = 600000
local aircTitanSeCost = 2300000
local aircVelumSeCost = 750000

--AIRCRAFT NAME SE
	--JET SE
local aircVestraSePlaneName = "Vestra Stealth Camouflage"
local aircBesraSePlaneName = "Besra Stealth Camouflage"
local aircMiljetSePlaneName = "Miljet Stealth Camouflage"
local aircLuxorSePlaneName = "Buckingham Luxor Stealth Camouflage"
local aircLuxorDeluxeSePlaneName = "Buckingham Luxor Deluxe"
local aircShamalSePlaneName = "Buckingham Shamal Stealth Camouflage"
local aircLazerSePlaneName = "P-996 Lazer"
local aircHydraSePlaneName = "Hydra V/STOL Fighter"

	--PROPELLER SE
local aircCargoSePlaneName = "Cargo Plane Stealth Camouflage"
local aircCuban800SePlaneName = "Cuban 800 Stealth Camouflage"
local aircDusterSePlaneName = "Duster Stealth Camouflage"
local aircDodoSePlaneName = "Dodo Stealth Camouflage"
local aircMallardSePlaneName = "Mallard Stealth Camouflage"
local aircMammatusSePlaneName = "Mammatus Stealth Camouflage"
local aircTitanSePlaneName = "Titan Stealth Camouflage"
local aircVelumSePlaneName = "Velum Stealth Camouflage"

local showMenu = false

local buy = false
local timebuy = 99999
local buyLimitSR1 = false
local PlaneName = "not set"
local SePlaneName = "not set"

local spawned = false
local bs1Ped

local cost = 0

-------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------

function ArmoredPacksSr1Mod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, -923.225, -2938.215, 13.952, true)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(bs1Ped, true) then
			PLAYER.SET_PLAYER_WANTED_LEVEL(player, 4, false)
			PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(player, false)
			BGAP2SHUD.DrawTextNotif1("~b~Sky Rich~s~ is closed. Please come", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif1("back later.", renHUDyNotif + 0.0265, renHUDxNotif, 0.355)
			GRAPHICS.DRAW_RECT(0.158, 0.084, 0.215, 0.0685, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
		else
			BGAP2SHUD.DrawTextNotif1("Press      to browse airplane.", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif2("~u~E", renHUDyNotif + 0.0025, renHUDxNotif + 0.035, 0.31)
			GRAPHICS.DRAW_RECT(0.132, 0.074, 0.163, 0.0485, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
			GRAPHICS.DRAW_RECT(0.095, 0.071, 0.0134, 0.0235, redHUDNotif2, greenHUDNotif2, blueHUDNotif2, alphaHUDNotif2)
		
			if (get_key_pressed(DFMKey) and showMenu == false) then
				notify("Welcome to ~b~Sky Rich~s~, what do you want?")
				showMenu = true
			end
		end
	end

	--SHOW MENU
	if(showMenu == true) then
		APSr1GUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and showMenu == true) then
		showMenu = false
	end

	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-923.225, -2938.215, 13.952, false ) < 150 ) then
		spawnSr1Dealer()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,-923.225, -2938.215, 13.952, false ) > 150 ) then
		PED.DELETE_PED(bs1Ped)
		PED.DELETE_PED(sc1Ped[0])
		PED.DELETE_PED(sc1Ped[1])
		businessmanMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(businessman)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(security)
		spawned = false
	end
	
	if (buyLimitSR1 == true and TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
		buyLimitSR1 = false
	end
end

--DEALER SPAWN
function ArmoredPacksSr1Mod.unload()
	UI.REMOVE_BLIP(blipSr1)
	if spawned == true then
		PED.DELETE_PED(bs1Ped)
		PED.DELETE_PED(sc1Ped[0])
		PED.DELETE_PED(sc1Ped[1])
		businessmanMoney = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(businessman)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(security)
	end
end

function spawnSr1Dealer()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_PISTOL")

	---BUSINESSMAN---
	businessman = GAMEPLAY.GET_HASH_KEY("A_M_Y_Business_01")
	STREAMING.REQUEST_MODEL(businessman)
	while(not STREAMING.HAS_MODEL_LOADED(businessman)) do
		wait(50)
	end
	bs1Ped = PED.CREATE_PED(1, businessman, -923.225, -2938.215, 13.952, 172, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(bs1Ped, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(bs1Ped, weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(bs1Ped, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(bs1Ped, false)
	PED.SET_PED_RANDOM_PROPS(bs1Ped)
	businessmanMoney = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(50000,100000))
	PED.SET_PED_MONEY(bs1Ped, businessmanMoney)

	---SECURITY---
	security = GAMEPLAY.GET_HASH_KEY("S_M_M_Security_01")

	STREAMING.REQUEST_MODEL(security)
	
	while(not STREAMING.HAS_MODEL_LOADED(security)) do
		wait(50)
	end
	
	sc1Ped = {}
	
	sc1Ped[0] = PED.CREATE_PED(1, security, -934.504, -2928.708, 13.952, 136, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(sc1Ped[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(sc1Ped[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(sc1Ped[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(sc1Ped[0], false)
	PED.SET_PED_RANDOM_PROPS(sc1Ped[0])
	
	sc1Ped[1] = PED.CREATE_PED(1, security, -925.636, -2940.879, 13.945, 325, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(sc1Ped[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(sc1Ped[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(sc1Ped[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(sc1Ped[1], false)
	PED.SET_PED_RANDOM_PROPS(sc1Ped[1])
end

--VEHICLE SPAWN
function spawnSr1Aircraft(modelString)

	if (buyFalse == false) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then cost = aircVestraCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then cost = aircBesraCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then cost = aircMiljetCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then cost = aircLuxorCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then cost = aircLuxorDeluxeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then cost = aircShamalCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then cost = aircLazerCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then cost = aircHydraCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargo")) then cost = aircCargoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then cost = aircCuban800Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then cost = aircDusterCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then cost = aircDodoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then cost = aircMallardCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then cost = aircMammatusCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then cost = aircTitanCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then cost = aircVelumCost
		end
		
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then PlaneName = aircVestraPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then PlaneName = aircBesraPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then PlaneName = aircMiljetPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then PlaneName = aircLuxorPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then PlaneName = aircLuxorDeluxePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then PlaneName = aircShamalPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then PlaneName = aircLazerPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then PlaneName = aircHydraPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargo")) then PlaneName = aircCargoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then PlaneName = aircCuban800PlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then PlaneName = aircDusterPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then PlaneName = aircDodoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then PlaneName = aircMallardPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then PlaneName = aircMammatusPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then PlaneName = aircTitanPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then PlaneName = aircVelumPlaneName
		end

	Pay(cost)

		if (buyFalse == false) then
		spawnSr1AircraftNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry. But you don't have enough money.")
		buyFalse = false
		end
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnSr1AircraftNow(modelString)

	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)

	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehSr1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), -972.760, -3000.831, 13.945, 61, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehSr1)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehSr1, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehSr1, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehSr1, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehSr1, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehSr1, 0)
	VEHICLE.SET_VEHICLE_MOD(vehSr1, 16, 2, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehSr1, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehSr1, 1)
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehSr1, true) 			

	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehSr1)

	buy = true
	notify("Your " .. PlaneName .. " is already delivered. Thank you!")
	end	
end

--VEHICLE SPAWN STEALTH
function spawnSrse1Aircraft(modelString)

	if (buyLimitSR1 == false and (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then cost = aircVestraSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then cost = aircBesraSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then cost = aircMiljetSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then cost = aircLuxorSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then cost = aircLuxorDeluxeSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then cost = aircShamalSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then cost = aircLazerSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then cost = aircHydraSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargo")) then cost = aircCargoSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then cost = aircCuban800SeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then cost = aircDusterSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then cost = aircDodoSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then cost = aircMallardSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then cost = aircMammatusSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then cost = aircTitanSeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then cost = aircVelumSeCost
		end
		
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then SePlaneName = aircVestraSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then SePlaneName = aircBesraSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then SePlaneName = aircMiljetSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then SePlaneName = aircLuxorSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then SePlaneName = aircLuxorDeluxeSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then SePlaneName = aircShamalSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then SePlaneName = aircLazerSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then SePlaneName = aircHydraSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargo")) then SePlaneName = aircCargoSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then SePlaneName = aircCuban800SePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then SePlaneName = aircDusterSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then SePlaneName = aircDodoSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then SePlaneName = aircMallardSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then SePlaneName = aircMammatusSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then SePlaneName = aircTitanSePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then SePlaneName = aircVelumSePlaneName
		end

	Pay(cost)

		if (buyFalse == false and buyLimitSR1 == false) then
		spawnSrse1AircraftNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry. But you don't have enough money.")
		buyFalse = false
		end

	elseif(buyLimitSR1 == true and TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
		notify("I'm sorry, but you have to wait for a new shipment.")
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnSrse1AircraftNow(modelString)

	print(timebuy)
	print(TIME.GET_CLOCK_DAY_OF_MONTH())
	print(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

	if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	buyLimitSR1 = true

	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)
	
	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
		
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehSrse1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), -972.760, -3000.831, 13.945, 61, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehSrse1)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehSrse1, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehSrse1, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehSrse1, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehSrse1, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehSrse1, 0)
	VEHICLE.SET_VEHICLE_MOD(vehSrse1, 11, 3, true) 
	VEHICLE.SET_VEHICLE_MOD(vehSrse1, 12, 2, true) 
	VEHICLE.SET_VEHICLE_MOD(vehSrse1, 13, 2, true)
	VEHICLE.SET_VEHICLE_MOD(vehSrse1, 15, 3, true) 
	VEHICLE.SET_VEHICLE_MOD(vehSrse1, 16, 4, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehSrse1, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehSrse1, 1) 
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehSrse1, true) 
	VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(vehSrse1, false) 
	VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(vehSrse1, false) 			
	VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehSrse1, 0, 0, 0)
	VEHICLE.SET_VEHICLE_CUSTOM_SECONDARY_COLOUR(vehSrse1, 0, 0, 0)

	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehSrse1)

	buy = true
	notify("Your " .. SePlaneName .. " is already delivered. Thank you!")
	end
	end
		wait(5)		
end

--VEHICLE SPAWN
function spawnSrcp1Aircraft(modelString)

	if (buyFalse == false) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargoplane")) then cost = aircCargocpCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("jet")) then cost = aircjetcpCost
		end
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargoplane")) then PlaneName = aircCargocpPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("jet")) then PlaneName = aircjetcpPlaneName
		end

	Pay(cost)

		if (buyFalse == false) then
		spawnSrcp1AircraftNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry. But you don't have enough money.")
		buyFalse = false
		end
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnSrcp1AircraftNow(modelString)

	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)
	
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehSr1 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), -1093.590, -3019.452, 13.945, 64, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehSr1)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehSr1, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehSr1, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehSr1, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehSr1, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehSr1, 0)
	VEHICLE.SET_VEHICLE_MOD(vehSr1, 16, 2, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehSr1, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehSr1, 1)
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehSr1, true) 			
	
	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehSr1)

	buy = true
	notify("Your " .. PlaneName .. " is already delivered. Thank you!")
	end
end

------------------------------------------------------------------------------
return ArmoredPacksSr1Mod

-- Credits to: Alexander Blade & headscript--