﻿-- ======================================================================================================================= --
-- ------------------------------------- BATTLEGROUND : ARMORED PACKS - by 2S v2.3.7 ------------------------------------- --
-- ----------------------------------------------------------------------------------------------------------------------- --
-- NOTE:														   --
-- Please do not distribute this code without permission. 								   --
-- You may modify this code only for personal use.									   --
-- But if you use this code as source code for your mod, please credit me when you do that. I will really happy for that.  --
-- Thank you for using this mod, have fun..										   --
-- ----------------------------------------------------------------------------------------------------------------- 2S -- --
-- ======================================================================================================================= --

local ArmoredPacksSr2Mod = {}
function ArmoredPacksSr2Mod.unload()
end

--DISPLAY BLIP
blipSr2 = UI.ADD_BLIP_FOR_COORD(2120.961,4784.109,40.970)
		UI.SET_BLIP_COLOUR(blipSr2, 1)
		UI.SET_BLIP_SPRITE(blipSr2, 423)
		UI.SET_BLIP_NAME_FROM_TEXT_FILE(blipSr2, "McKenzie Field")
		UI.SET_BLIP_SCALE(blipSr2, 1)
		UI.SET_BLIP_AS_SHORT_RANGE(blipSr2, true)

-------------------------------------------------------------------------------------------------------------------
--DO NOT EDIT BEYOND THIS POINT------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------------

function mainSr2Init()
	APSr2GUI = APSr2GUIinit()

	--MENU
	APSr2GUI.mainMenu("main", "", "McKenzie Field", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr2GUI.addButton1("main", "JET ENGINE AIRCRAFT", APSr2GUI.setActiveMenu, "menu2", false, 0.35, 1)
	APSr2GUI.addButton1("main", "PROPELLER ENGINE AIRCRAFT", APSr2GUI.setActiveMenu, "menu3", false, 0.35, 1)
	
	APSr2GUI.mainMenu("menu2", "main", "SKY RICH - JET AIRCRAFT", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr2GUI.addButton1("menu2", "Vestra $950000", spawnSr2Aircraft, "vestra", false, 0.35, 0)
	APSr2GUI.addButton1("menu2", "Vestra DC $1150000", spawnSrCamo2Aircraft, "vestra", false, 0.35, 0)
	APSr2GUI.addButton1("menu2", "Buckingham Luxor $1625000", spawnSr2Aircraft,"luxor", false, 0.35, 0)
	APSr2GUI.addButton1("menu2", "Buckingham Shamal $1150000", spawnSr2Aircraft,"shamal", false, 0.35, 0)
	APSr2GUI.addButton1("menu2", "PREV <", APSr2GUI.setActiveMenu, "main", false, 0.35, 1)
	APSr2GUI.addButton1("menu2", "NEXT >", APSr2GUI.setActiveMenu, "menu4", false, 0.35, 1)

	APSr2GUI.mainMenu("menu4", "main", "SKY RICH - MILITARY JET", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr2GUI.addButton1("menu4", "Besra $1150000", spawnSr2Aircraft,"besra", false, 0.35, 0)
	APSr2GUI.addButton1("menu4", "Besra DC $1350000", spawnSrCamo2Aircraft,"besra", false, 0.35, 0)
	APSr2GUI.addButton1("menu4", "Miljet $1700000", spawnSr2Aircraft,"miljet", false, 0.35, 0)
	APSr2GUI.addButton1("menu4", "P-996 Lazer $17000000", spawnSr2Aircraft,"lazer", false, 0.35, 0)
	APSr2GUI.addButton1("menu4", "Hydra V/STOL Fighter $25000000", spawnSr2Aircraft,"hydra", false, 0.35, 0)
	APSr2GUI.addButton1("menu4", "PREV <", APSr2GUI.setActiveMenu, "menu2", false, 0.35, 1)
	
	APSr2GUI.mainMenu("menu3", "main", "SKY RICH - PROPELLER AIRCRAFT", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr2GUI.addButton1("menu3", "Cuban 800 $240000", spawnSr2Aircraft,"cuban800", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "Cuban 800 DC $440000", spawnSrCamo2Aircraft,"cuban800", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "Duster $275000", spawnSr2Aircraft,"duster", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "Dodo $500000", spawnSr2Aircraft,"dodo", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "Mammatus $300000", spawnSr2Aircraft,"mammatus", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "Velum $450000", spawnSr2Aircraft,"velum", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "Velum DC $650000", spawnSrCamo2Aircraft,"velum", false, 0.35, 0)
	APSr2GUI.addButton1("menu3", "PREV <", APSr2GUI.setActiveMenu, "main", false, 0.35, 1)
	APSr2GUI.addButton1("menu3", "NEXT >", APSr2GUI.setActiveMenu, "menu5", false, 0.35, 1)

	APSr2GUI.mainMenu("menu5", "main", "SKY RICH - MILITARY PROPELLER PLANE", 0.168, 0.1, 0.234, 0.0425, 0.007, 0.35, 2)
	APSr2GUI.addButton1("menu5", "Titan $2000000", spawnSr2Aircraft,"titan", false, 0.35, 0)
	APSr2GUI.addButton1("menu5", "Titan DC $2200000", spawnSrCamo2Aircraft,"titan", false, 0.35, 0)
	APSr2GUI.addButton1("menu5", "PREV <", APSr2GUI.setActiveMenu, "menu3", false, 0.35, 1)
end

-------------------------------------------------------------------------------------------------------------------

local ArmoredPacksSr2Mod = {}
function ArmoredPacksSr2Mod.unload()
end
function ArmoredPacksSr2Mod.init()
mainSr2Init()
end
function ArmoredPacksSr2Mod.tick()
		APSr2GUI.tick()
end

function APSr2GUIinit()
	APSr2GUI = {}
	APSr2GUI.menu = {}
	APSr2GUI.buttons = {}
	APSr2GUI.updateSelection = {["menuOpen"] = {["keys"] = {},["menu"] = ""},["menuUp"] = {["keys"] = {}},
		["menuDown"] = {["keys"] = {}},["menuCancel"] = {["keys"] = {}},["select"] = {["keys"] = {}}}
	APSr2GUI.activeButton = 1
	APSr2GUI.activeMenu = ""
	APSr2GUI.IndexStatus = {["text"] = "", ["time"] = 0}

	function APSr2GUI.mainMenu(menuName, prevMenu, title, xmin, ymin, xmax, ymax, Space, textScale, font)
		if(APSr2GUI.menu[menuName] == nil) then
			APSr2GUI.menu[menuName] = {}
			lastOffset = ymin + ymax + Space
		end

		APSr2GUI.menu[menuName] = {["prevMenu"] = prevMenu,["title"] = title,["xmin"] = xmin,["ymin"] = ymin,
			["xmax"] = xmax,["ymax"] = ymax,["spacing"] = Space,["textScale"] = textScale,
			["font"] = font,["lastOffset"] = lastOffset,["numButtons"] = 0}
	end
	
	function APSr2GUI.addButton1(mainMenu, text, funct, args, selectable, textScale, font)
		if(APSr2GUI.buttons[mainMenu] == nil or APSr2GUI.buttons[mainMenu]["settings"] == nil) then
			APSr2GUI.buttons[mainMenu] = {["settings"] = {}}
		end

		local currButtonNum = #APSr2GUI.buttons[mainMenu].settings + 1
		APSr2GUI.menu[mainMenu].numButtons = currButtonNum

		if(selectable) then
			selectableOn = false
		else
		    selectableOn = nil
		end

		APSr2GUI.buttons[mainMenu].settings[currButtonNum] = {["mainMenu"] = mainMenu,["text"] = text,["funct"] = funct,
			["args"] = args,["font"] = font,["xmin"] = APSr2GUI.menu[mainMenu].xmin,
			["ymin"] = APSr2GUI.menu[mainMenu].lastOffset,["xmax"] = APSr2GUI.menu[mainMenu].xmax,
			["ymax"] = APSr2GUI.menu[mainMenu].ymax,["textScale"] = textScale,
			["selectable"] = selectable,["selectableOn"] = selectableOn}

		APSr2GUI.menu[mainMenu]["lastOffset"] = (APSr2GUI.menu[mainMenu].lastOffset + APSr2GUI.menu[mainMenu].ymax + APSr2GUI.menu[mainMenu].spacing)
	end

	function APSr2GUI.setActiveMenu(menuName)
		APSr2GUI.activeButton = 1
		APSr2GUI.activeMenu = menuName
	end

	function APSr2GUI.drawIndex()
		if(nextDrawTime == nil or prevText ~= APSr2GUI.IndexStatus.text) then
			nextDrawTime = GAMEPLAY.GET_GAME_TIMER() + APSr2GUI.IndexStatus.time
		end

		if(nextDrawTime > GAMEPLAY.GET_GAME_TIMER()) then
			prevText = APSr2GUI.IndexStatus.text
			UI.SET_TEXT_FONT(0)
			UI.SET_TEXT_SCALE(0.0, 0.35)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_WRAP(0, 1)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(10, 10, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(APSr2GUI.IndexStatus.text)
			UI._DRAW_TEXT(xmin , 0.5)
		else
			APSr2GUI.IndexStatus = {["text"] = "", ["time"] = 0}
			nextDrawTime = nil
		end
	end

	function addButton1Text(text, xmin, ymin, textScale, font)
		if(text ~= nil and xmin ~= nil and ymin ~= nil and textScale ~= nil and font ~= nil) then
			UI.SET_TEXT_FONT(font)
			UI.SET_TEXT_SCALE(0.0, 0.30)
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
			UI.SET_TEXT_CENTRE(true)
			UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
			UI.SET_TEXT_EDGE(1, 0, 0, 0, 205)
			UI._SET_TEXT_ENTRY("STRING")
			UI._ADD_TEXT_COMPONENT_STRING(text)
			UI._DRAW_TEXT(xmin , ymin - 0.0125)
		else
			print("text: ", text, ", xmin: ", xmin, ", ymin: ", ymin, ", textScale: ", textScale, ", font: ", font)
		    APSr2GUI.setActiveMenu("")
		end
	end

	function APSr2GUI.drawAPSr2GUI()
		if(APSr2GUI.activeMenu ~= "" and APSr2GUI.activeMenu ~= nil) then
			local name = APSr2GUI.activeMenu

			if(APSr2GUI.menu[name] ~= nil) then
				local xmin = APSr2GUI.menu[name].xmin
				local ymin = APSr2GUI.menu[name].ymin
				local xmax = APSr2GUI.menu[name].xmax
				local ymax = APSr2GUI.menu[name].ymax
				
				local text = APSr2GUI.menu[name].title
				local textScale = APSr2GUI.menu[name].textScale
				local font = APSr2GUI.menu[name].font
				local colors = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["o"] = 255}

				addButton1Text(text, xmin, ymin, textScale, font)
				GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);

				if(APSr2GUI.buttons[name] ~= nil) then
					for i, v in pairs(APSr2GUI.buttons[name].settings) do
						local buttonSettings = APSr2GUI.buttons[name].settings[i]
						local xmin = buttonSettings.xmin
						local ymin = buttonSettings.ymin
						local xmax = buttonSettings.xmax
						local ymax = buttonSettings.ymax
						
						local font = buttonSettings.font
						local text = buttonSettings.text
						local textScale = buttonSettings.textScale
						local colors = {["r"] = 245, ["g"] = 236, ["b"] = 0, ["o"] = 180}

						if(buttonSettings.selectableOn == true) then
							text = buttonSettings.text .. " [ON]"
						elseif(buttonSettings.selectableOn == false) then
							text = buttonSettings.text .. " [OFF]"
						end
						
						if(i == APSr2GUI.activeButton) then
							colors = {["r"] = 131, ["g"] = 131, ["b"] = 0, ["o"] = 200}
						end

						addButton1Text(text, xmin, ymin, textScale, font)
						GRAPHICS.DRAW_RECT(xmin, ymin, xmax, ymax, colors.r, colors.g, colors.b, colors.o);
					end
				else
					APSr2GUI.setActiveMenu("")
				end
			else
				APSr2GUI.setActiveMenu("")
			end
		end
	end

	function APSr2GUI.updateIndexStatus(text, time)
		APSr2GUI.IndexStatus = {["text"] = text, ["time"] = time}
	end

	function APSr2GUI.isButtonselectableOn()
		local activeButton = APSr2GUI.buttons[APSr2GUI.activeMenu].settings[APSr2GUI.activeButton]
		if(activeButton.selectable) then
			return activeButton.selectableOn
		elseif(activeButton.selectable == flse) then
			print("Button \"", APSr2GUI.buttons[APSr2GUI.activeMenu].settings[APSr2GUI.activeButton].text, "\"")
		    return nil
		end
	end

	function APSr2GUI.toggleButtonState()
		local activeButton = APSr2GUI.buttons[APSr2GUI.activeMenu].settings[APSr2GUI.activeButton]
		
		if(APSr2GUI.isButtonselectableOn() and activeButton.selectable) then
			activeButton.selectableOn = false
		elseif(APSr2GUI.isButtonselectableOn() == false and activeButton.selectable) then
			activeButton.selectableOn = true
			print("toggled on")
		end
	end

	function APSr2GUI.tick()
		APSr2GUI.drawIndex()
		APSr2GUI.drawAPSr2GUI()

		for i, key in pairs(APSr2GUI.updateSelection.menuOpen.keys) do
			if(get_key_pressed(key)) then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					if(APSr2GUI.activeMenu == APSr2GUI.updateSelection.menuOpen.menu) then
						APSr2GUI.setActiveMenu(APSr2GUI.menu[APSr2GUI.activeMenu].prevMenu)
						AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
					else
					  	APSr2GUI.setActiveMenu(APSr2GUI.updateSelection.menuOpen.menu)
					   	APSr2GUI.currentSelection = 1
						AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
					end
				end
			
			end
		end

		for k, key in pairs(APSr2GUI.updateSelection.menuUp.keys) do
			if(get_key_pressed(key) and APSr2GUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSr2GUI.activeButton = APSr2GUI.activeButton - 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APSr2GUI.activeButton <= 0) then
						APSr2GUI.activeButton = APSr2GUI.menu[APSr2GUI.activeMenu].numButtons
					end
				end
			
			end
		end

		for k, key in pairs(APSr2GUI.updateSelection.menuDown.keys) do
			if(get_key_pressed(key) and APSr2GUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSr2GUI.activeButton = APSr2GUI.activeButton + 1
					AUDIO.PLAY_SOUND_FRONTEND(0, "NAV_UP_DOWN", "HUD_FREEMODE_SOUNDSET", true)
					if(APSr2GUI.activeButton > APSr2GUI.menu[APSr2GUI.activeMenu].numButtons) then
						APSr2GUI.activeButton = 1
					end
				end
			
			end
		end

		for k, key in pairs(APSr2GUI.updateSelection.select.keys) do
			if(get_key_pressed(key) and APSr2GUI.activeMenu ~= "") then
			   if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
				local currButton = APSr2GUI.buttons[APSr2GUI.activeMenu].settings[APSr2GUI.activeButton]
				AUDIO.PLAY_SOUND_FRONTEND(0, "SELECT", "HUD_FREEMODE_SOUNDSET", true)
				
				if(type(currButton.funct) == "function" and type(currButton.args) == "table") then
					APSr2GUI.toggleButtonState()
					currButton.funct(currButton.args[1], currButton.args[2], currButton.args[3], currButton.args[4], currButton.args[5], currButton.args[6], currButton.args[7], currButton.args[8], currButton.args[9], currButton.args[10], currButton.args[11], currButton.args[12], currButton.args[13], currButton.args[14], currButton.args[15], currButton.args[16], currButton.args[17], currButton.args[18], currButton.args[19], currButton.args[20])

				elseif(type(currButton.funct) == "function" and type(currButton.args) == "string" or type(currButton.args) == "number"or type(currButton.args) == "boolean") then
					APSr2GUI.toggleButtonState()
					currButton.funct(currButton.args)
					
				elseif(currButton.args == nil) then
					APSr2GUI.toggleButtonState()
					currButton.funct()

				else
					print("function: ", currButton.funct, ", args: ", currButton.args)
				end
			   end
			
			end
		end

		for k, key in pairs(APSr2GUI.updateSelection.menuCancel.keys) do
			if(get_key_pressed(key) and APSr2GUI.activeMenu ~= "") then
				if lastTime==nil or GAMEPLAY.GET_GAME_TIMER()-lastTime>120 then lastTime=GAMEPLAY.GET_GAME_TIMER()
					APSr2GUI.setActiveMenu(APSr2GUI.menu[APSr2GUI.activeMenu].prevMenu)
					AUDIO.PLAY_SOUND_FRONTEND(0, "CANCEL", "HUD_FREEMODE_SOUNDSET", true)
				end
			
			end
		end
	end

	return APSr2GUI
end

-------------------------------------------------------------------------------------------------------------------

---STANDARD EDITION
--PRICES
	--JET
local aircVestraCost = 950000
local aircBesraCost = 1150000
local aircMiljetCost = 1700000
local aircLuxorCost = 1625000
local aircLuxorDeluxeCost = 10000000
local aircShamalCost = 1150000
local aircLazerCost = 17000000
local aircHydraCost = 25000000

	--PROPELLER
local aircCargoCost = 3000000
local aircCuban800Cost = 240000
local aircDusterCost = 275000
local aircDodoCost = 500000
local aircMallardCost = 250000
local aircMammatusCost = 300000
local aircTitanCost = 2000000
local aircVelumCost = 450000

--AIRCRAFT NAME
	--JET
local aircVestraPlaneName = "Vestra"
local aircBesraPlaneName = "Besra"
local aircMiljetPlaneName = "Miljet"
local aircLuxorPlaneName = "Buckingham Luxor"
local aircLuxorDeluxePlaneName = "Buckingham Luxor Deluxe"
local aircShamalPlaneName = "Buckingham Shamal"
local aircLazerPlaneName = "P-996 Lazer"
local aircHydraPlaneName = "Hydra V/STOL Fighter"

	--PROPELLER
local aircCargoPlaneName = "Cargo Plane"
local aircCuban800PlaneName = "Cuban 800"
local aircDusterPlaneName = "Duster"
local aircDodoPlaneName = "Dodo"
local aircMallardPlaneName = "Mallard"
local aircMammatusPlaneName = "Mammatus"
local aircTitanPlaneName = "Titan"
local aircVelumPlaneName = "Velum"

---DESERT CAMOUFLAGE
--PRICES SE
	--JET SE
local aircVestraCamoCost = 1150000
local aircBesraCamoCost = 1350000
local aircMiljetCamoCost = 1900000
local aircLuxorCamoCost = 1825000
local aircLuxorDeluxeCamoCost = 10000000
local aircShamalCamoCost = 1350000
local aircLazerCamoCost = 16000000
local aircHydraCamoCost = 24000000

	--PROPELLER SE
local aircCargoCamoCost = 3200000
local aircCuban800CamoCost = 440000
local aircDusterCamoCost = 475000
local aircDodoCamoCost = 700000
local aircMallardCamoCost = 450000
local aircMammatusCamoCost = 500000
local aircTitanCamoCost = 2200000
local aircVelumCamoCost = 650000

--AIRCRAFT NAME SE
	--JET SE
local aircVestraCamoPlaneName = "Vestra Desert Camouflage"
local aircBesraCamoPlaneName = "Besra Desert Camouflage"
local aircMiljetCamoPlaneName = "Miljet Desert Camouflage"
local aircLuxorCamoPlaneName = "Buckingham Luxor Desert Camouflage"
local aircLuxorDeluxeCamoPlaneName = "Buckingham Luxor Deluxe"
local aircShamalCamoPlaneName = "Buckingham Shamal Desert Camouflage"
local aircLazerCamoPlaneName = "P-996 Lazer"
local aircHydraCamoPlaneName = "Hydra V/STOL Fighter"

	--PROPELLER SE
local aircCargoCamoPlaneName = "Cargo Plane Desert Camouflage"
local aircCuban800CamoPlaneName = "Cuban 800 Desert Camouflage"
local aircDusterCamoPlaneName = "Duster Desert Camouflage"
local aircDodoCamoPlaneName = "Dodo Desert Camouflage"
local aircMallardCamoPlaneName = "Mallard Desert Camouflage"
local aircMammatusCamoPlaneName = "Mammatus Desert Camouflage"
local aircTitanCamoPlaneName = "Titan Desert Camouflage"
local aircVelumCamoPlaneName = "Velum Desert Camouflage"

local showMenu = false

local buy = false
local timebuy = 99999
local buyLimitSR2 = false
local PlaneName = "not set"
local CamoPlaneName = "not set"

local spawned = false
local bs2Ped

local cost = 0

-------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------

function ArmoredPacksSr2Mod.tick()

	local playerPed = PLAYER.PLAYER_PED_ID()
	local playerPedinV = PED.IS_PED_IN_ANY_VEHICLE(playerPed, false)
	local playerCoords = ENTITY.GET_ENTITY_COORDS(playerPed, true)
	local buyPoint = GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS(playerCoords.x, playerCoords.y, playerCoords.z, 2120.961, 4784.109, 40.970, true)
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local location = ENTITY.GET_ENTITY_COORDS( playerPed, nil )
	
	--SHOW MENU FLAG
	if (not playerPedinV and buyPoint < 2 and not showMenu) then
		if PED._IS_PED_DEAD(bs2Ped, true) then
			PLAYER.SET_PLAYER_WANTED_LEVEL(player, 4, false)
			PLAYER.SET_PLAYER_WANTED_LEVEL_NOW(player, false)
			BGAP2SHUD.DrawTextNotif1("~y~Mckenzie Field~s~ is closed. Please come", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif1("back later.", renHUDyNotif + 0.0265, renHUDxNotif, 0.355)
			GRAPHICS.DRAW_RECT(0.158, 0.084, 0.215, 0.0685, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
		else
			BGAP2SHUD.DrawTextNotif1("Press      to browse airplane.", renHUDyNotif, renHUDxNotif, 0.355)
			BGAP2SHUD.DrawTextNotif2("~u~E", renHUDyNotif + 0.0025, renHUDxNotif + 0.035, 0.31)
			GRAPHICS.DRAW_RECT(0.132, 0.074, 0.163, 0.0485, redHUDNotif1, greenHUDNotif1, blueHUDNotif1, alphaHUDNotif1)
			GRAPHICS.DRAW_RECT(0.095, 0.071, 0.0134, 0.0235, redHUDNotif2, greenHUDNotif2, blueHUDNotif2, alphaHUDNotif2)
		
			if (get_key_pressed(DFMKey) and showMenu == false) then
				notify("Welcome to ~y~Mckenzie Field~s~, want to buy something? ~h~PRESS E~h~")
				showMenu = true
			end
		end
	end
	
	--SHOW MENU
	if(showMenu == true) then
		APSr2GUI.tick()
	end

	--CLOSE MENU
	if(buyPoint > 2 and showMenu == true) then
		showMenu = false
	end
	
	--SPAWN/DESPAWN DEALER
	if(spawned == false and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,2120.961, 4784.109, 40.970, false ) < 150 ) then
		spawnSr2Dealer()
		spawned = true
	elseif(spawned == true and GAMEPLAY.GET_DISTANCE_BETWEEN_COORDS( location.x, location.y, location.z,2120.961, 4784.109, 40.970, false ) > 150 ) then
		PED.DELETE_PED(bs2Ped)
		PED.DELETE_PED(sc2Ped[0])
		PED.DELETE_PED(sc2Ped[1])
		businessman2Money = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(businessman2)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(security2)
		spawned = false
	end

	if (buyLimitSR2 == true and TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
		buyLimitSR2 = false
	end
end

--DEALER SPAWN
function ArmoredPacksSr2Mod.unload()
	UI.REMOVE_BLIP(blipSr2)
	if spawned == true then
		PED.DELETE_PED(bs2Ped)
		PED.DELETE_PED(sc2Ped[0])
		PED.DELETE_PED(sc2Ped[1])
		businessman2Money = 0
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(businessman2)
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(security2)
	end
end

function spawnSr2Dealer()

	local weapon = GAMEPLAY.GET_HASH_KEY("WEAPON_PISTOL")

	---BUSINESSMAN2---
	businessman2 = GAMEPLAY.GET_HASH_KEY("A_M_Y_Business_02")
	STREAMING.REQUEST_MODEL(businessman2)
	while(not STREAMING.HAS_MODEL_LOADED(businessman2)) do
		wait(50)
	end
	bs2Ped = PED.CREATE_PED(1, businessman2, 2120.961, 4784.109, 40.970, 291, true, true)
	PED.SET_PED_CAN_SWITCH_WEAPON(bs2Ped, true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(bs2Ped, weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(bs2Ped, GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(bs2Ped, false)
	PED.SET_PED_RANDOM_PROPS(bs2Ped)
	businessman2Money = (GAMEPLAY.GET_RANDOM_INT_IN_RANGE(50000,100000))
	PED.SET_PED_MONEY(bs2Ped, businessman2Money)

	---SECURITY2---
	security2 = GAMEPLAY.GET_HASH_KEY("S_M_M_Security_01")

	STREAMING.REQUEST_MODEL(security2)
	
	while(not STREAMING.HAS_MODEL_LOADED(security2)) do
		wait(50)
	end
	
	sc2Ped = {}
	
	sc2Ped[0] = PED.CREATE_PED(1, security2, 2124.200, 4780.302, 40.970, 16, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(sc2Ped[0], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(sc2Ped[0], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(sc2Ped[0], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(sc2Ped[0], false)
	PED.SET_PED_RANDOM_PROPS(sc2Ped[0])
	
	sc2Ped[1] = PED.CREATE_PED(1, security2, 2145.769, 4781.981, 40.985, 114, true,true)
	PED.SET_PED_CAN_SWITCH_WEAPON(sc2Ped[1], true)
	WEAPON.GIVE_DELAYED_WEAPON_TO_PED(sc2Ped[1], weapon, 1000, false)
	PED.SET_PED_RELATIONSHIP_GROUP_HASH(sc2Ped[1], GAMEPLAY.GET_HASH_KEY("PRIVATE_SECURITY"))
	ENTITY.SET_ENTITY_INVINCIBLE(sc2Ped[1], false)
	PED.SET_PED_RANDOM_PROPS(sc2Ped[1])
end

--VEHICLE SPAWN
function spawnSr2Aircraft(modelString)

	if (buyFalse == false) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then cost = aircVestraCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then cost = aircBesraCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then cost = aircMiljetCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then cost = aircLuxorCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then cost = aircLuxorDeluxeCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then cost = aircShamalCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then cost = aircLazerCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then cost = aircHydraCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargo")) then cost = aircCargoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then cost = aircCuban800Cost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then cost = aircDusterCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then cost = aircDodoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then cost = aircMallardCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then cost = aircMammatusCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then cost = aircTitanCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then cost = aircVelumCost
		end
		
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then PlaneName = aircVestraPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then PlaneName = aircBesraPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then PlaneName = aircMiljetPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then PlaneName = aircLuxorPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then PlaneName = aircLuxorDeluxePlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then PlaneName = aircShamalPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then PlaneName = aircLazerPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then PlaneName = aircHydraPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargo")) then PlaneName = aircCargoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then PlaneName = aircCuban800PlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then PlaneName = aircDusterPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then PlaneName = aircDodoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then PlaneName = aircMallardPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then PlaneName = aircMammatusPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then PlaneName = aircTitanPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then PlaneName = aircVelumPlaneName
		end

	Pay(cost)

		if (buyFalse == false) then
		spawnSr2AircraftNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry. But you don't have enough money.")
		buyFalse = false
		end
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnSr2AircraftNow(modelString)

	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)

	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehSr2 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), 2118.406, 4803.715, 41.196, 110, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehSr2)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehSr2, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehSr2, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehSr2, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehSr2, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehSr2, 0)
	VEHICLE.SET_VEHICLE_MOD(vehSr2, 16, 2, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehSr2, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehSr2, 1)
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehSr2, true) 			

	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehSr2)

	buy = true
	notify("Your " .. PlaneName .. " is already delivered. Thank you!")
	end
end

--VEHICLE SPAWN
function spawnSrCamo2Aircraft(modelString)

	if (buyLimitSR2 == false and (TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)) then

		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then cost = aircVestraCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then cost = aircBesraCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then cost = aircMiljetCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then cost = aircLuxorCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then cost = aircLuxorDeluxeCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then cost = aircShamalCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then cost = aircLazerCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then cost = aircHydraCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargoplane")) then cost = aircCargoCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then cost = aircCuban800CamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then cost = aircDusterCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then cost = aircDodoCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then cost = aircMallardCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then cost = aircMammatusCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then cost = aircTitanCamoCost
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then cost = aircVelumCamoCost
		end
		
		if(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("vestra")) then CamoPlaneName = aircVestraCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("besra")) then CamoPlaneName = aircBesraCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("miljet")) then CamoPlaneName = aircMiljetCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxor")) then CamoPlaneName = aircLuxorCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("luxord")) then CamoPlaneName = aircLuxorDeluxeCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("shamal")) then CamoPlaneName = aircShamalCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("lazer")) then CamoPlaneName = aircLazerCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("hydra")) then CamoPlaneName = aircHydraCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cargoplane")) then CamoPlaneName = aircCargoCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("cuban800")) then CamoPlaneName = aircCuban800CamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("duster")) then CamoPlaneName = aircDusterCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("dodo")) then CamoPlaneName = aircDodoCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mallard")) then CamoPlaneName = aircMallardCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("mammatus")) then CamoPlaneName = aircMammatusCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("titan")) then CamoPlaneName = aircTitanCamoPlaneName
		elseif(GAMEPLAY.GET_HASH_KEY(modelString) == GAMEPLAY.GET_HASH_KEY("velum")) then CamoPlaneName = aircVelumCamoPlaneName
		end

	Pay(cost)

		if (buyFalse == false and buyLimitSR2 == false) then
		spawnSrCamo2AircraftNow(modelString)
		end

		if (buyFalse == true) then
		notify("Sorry. But you don't have enough money.")
		buyFalse = false
		end

	elseif(buyLimitSR2 == true and TIME.GET_CLOCK_DAY_OF_MONTH() == timebuy) then
		notify("I'm sorry, but you have to wait for a new shipment.")
	end
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
function spawnSrCamo2AircraftNow(modelString)

	print(timebuy)
	print(TIME.GET_CLOCK_DAY_OF_MONTH())
	print(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy)

	if(TIME.GET_CLOCK_DAY_OF_MONTH() ~= timebuy) then
	buyLimitSR2 = true

	local cost

	AUDIO.PLAY_SOUND_FRONTEND(-1, "PICK_UP", "HUD_FRONTEND_DEFAULT_SOUNDSET", true)

	CAM.DO_SCREEN_FADE_OUT(500)
	wait(500)
	CAM.DO_SCREEN_FADE_IN(500)

	timebuy = TIME.GET_CLOCK_DAY_OF_MONTH()
		
	STREAMING.REQUEST_MODEL(GAMEPLAY.GET_HASH_KEY(modelString))
		
	while(not STREAMING.HAS_MODEL_LOADED(GAMEPLAY.GET_HASH_KEY(modelString))) do
		wait(50)
	end

	if (buyFalse == false) then

	local vehSrcamo2 = VEHICLE.CREATE_VEHICLE(GAMEPLAY.GET_HASH_KEY(modelString), 2118.406, 4803.715, 41.196, 110, true, true)
	VEHICLE.SET_VEHICLE_ON_GROUND_PROPERLY(vehSrcamo2)
		
	VEHICLE.SET_VEHICLE_NEEDS_TO_BE_HOTWIRED(vehSrcamo2, false) 		
	VEHICLE.SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER(vehSrcamo2, true)
	VEHICLE.SET_VEHICLE_IS_STOLEN(vehSrcamo2, false)
	VEHICLE.SET_VEHICLE_IS_WANTED(vehSrcamo2, false)
	VEHICLE.SET_VEHICLE_MOD_KIT(vehSrcamo2, 0)
	VEHICLE.SET_VEHICLE_MOD(vehSrcamo2, 11, 3, true) 
	VEHICLE.SET_VEHICLE_MOD(vehSrcamo2, 12, 2, true) 
	VEHICLE.SET_VEHICLE_MOD(vehSrcamo2, 13, 2, true)
	VEHICLE.SET_VEHICLE_MOD(vehSrcamo2, 15, 3, true) 
	VEHICLE.SET_VEHICLE_MOD(vehSrcamo2, 16, 2, true)
	VEHICLE.SET_VEHICLE_WHEEL_TYPE(vehSrcamo2, 120)
	VEHICLE.SET_VEHICLE_WINDOW_TINT(vehSrcamo2, 1) 
	VEHICLE.SET_CAN_RESPRAY_VEHICLE(vehSrcamo2, true) 
	VEHICLE.SET_VEHICLE_TYRES_CAN_BURST(vehSrcamo2, false) 
	VEHICLE.SET_VEHICLE_WHEELS_CAN_BREAK(vehSrcamo2, true) 			
	VEHICLE.SET_VEHICLE_CUSTOM_PRIMARY_COLOUR(vehSrcamo2, 210, 180, 140)
	VEHICLE.SET_VEHICLE_CUSTOM_SECONDARY_COLOUR(vehSrcamo2, 173, 147, 113)

	STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(GAMEPLAY.GET_HASH_KEY(modelString))
	ENTITY.SET_VEHICLE_AS_NO_LONGER_NEEDED(vehSrcamo2)

	buy = true
	notify("Your " .. CamoPlaneName .. " is already delivered. Thank you!")
	end
	end
		wait(5)		
end

------------------------------------------------------------------------------
return ArmoredPacksSr2Mod

-- Credits to: Alexander Blade & headscript--