/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.Alias;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationProxy<T extends Annotation>
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final T annotation;
    private final Class<T> type;
    private final Map<String, Object> attributes;

    public AnnotationProxy(T annotation) {
        this.annotation = annotation;
        this.type = annotation.annotationType();
        this.attributes = this.initAttributes();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.type;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name;
        Alias alias = method.getAnnotation(Alias.class);
        if (null != alias && StrUtil.isNotBlank(name = alias.value())) {
            if (!this.attributes.containsKey(name)) {
                throw new IllegalArgumentException(StrUtil.format("No method for alias: [{}]", name));
            }
            return this.attributes.get(name);
        }
        Object value = this.attributes.get(method.getName());
        if (value != null) {
            return value;
        }
        return method.invoke((Object)this, args);
    }

    private Map<String, Object> initAttributes() {
        Method[] methods2 = ReflectUtil.getMethods(this.type);
        HashMap<String, Object> attributes = new HashMap<String, Object>(methods2.length, 1.0f);
        for (Method method : methods2) {
            if (method.isSynthetic()) continue;
            attributes.put(method.getName(), ReflectUtil.invoke(this.annotation, method, new Object[0]));
        }
        return attributes;
    }
}

