/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation.scanner;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetaAnnotationScanner
implements AnnotationScanner {
    private final boolean includeSupperMetaAnnotation;

    public MetaAnnotationScanner(boolean includeSupperMetaAnnotation) {
        this.includeSupperMetaAnnotation = includeSupperMetaAnnotation;
    }

    public MetaAnnotationScanner() {
        this(true);
    }

    @Override
    public boolean support(AnnotatedElement annotatedEle) {
        return annotatedEle instanceof Class && ClassUtil.isAssignable(Annotation.class, (Class)annotatedEle);
    }

    @Override
    public List<Annotation> getAnnotations(AnnotatedElement annotatedEle) {
        ArrayList<Annotation> annotations2 = new ArrayList<Annotation>();
        this.scan((index, annotation) -> annotations2.add((Annotation)annotation), annotatedEle, annotation -> ObjectUtil.notEqual(annotation, annotatedEle));
        return annotations2;
    }

    @Override
    public void scan(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter2) {
        filter2 = ObjectUtil.defaultIfNull(filter2, a -> t -> true);
        HashSet<Class> accessed = new HashSet<Class>();
        LinkedList<List> deque = CollUtil.newLinkedList(CollUtil.newArrayList((Class)annotatedEle));
        int distance = 0;
        do {
            List annotationTypes = (List)deque.removeFirst();
            for (Class type2 : annotationTypes) {
                List metaAnnotations = Stream.of(type2.getAnnotations()).filter(a -> !AnnotationUtil.isJdkMetaAnnotation(a.annotationType())).filter(filter2).collect(Collectors.toList());
                for (Annotation metaAnnotation : metaAnnotations) {
                    consumer.accept(distance, metaAnnotation);
                }
                accessed.add(type2);
                List next = metaAnnotations.stream().map(Annotation::annotationType).filter(t -> !accessed.contains(t)).collect(Collectors.toList());
                if (!CollUtil.isNotEmpty(next)) continue;
                deque.addLast(next);
            }
            ++distance;
        } while (this.includeSupperMetaAnnotation && !deque.isEmpty());
    }
}

