/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean.copier.provider;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.map.FuncKeyMap;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class BeanValueProvider
implements ValueProvider<String> {
    private final Object source;
    private final boolean ignoreError;
    final Map<String, PropDesc> sourcePdMap;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this(bean, ignoreCase, ignoreError, null);
    }

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError, Editor<String> keyEditor) {
        this.source = bean;
        this.ignoreError = ignoreError;
        Map<String, PropDesc> sourcePdMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
        this.sourcePdMap = new FuncKeyMap<String, PropDesc>(new HashMap(sourcePdMap.size(), 1.0f), (Function<Object, String> & Serializable)key2 -> {
            if (ignoreCase && key2 instanceof CharSequence) {
                key2 = key2.toString().toLowerCase();
            }
            if (null != keyEditor) {
                key2 = keyEditor.edit(key2.toString());
            }
            return key2.toString();
        });
        this.sourcePdMap.putAll(sourcePdMap);
    }

    @Override
    public Object value(String key2, Type valueType) {
        PropDesc sourcePd = this.getPropDesc(key2, valueType);
        Object result2 = null;
        if (null != sourcePd) {
            result2 = sourcePd.getValue(this.source, valueType, this.ignoreError);
        }
        return result2;
    }

    @Override
    public boolean containsKey(String key2) {
        PropDesc sourcePd = this.getPropDesc(key2, null);
        return null != sourcePd && sourcePd.isReadable(false);
    }

    private PropDesc getPropDesc(String key2, Type valueType) {
        PropDesc sourcePd = this.sourcePdMap.get(key2);
        if (null == sourcePd && (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StrUtil.upperFirstAndAddPre(key2, "is"));
        }
        return sourcePd;
    }
}

