/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.lang.Assert;

public class Caesar {
    public static final String TABLE = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";

    public static String encode(String message2, int offset) {
        Assert.notNull(message2, "message must be not null!", new Object[0]);
        int len = message2.length();
        char[] plain = message2.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = message2.charAt(i2);
            if (!Character.isLetter(c)) continue;
            plain[i2] = Caesar.encodeChar(c, offset);
        }
        return new String(plain);
    }

    public static String decode(String cipherText, int offset) {
        Assert.notNull(cipherText, "cipherText must be not null!", new Object[0]);
        int len = cipherText.length();
        char[] plain = cipherText.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = cipherText.charAt(i2);
            if (!Character.isLetter(c)) continue;
            plain[i2] = Caesar.decodeChar(c, offset);
        }
        return new String(plain);
    }

    private static char encodeChar(char c, int offset) {
        int position = (TABLE.indexOf(c) + offset) % 52;
        return TABLE.charAt(position);
    }

    private static char decodeChar(char c, int offset) {
        int position = (TABLE.indexOf(c) - offset) % 52;
        if (position < 0) {
            position += 52;
        }
        return TABLE.charAt(position);
    }
}

