/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.lang.Assert;

public class Rot {
    private static final char aCHAR = 'a';
    private static final char zCHAR = 'z';
    private static final char ACHAR = 'A';
    private static final char ZCHAR = 'Z';
    private static final char CHAR0 = '0';
    private static final char CHAR9 = '9';

    public static String encode13(String message2) {
        return Rot.encode13(message2, true);
    }

    public static String encode13(String message2, boolean isEncodeNumber) {
        return Rot.encode(message2, 13, isEncodeNumber);
    }

    public static String encode(String message2, int offset, boolean isEncodeNumber) {
        Assert.notNull(message2, "message must not be null", new Object[0]);
        int len = message2.length();
        char[] chars = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            chars[i2] = Rot.encodeChar(message2.charAt(i2), offset, isEncodeNumber);
        }
        return new String(chars);
    }

    public static String decode13(String rot) {
        return Rot.decode13(rot, true);
    }

    public static String decode13(String rot, boolean isDecodeNumber) {
        return Rot.decode(rot, 13, isDecodeNumber);
    }

    public static String decode(String rot, int offset, boolean isDecodeNumber) {
        Assert.notNull(rot, "rot must not be null", new Object[0]);
        int len = rot.length();
        char[] chars = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            chars[i2] = Rot.decodeChar(rot.charAt(i2), offset, isDecodeNumber);
        }
        return new String(chars);
    }

    private static char encodeChar(char c, int offset, boolean isDecodeNumber) {
        if (isDecodeNumber && c >= '0' && c <= '9') {
            c = (char)(c - 48);
            c = (char)((c + offset) % 10);
            c = (char)(c + 48);
        }
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c - 65);
            c = (char)((c + offset) % 26);
            c = (char)(c + 65);
        } else if (c >= 'a' && c <= 'z') {
            c = (char)(c - 97);
            c = (char)((c + offset) % 26);
            c = (char)(c + 97);
        }
        return c;
    }

    private static char decodeChar(char c, int offset, boolean isDecodeNumber) {
        int temp = c;
        if (isDecodeNumber && temp >= 48 && temp <= 57) {
            temp -= 48;
            temp -= offset;
            while (temp < 0) {
                temp += 10;
            }
            temp += 48;
        }
        if (temp >= 65 && temp <= 90) {
            temp -= 65;
            temp -= offset;
            while (temp < 0) {
                temp = 26 + temp;
            }
            temp += 65;
        } else if (temp >= 97 && temp <= 122) {
            temp -= 97;
            if ((temp -= offset) < 0) {
                temp = 26 + temp;
            }
            temp += 97;
        }
        return (char)temp;
    }
}

