/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.Partition;
import cn.hutool.core.lang.Assert;
import java.util.List;

public class AvgPartition<T>
extends Partition<T> {
    final int limit;
    final int remainder;

    public AvgPartition(List<T> list2, int limit) {
        super(list2, list2.size() / (limit <= 0 ? 1 : limit));
        Assert.isTrue(limit > 0, "Partition limit must be > 0", new Object[0]);
        this.limit = limit;
        this.remainder = list2.size() % limit;
    }

    @Override
    public List<T> get(int index) {
        int size = this.size;
        int remainder = this.remainder;
        int start2 = index * size + Math.min(index, remainder);
        int end = start2 + size;
        if (index + 1 <= remainder) {
            ++end;
        }
        return this.list.subList(start2, end);
    }

    @Override
    public int size() {
        return this.limit;
    }
}

