/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.collection.FilterIter;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.collection.NodeListIter;
import cn.hutool.core.collection.TransIter;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IterUtil {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        return null == iterable ? null : iterable.iterator();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return null != Iterator2 && Iterator2.hasNext();
    }

    public static boolean hasNull(Iterable<?> iter) {
        return IterUtil.hasNull(null == iter ? null : iter.iterator());
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        return IterUtil.isAllNull(null == iter ? null : iter.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        return null == IterUtil.getFirstNoneNull(iter);
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                T t = iter.next();
                countMap.put(t, countMap.getOrDefault(t, 0) + 1);
            }
        }
        return countMap;
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        return IterUtil.toMap(iter, new HashMap(), (V value) -> ReflectUtil.getFieldValue(value, fieldName));
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iter, String fieldNameForKey, String fieldNameForValue) {
        return IterUtil.toMap(iter, new HashMap(), (E value) -> ReflectUtil.getFieldValue(value, fieldNameForKey), (E value) -> ReflectUtil.getFieldValue(value, fieldNameForValue));
    }

    public static <V> List<Object> fieldValueList(Iterable<V> iterable, String fieldName) {
        return IterUtil.fieldValueList(IterUtil.getIter(iterable), fieldName);
    }

    public static <V> List<Object> fieldValueList(Iterator<V> iter, String fieldName) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (null != iter) {
            while (iter.hasNext()) {
                V value = iter.next();
                result2.add(ReflectUtil.getFieldValue(value, fieldName));
            }
        }
        return result2;
    }

    public static <T> String join(Iterator<T> iterator2, CharSequence conjunction) {
        return StrJoiner.of(conjunction).append(iterator2).toString();
    }

    public static <T> String join(Iterator<T> iterator2, CharSequence conjunction, String prefix, String suffix) {
        return StrJoiner.of(conjunction, prefix, suffix).setWrapElement(true).append(iterator2).toString();
    }

    public static <T> String join(Iterator<T> iterator2, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        if (null == iterator2) {
            return null;
        }
        return StrJoiner.of(conjunction).append(iterator2, func).toString();
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map2 = new HashMap<K, V>();
        if (IterUtil.isNotEmpty(entryIter)) {
            for (Map.Entry<K, V> entry : entryIter) {
                map2.put(entry.getKey(), entry.getValue());
            }
        }
        return map2;
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys2, Iterable<V> values2) {
        return IterUtil.toMap(keys2, values2, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys2, Iterable<V> values2, boolean isOrder) {
        return IterUtil.toMap(null == keys2 ? null : keys2.iterator(), null == values2 ? null : values2.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys2, Iterator<V> values2) {
        return IterUtil.toMap(keys2, values2, false);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys2, Iterator<V> values2, boolean isOrder) {
        HashMap<K, Object> resultMap = MapUtil.newHashMap(isOrder);
        if (IterUtil.isNotEmpty(keys2)) {
            while (keys2.hasNext()) {
                resultMap.put(keys2.next(), null != values2 && values2.hasNext() ? (Object)values2.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtil.toListMap(iterable, keyMapper, v -> v);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtil.toListMap(MapUtil.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtil.toMap(iterable, keyMapper, (T v) -> v);
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtil.toMap(MapUtil.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        if (null == iter) {
            return null;
        }
        return IterUtil.toList(iter.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        return ListUtil.toList(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIter<E>(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static <E> E get(Iterator<E> iterator2, int index) throws IndexOutOfBoundsException {
        if (null == iterator2) {
            return null;
        }
        Assert.isTrue(index >= 0, "[index] must be >= 0", new Object[0]);
        while (iterator2.hasNext()) {
            if (-1 == --index) {
                return iterator2.next();
            }
            iterator2.next();
        }
        return null;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list2 = (List)iterable;
            return CollUtil.isEmpty(list2) ? null : (T)list2.get(0);
        }
        return IterUtil.getFirst(IterUtil.getIter(iterable));
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.getFirstNoneNull(iterable.iterator());
    }

    public static <T> T getFirst(Iterator<T> iterator2) {
        return IterUtil.get(iterator2, 0);
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator2) {
        return (T)IterUtil.firstMatch(iterator2, Objects::nonNull);
    }

    public static <T> T firstMatch(Iterator<T> iterator2, Matcher<T> matcher) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (null != iterator2) {
            while (iterator2.hasNext()) {
                T next = iterator2.next();
                if (!matcher.match(next)) continue;
                return next;
            }
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterUtil.getElementType(IterUtil.getIter(iterable));
    }

    public static Class<?> getElementType(Iterator<?> iterator2) {
        if (null == iterator2) {
            return null;
        }
        Object ele = IterUtil.getFirstNoneNull(iterator2);
        return null == ele ? null : ele.getClass();
    }

    public static <T> List<T> edit(Iterable<T> iter, Editor<T> editor) {
        ArrayList<T> result2 = new ArrayList<T>();
        if (null == iter) {
            return result2;
        }
        for (T t : iter) {
            T modified = null == editor ? t : editor.edit(t);
            if (null == modified) continue;
            result2.add(modified);
        }
        return result2;
    }

    public static <T extends Iterable<E>, E> T filter(T iter, Filter<E> filter2) {
        if (null == iter) {
            return null;
        }
        IterUtil.filter(iter.iterator(), filter2);
        return iter;
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Filter<E> filter2) {
        if (null == iter || null == filter2) {
            return iter;
        }
        while (iter.hasNext()) {
            if (filter2.accept(iter.next())) continue;
            iter.remove();
        }
        return iter;
    }

    public static <E> List<E> filterToList(Iterator<E> iter, Filter<E> filter2) {
        return IterUtil.toList(IterUtil.filtered(iter, filter2));
    }

    public static <E> FilterIter<E> filtered(Iterator<? extends E> iterator2, Filter<? super E> filter2) {
        return new FilterIter<E>(iterator2, filter2);
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> iterator2, Map<K, V> map2, Func1<V, K> keyFunc) {
        return IterUtil.toMap(iterator2, map2, keyFunc, (E value) -> value);
    }

    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator2, Map<K, V> map2, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        if (null == iterator2) {
            return map2;
        }
        if (null == map2) {
            map2 = MapUtil.newHashMap(true);
        }
        while (iterator2.hasNext()) {
            E element = iterator2.next();
            try {
                map2.put(keyFunc.call(element), valueFunc.call(element));
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return map2;
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator2, Function<? super F, ? extends T> function) {
        return new TransIter<F, T>(iterator2, function);
    }

    public static int size(Iterable<?> iterable) {
        if (null == iterable) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IterUtil.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator2) {
        int size = 0;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                iterator2.next();
                ++size;
            }
        }
        return size;
    }

    public static boolean isEqualList(Iterable<?> list1, Iterable<?> list2) {
        if (list1 == list2) {
            return true;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object obj2;
            Object obj1 = it1.next();
            if (Objects.equals(obj1, obj2 = it2.next())) continue;
            return false;
        }
        return false == (it1.hasNext() || it2.hasNext());
    }

    public static void clear(Iterator<?> iterator2) {
        if (null != iterator2) {
            while (iterator2.hasNext()) {
                iterator2.next();
                iterator2.remove();
            }
        }
    }

    public static <E> void forEach(Iterator<E> iterator2, Consumer<? super E> consumer) {
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                E element = iterator2.next();
                if (null == consumer) continue;
                consumer.accept(element);
            }
        }
    }

    public static <E> String toStr(Iterator<E> iterator2) {
        return IterUtil.toStr(iterator2, ObjectUtil::toString);
    }

    public static <E> String toStr(Iterator<E> iterator2, Function<? super E, String> transFunc) {
        return IterUtil.toStr(iterator2, transFunc, ", ", "[", "]");
    }

    public static <E> String toStr(Iterator<E> iterator2, Function<? super E, String> transFunc, String delimiter, String prefix, String suffix) {
        StrJoiner strJoiner = StrJoiner.of(delimiter, prefix, suffix);
        strJoiner.append(iterator2, transFunc);
        return strJoiner.toString();
    }

    public static Iterator<?> getIter(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (ArrayUtil.isArray(obj)) {
            return new ArrayIter(obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIter((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        if (obj instanceof NodeList) {
            return new NodeListIter((NodeList)obj);
        }
        if (obj instanceof Node) {
            return new NodeListIter(((Node)obj).getChildNodes());
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIter(((Dictionary)obj).elements());
        }
        try {
            Object iterator2 = ReflectUtil.invoke(obj, "iterator", new Object[0]);
            if (iterator2 instanceof Iterator) {
                return (Iterator)iterator2;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new ArrayIter<Object>(new Object[]{obj});
    }
}

