/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.AvgPartition;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.Partition;
import cn.hutool.core.collection.RandomAccessAvgPartition;
import cn.hutool.core.collection.RandomAccessPartition;
import cn.hutool.core.comparator.PinyinComparator;
import cn.hutool.core.comparator.PropertyComparator;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class ListUtil {
    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return ListUtil.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values2.length);
        Collections.addAll(arrayList, values2);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return ListUtil.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return ListUtil.list(isLinked);
        }
        return ListUtil.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list2 = ListUtil.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list2.add(iter.next());
            }
        }
        return list2;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        List<T> list2 = ListUtil.list(isLinked);
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list2.add(enumration.nextElement());
            }
        }
        return list2;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values2) {
        return (ArrayList)ListUtil.list(false, values2);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values2) {
        return (LinkedList)ListUtil.list(true, values2);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... ts) {
        if (ArrayUtil.isEmpty(ts)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ListUtil.toList(ts));
    }

    public static <T> CopyOnWriteArrayList<T> toCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        return (ArrayList)ListUtil.list(false, collection);
    }

    public static <T> ArrayList<T> toList(Iterable<T> iterable) {
        return (ArrayList)ListUtil.list(false, iterable);
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator2) {
        return (ArrayList)ListUtil.list(false, iterator2);
    }

    public static <T> ArrayList<T> toList(Enumeration<T> enumeration) {
        return (ArrayList)ListUtil.list(false, enumeration);
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list2) {
        if (CollUtil.isEmpty(list2)) {
            return new ArrayList(0);
        }
        int resultSize = list2.size();
        if (resultSize <= pageSize) {
            if (pageNo < PageUtil.getFirstPageNo() + 1) {
                return ListUtil.unmodifiable(list2);
            }
            return new ArrayList(0);
        }
        if ((long)(pageNo - PageUtil.getFirstPageNo()) * (long)pageSize > (long)resultSize) {
            return new ArrayList(0);
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
            if (startEnd[0] > startEnd[1]) {
                return new ArrayList(0);
            }
        }
        return ListUtil.sub(list2, startEnd[0], startEnd[1]);
    }

    public static <T> void page(List<T> list2, int pageSize, Consumer<List<T>> pageListConsumer) {
        if (CollUtil.isEmpty(list2) || pageSize <= 0) {
            return;
        }
        int total = list2.size();
        int totalPage = PageUtil.totalPage(total, pageSize);
        for (int pageNo = PageUtil.getFirstPageNo(); pageNo < totalPage + PageUtil.getFirstPageNo(); ++pageNo) {
            int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
            if (startEnd[1] > total) {
                startEnd[1] = total;
            }
            pageListConsumer.accept(ListUtil.sub(list2, startEnd[0], startEnd[1]));
        }
    }

    public static <T> List<T> sort(List<T> list2, Comparator<? super T> c) {
        if (CollUtil.isEmpty(list2)) {
            return list2;
        }
        list2.sort(c);
        return list2;
    }

    public static <T> List<T> sortByProperty(List<T> list2, String property) {
        return ListUtil.sort(list2, new PropertyComparator(property));
    }

    public static List<String> sortByPinyin(List<String> list2) {
        return ListUtil.sort(list2, new PinyinComparator());
    }

    public static <T> List<T> reverse(List<T> list2) {
        Collections.reverse(list2);
        return list2;
    }

    public static <T> List<T> reverseNew(List<T> list2) {
        List<T> list22 = ObjectUtil.clone(list2);
        if (null == list22) {
            list22 = new ArrayList<T>(list2);
        }
        return ListUtil.reverse(list22);
    }

    public static <T> List<T> setOrAppend(List<T> list2, int index, T element) {
        Assert.notNull(list2, "List must be not null !", new Object[0]);
        if (index < list2.size()) {
            list2.set(index, element);
        } else {
            list2.add(element);
        }
        return list2;
    }

    public static <T> List<T> setOrPadding(List<T> list2, int index, T element) {
        return ListUtil.setOrPadding(list2, index, element, null);
    }

    public static <T> List<T> setOrPadding(List<T> list2, int index, T element, T paddingElement) {
        Assert.notNull(list2, "List must be not null !", new Object[0]);
        int size = list2.size();
        if (index < size) {
            list2.set(index, element);
        } else {
            for (int i2 = size; i2 < index; ++i2) {
                list2.add(paddingElement);
            }
            list2.add(element);
        }
        return list2;
    }

    public static <T> List<T> sub(List<T> list2, int start2, int end) {
        return ListUtil.sub(list2, start2, end, 1);
    }

    public static <T> List<T> sub(List<T> list2, int start2, int end, int step) {
        if (list2 == null) {
            return null;
        }
        if (list2.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list2.size();
        if (start2 < 0) {
            start2 += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start2 == size) {
            return new ArrayList(0);
        }
        if (start2 > end) {
            int tmp = start2;
            start2 = end;
            end = tmp;
        }
        if (end > size) {
            if (start2 >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step < 1) {
            step = 1;
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (int i2 = start2; i2 < end; i2 += step) {
            result2.add(list2.get(i2));
        }
        return result2;
    }

    public static <T> int lastIndexOf(List<T> list2, Matcher<T> matcher) {
        int size;
        if (null != list2 && (size = list2.size()) > 0) {
            for (int i2 = size - 1; i2 >= 0; --i2) {
                if (null != matcher && !matcher.match(list2.get(i2))) continue;
                return i2;
            }
        }
        return -1;
    }

    public static <T> int[] indexOfAll(List<T> list2, Matcher<T> matcher) {
        return CollUtil.indexOfAll(list2, matcher);
    }

    public static <T> List<T> unmodifiable(List<T> list2) {
        if (null == list2) {
            return null;
        }
        return Collections.unmodifiableList(list2);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    public static <T> List<List<T>> partition(List<T> list2, int size) {
        if (CollUtil.isEmpty(list2)) {
            return ListUtil.empty();
        }
        return list2 instanceof RandomAccess ? new RandomAccessPartition<T>(list2, size) : new Partition<T>(list2, size);
    }

    public static <T> List<List<T>> split(List<T> list2, int size) {
        return ListUtil.partition(list2, size);
    }

    public static <T> List<List<T>> splitAvg(List<T> list2, int limit) {
        if (CollUtil.isEmpty(list2)) {
            return ListUtil.empty();
        }
        return list2 instanceof RandomAccess ? new RandomAccessAvgPartition<T>(list2, limit) : new AvgPartition<T>(list2, limit);
    }

    public static <T> void swapTo(List<T> list2, T element, Integer targetIndex) {
        int index;
        if (CollUtil.isNotEmpty(list2) && (index = list2.indexOf(element)) >= 0) {
            Collections.swap(list2, index, (int)targetIndex);
        }
    }

    public static <T> void swapElement(List<T> list2, T element, T targetElement) {
        int targetIndex;
        if (CollUtil.isNotEmpty(list2) && (targetIndex = list2.indexOf(targetElement)) >= 0) {
            ListUtil.swapTo(list2, element, targetIndex);
        }
    }
}

