/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.lang.Assert;
import java.util.AbstractList;
import java.util.List;

public class Partition<T>
extends AbstractList<List<T>> {
    protected final List<T> list;
    protected final int size;

    public Partition(List<T> list2, int size) {
        this.list = Assert.notNull(list2);
        this.size = Math.min(list2.size(), size);
    }

    @Override
    public List<T> get(int index) {
        int start2 = index * this.size;
        int end = Math.min(start2 + this.size, this.list.size());
        return this.list.subList(start2, end);
    }

    @Override
    public int size() {
        int size = this.size;
        if (0 == size) {
            return 0;
        }
        int total = this.list.size();
        return (total + size - 1) / size;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

