/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, TypeUtil.getTypeArgument(mapType, 0), TypeUtil.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Object map2;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(this.mapType) && null != (typeArguments = TypeUtil.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(this.keyType, typeArguments[0]) && Objects.equals(this.valueType, typeArguments[1])) {
                return (Map)value;
            }
            map2 = MapUtil.createMap(TypeUtil.getClass(this.mapType));
            this.convertMapToMap((Map)value, (Map<Object, Object>)map2);
        } else if (BeanUtil.isBean(value.getClass())) {
            map2 = BeanUtil.beanToMap(value, new String[0]);
            map2 = this.convertInternal(map2);
        } else {
            throw new UnsupportedOperationException(StrUtil.format("Unsupport toMap value type: {}", value.getClass().getName()));
        }
        return map2;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        srcMap.forEach((key2, value) -> {
            key2 = TypeUtil.isUnknown(this.keyType) ? key2 : convert.convert(this.keyType, key2);
            value = TypeUtil.isUnknown(this.valueType) ? value : convert.convert(this.valueType, value);
            targetMap.put(key2, value);
        });
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return TypeUtil.getClass(this.mapType);
    }
}

