/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import java.util.Calendar;

public class DateModifier {
    private static final int[] IGNORE_FIELDS = new int[]{11, 9, 8, 6, 4, 3};

    public static Calendar modify(Calendar calendar, int dateField, ModifyType modifyType) {
        return DateModifier.modify(calendar, dateField, modifyType, false);
    }

    public static Calendar modify(Calendar calendar, int dateField, ModifyType modifyType, boolean truncateMillisecond) {
        if (9 == dateField) {
            boolean isAM = DateUtil.isAM(calendar);
            switch (modifyType) {
                case TRUNCATE: {
                    calendar.set(11, isAM ? 0 : 12);
                    break;
                }
                case CEILING: {
                    calendar.set(11, isAM ? 11 : 23);
                    break;
                }
                case ROUND: {
                    int min = isAM ? 0 : 12;
                    int max = isAM ? 11 : 23;
                    int href = (max - min) / 2 + 1;
                    int value = calendar.get(11);
                    calendar.set(11, value < href ? min : max);
                }
            }
            return DateModifier.modify(calendar, dateField + 1, modifyType);
        }
        int endField = truncateMillisecond ? 13 : 14;
        for (int i2 = dateField + 1; i2 <= endField; ++i2) {
            if (ArrayUtil.contains(IGNORE_FIELDS, i2) || (4 == dateField || 3 == dateField ? 5 == i2 : 7 == i2)) continue;
            DateModifier.modifyField(calendar, i2, modifyType);
        }
        if (truncateMillisecond) {
            calendar.set(14, 0);
        }
        return calendar;
    }

    private static void modifyField(Calendar calendar, int field2, ModifyType modifyType) {
        if (10 == field2) {
            field2 = 11;
        }
        switch (modifyType) {
            case TRUNCATE: {
                calendar.set(field2, DateUtil.getBeginValue(calendar, field2));
                break;
            }
            case CEILING: {
                calendar.set(field2, DateUtil.getEndValue(calendar, field2));
                break;
            }
            case ROUND: {
                int min = DateUtil.getBeginValue(calendar, field2);
                int max = DateUtil.getEndValue(calendar, field2);
                int href = 7 == field2 ? (min + 3) % 7 : (max - min) / 2 + 1;
                int value = calendar.get(field2);
                calendar.set(field2, value < href ? min : max);
            }
        }
    }

    public static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }
}

