/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        if (null != color) {
            g.setColor(color);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return g;
    }

    public static int getCenterY(Graphics g, int backgroundHeight) {
        FontMetrics metrics = null;
        try {
            metrics = g.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int y = null != metrics ? (backgroundHeight - metrics.getHeight()) / 2 + metrics.getAscent() : backgroundHeight / 3;
        return y;
    }

    public static Graphics drawStringColourful(Graphics g, String str, Font font, int width, int height) {
        return GraphicsUtil.drawString(g, str, font, null, width, height);
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, int width, int height) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        int midY = GraphicsUtil.getCenterY(g, height);
        if (null != color) {
            g.setColor(color);
        }
        int len = str.length();
        int charWidth = width / len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (null == color) {
                g.setColor(ImgUtil.randomColor());
            }
            g.drawString(String.valueOf(str.charAt(i2)), i2 * charWidth, midY);
        }
        return g;
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, Rectangle rectangle2) {
        Dimension dimension;
        int backgroundWidth = rectangle2.width;
        int backgroundHeight = rectangle2.height;
        try {
            dimension = FontUtil.getDimension(g.getFontMetrics(font), str);
        }
        catch (Exception e) {
            dimension = new Dimension(backgroundWidth / 3, backgroundHeight / 3);
        }
        rectangle2.setSize(dimension.width, dimension.height);
        Point point = ImgUtil.getPointBaseCentre(rectangle2, backgroundWidth, backgroundHeight);
        return GraphicsUtil.drawString(g, str, font, color, point);
    }

    public static Graphics drawString(Graphics g, String str, Font font, Color color, Point point) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(font);
        g.setColor(ObjectUtil.defaultIfNull(color, Color.BLACK));
        g.drawString(str, point.x, point.y);
        return g;
    }

    public static Graphics drawImg(Graphics g, Image img2, Point point) {
        return GraphicsUtil.drawImg(g, img2, new Rectangle(point.x, point.y, img2.getWidth(null), img2.getHeight(null)));
    }

    public static Graphics drawImg(Graphics g, Image img2, Rectangle rectangle2) {
        g.drawImage(img2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
        return g;
    }

    public static Graphics2D setAlpha(Graphics2D g, float alpha) {
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        return g;
    }
}

