/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.img.BackgroundRemoval;
import cn.hutool.core.img.ColorUtil;
import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.Img;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class ImgUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    public static void scale(File srcImageFile, File destImageFile, float scale2) {
        ImgUtil.scale((Image)ImgUtil.read(srcImageFile), destImageFile, scale2);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale2) {
        ImgUtil.scale((Image)ImgUtil.read(srcStream), destStream, scale2);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale2) {
        ImgUtil.scale((Image)ImgUtil.read(srcStream), destStream, scale2);
    }

    public static void scale(Image srcImg, File destFile, float scale2) throws IORuntimeException {
        Img.from(srcImg).setTargetImageType(FileUtil.extName(destFile)).scale(scale2).write(destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale2) throws IORuntimeException {
        ImgUtil.scale(srcImg, ImgUtil.getImageOutputStream(out), scale2);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale2) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.scale(srcImg, scale2), destImageStream);
    }

    public static Image scale(Image srcImg, float scale2) {
        return Img.from(srcImg).scale(scale2).getImg();
    }

    public static Image scale(Image srcImg, int width, int height) {
        return Img.from(srcImg).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws IORuntimeException {
        Img.from(srcImageFile).setTargetImageType(FileUtil.extName(destImageFile)).scale(width, height, fixedColor).write(destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.scale(ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.scale(ImgUtil.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return Img.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle2) {
        ImgUtil.cut((Image)ImgUtil.read(srcImgFile), destImgFile, rectangle2);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle2) {
        ImgUtil.cut((Image)ImgUtil.read(srcStream), destStream, rectangle2);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle2) {
        ImgUtil.cut((Image)ImgUtil.read(srcStream), destStream, rectangle2);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle2) throws IORuntimeException {
        ImgUtil.write(ImgUtil.cut(srcImage, rectangle2), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle2) throws IORuntimeException {
        ImgUtil.cut(srcImage, ImgUtil.getImageOutputStream(out), rectangle2);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle2) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.cut(srcImage, rectangle2), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle2) {
        return Img.from(srcImage).setPositionBaseCentre(false).cut(rectangle2).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImgUtil.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return Img.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImgUtil.slice(ImgUtil.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < destWidth) {
            destWidth = srcWidth;
        }
        if (srcHeight < destHeight) {
            destHeight = srcHeight;
        }
        int cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor((double)srcWidth / (double)destWidth) + 1;
        int rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor((double)srcHeight / (double)destHeight) + 1;
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImgUtil.cut(srcImage, new Rectangle(j * destWidth, i2 * destHeight, destWidth, destHeight));
                ImgUtil.write(tag, FileUtil.file(descDir, "_r" + i2 + "_c" + j + ".jpg"));
            }
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        ImgUtil.sliceByRowsAndCols(srcImageFile, destDir, IMAGE_TYPE_JPEG, rows, cols);
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, String format, int rows, int cols) {
        try {
            ImgUtil.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, format, rows, cols);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        ImgUtil.sliceByRowsAndCols(srcImage, destDir, IMAGE_TYPE_JPEG, rows, cols);
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, String format, int rows, int cols) {
        if (!destDir.exists()) {
            FileUtil.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImgUtil.toBufferedImage(srcImage);
            int srcWidth = bi.getWidth();
            int srcHeight = bi.getHeight();
            int destWidth = NumberUtil.partValue(srcWidth, cols);
            int destHeight = NumberUtil.partValue(srcHeight, rows);
            for (int i2 = 0; i2 < rows; ++i2) {
                for (int j = 0; j < cols; ++j) {
                    Image tag = ImgUtil.cut(bi, new Rectangle(j * destWidth, i2 * destHeight, destWidth, destHeight));
                    ImageIO.write(ImgUtil.toRenderedImage(tag), format, new File(destDir, "_r" + i2 + "_c" + j + "." + format));
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileUtil.extName(srcImageFile);
        String destExtName = FileUtil.extName(destImageFile);
        if (StrUtil.equalsIgnoreCase(srcExtName, destExtName)) {
            FileUtil.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImgUtil.getImageOutputStream(destImageFile);
            ImgUtil.convert(ImgUtil.read(srcImageFile), destExtName, imageOutputStream, StrUtil.equalsIgnoreCase(IMAGE_TYPE_PNG, srcExtName));
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImgUtil.write((Image)ImgUtil.read(srcStream), formatName, ImgUtil.getImageOutputStream(destStream));
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImgUtil.copyImage(srcImage, 1) : ImgUtil.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void gray(File srcImageFile, File destImageFile) {
        ImgUtil.gray((Image)ImgUtil.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        ImgUtil.gray((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImgUtil.gray((Image)ImgUtil.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) {
        ImgUtil.write(ImgUtil.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImgUtil.gray(srcImage, ImgUtil.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return Img.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        ImgUtil.binary(ImgUtil.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        ImgUtil.binary((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        ImgUtil.binary((Image)ImgUtil.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) {
        ImgUtil.write(ImgUtil.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImgUtil.binary(srcImage, ImgUtil.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws IORuntimeException {
        ImgUtil.write(ImgUtil.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return Img.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText((Image)ImgUtil.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText((Image)ImgUtil.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.write(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.pressText(srcImage, ImgUtil.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return Img.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        ImgUtil.pressImage((Image)ImgUtil.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        ImgUtil.pressImage((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), pressImg, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.pressImage((Image)ImgUtil.read(srcStream), destStream, pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.write(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.pressImage(srcImage, ImgUtil.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImg, Rectangle rectangle2, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, rectangle2, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws IORuntimeException {
        ImgUtil.rotate((Image)ImgUtil.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws IORuntimeException {
        ImgUtil.write(ImgUtil.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.rotate(image, degree), ImgUtil.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return Img.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws IORuntimeException {
        ImgUtil.flip((Image)ImgUtil.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws IORuntimeException {
        ImgUtil.write(ImgUtil.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws IORuntimeException {
        ImgUtil.flip(image, ImgUtil.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.flip(image), out);
    }

    public static Image flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws IORuntimeException {
        Img.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image img2) {
        if (img2 instanceof RenderedImage) {
            return (RenderedImage)((Object)img2);
        }
        return ImgUtil.copyImage(img2, 1);
    }

    public static BufferedImage toBufferedImage(Image img2) {
        if (img2 instanceof BufferedImage) {
            return (BufferedImage)img2;
        }
        return ImgUtil.copyImage(img2, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        return ImgUtil.toBufferedImage(image, imageType, null);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType, Color backgroundColor) {
        int type2 = IMAGE_TYPE_PNG.equalsIgnoreCase(imageType) ? 2 : 1;
        return ImgUtil.toBufferedImage(image, type2, backgroundColor);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image, imageType);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image, int imageType, Color backgroundColor) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImgUtil.copyImage(image, imageType, backgroundColor);
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img2, int imageType) {
        return ImgUtil.copyImage(img2, imageType, null);
    }

    public static BufferedImage copyImage(Image img2, int imageType, Color backgroundColor) {
        img2 = new ImageIcon(img2).getImage();
        BufferedImage bimage = new BufferedImage(img2.getWidth(null), img2.getHeight(null), imageType);
        Graphics2D bGr = GraphicsUtil.createGraphics(bimage, backgroundColor);
        bGr.drawImage(img2, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) throws HeadlessException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage toImage(String base64) throws IORuntimeException {
        return ImgUtil.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IORuntimeException {
        return ImgUtil.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) {
        return IoUtil.toStream(ImgUtil.toBytes(image, imageType));
    }

    public static String toBase64DataUri(Image image, String imageType) {
        return URLUtil.getDataUri("image/" + imageType, "base64", ImgUtil.toBase64(image, imageType));
    }

    public static String toBase64(Image image, String imageType) {
        return Base64.encode(ImgUtil.toBytes(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImgUtil.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        ImgUtil.writePng((Image)ImgUtil.createImage(str, font, backgroundColor, fontColor, 2), out);
    }

    public static void createTransparentImage(String str, Font font, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        ImgUtil.writePng((Image)ImgUtil.createImage(str, font, null, fontColor, 2), out);
    }

    public static BufferedImage createImage(String str, Font font, Color backgroundColor, Color fontColor, int imageType) throws IORuntimeException {
        Rectangle2D r = ImgUtil.getRectangle(str, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(ObjectUtil.defaultIfNull(fontColor, Color.BLACK));
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        return font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File fontFile) {
        return FontUtil.createFont(fontFile);
    }

    public static Font createFont(InputStream fontStream) {
        return FontUtil.createFont(fontStream);
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return GraphicsUtil.createGraphics(image, color);
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_JPG, destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(Image image, OutputStream out) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        ImgUtil.write((Image)ImgUtil.read(srcStream), formatName, destStream);
    }

    public static void write(Image image, String imageType, OutputStream out) throws IORuntimeException {
        ImgUtil.write(image, imageType, ImgUtil.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws IORuntimeException {
        return ImgUtil.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws IORuntimeException {
        return ImgUtil.write(image, imageType, destImageStream, quality, null);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality, Color backgroundColor) throws IORuntimeException {
        if (StrUtil.isBlank(imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        BufferedImage bufferedImage = ImgUtil.toBufferedImage(image, imageType, backgroundColor);
        ImageWriter writer = ImgUtil.getWriter(bufferedImage, imageType);
        return ImgUtil.write((Image)bufferedImage, writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) throws IORuntimeException {
        FileUtil.touch(targetFile);
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            ImgUtil.write(image, FileUtil.extName(targetFile), out);
        }
        finally {
            IoUtil.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImgUtil.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type2) {
        Iterator<ImageReader> iterator2 = ImageIO.getImageReadersByFormatName(type2);
        if (iterator2.hasNext()) {
            return iterator2.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImgUtil.read(FileUtil.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        BufferedImage result2;
        try {
            result2 = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result2;
    }

    public static Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static BufferedImage read(Resource resource2) {
        return ImgUtil.read(resource2.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        BufferedImage result2;
        try {
            result2 = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result2;
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        BufferedImage result2;
        try {
            result2 = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result2;
    }

    public static BufferedImage read(URL imageUrl) {
        BufferedImage result2;
        try {
            result2 = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type of [" + imageUrl + "] is not supported!");
        }
        return result2;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws IORuntimeException {
        ImageOutputStream result2;
        try {
            result2 = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result2;
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws IORuntimeException {
        ImageOutputStream result2;
        try {
            result2 = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result2;
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws IORuntimeException {
        ImageOutputStream result2;
        try {
            result2 = ImageIO.createImageOutputStream(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == result2) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result2;
    }

    public static ImageWriter getWriter(Image img2, String formatName) {
        ImageTypeSpecifier type2 = ImageTypeSpecifier.createFromRenderedImage(ImgUtil.toBufferedImage(img2, formatName));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type2, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        return ColorUtil.toHex(color);
    }

    public static String toHex(int r, int g, int b) {
        return ColorUtil.toHex(r, g, b);
    }

    public static Color hexToColor(String hex2) {
        return ColorUtil.hexToColor(hex2);
    }

    public static Color getColor(int rgb) {
        return ColorUtil.getColor(rgb);
    }

    public static Color getColor(String colorName) {
        return ColorUtil.getColor(colorName);
    }

    public static Color randomColor() {
        return ColorUtil.randomColor();
    }

    public static Color randomColor(Random random) {
        return ColorUtil.randomColor(random);
    }

    public static Point getPointBaseCentre(Rectangle rectangle2, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle2.x + Math.abs(backgroundWidth - rectangle2.width) / 2, rectangle2.y + Math.abs(backgroundHeight - rectangle2.height) / 2);
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        return ColorUtil.getMainColor(image, rgbFilters);
    }

    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(inputPath, outputPath, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(input, output, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(input, output, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(bufferedImage, override, tolerance);
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream2, Color override, int tolerance) {
        return BackgroundRemoval.backgroundRemoval(outputStream2, override, tolerance);
    }

    public static BufferedImage colorConvert(ColorSpace colorSpace, BufferedImage image) {
        return ImgUtil.filter(new ColorConvertOp(colorSpace, null), image);
    }

    public static BufferedImage transform(AffineTransform xform, BufferedImage image) {
        return ImgUtil.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(ImageFilter filter2, Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter2));
    }
}

