/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img.gif;

public class NeuQuant {
    protected static final int NETSIZE = 256;
    protected static final int PRIME1 = 499;
    protected static final int PRIME2 = 491;
    protected static final int PRIME3 = 487;
    protected static final int PRIME4 = 503;
    protected static final int MINPICTUREBYTES = 1509;
    protected static final int MAXNETPOS = 255;
    protected static final int NETBIASSHIFT = 4;
    protected static final int NCYCLES = 100;
    protected static final int INTBIASSHIFT = 16;
    protected static final int INTBIAS = 65536;
    protected static final int GAMMASHIFT = 10;
    protected static final int GAMMA = 1024;
    protected static final int BETASHIFT = 10;
    protected static final int BETA = 64;
    protected static final int BETAGAMMA = 65536;
    protected static final int INITRAD = 32;
    protected static final int RADIUSBIASSHIFT = 6;
    protected static final int RADIUSBIAS = 64;
    protected static final int INITRADIUS = 2048;
    protected static final int RADIUSDEC = 30;
    protected static final int ALPHABIASSHIFT = 10;
    protected static final int INITALPHA = 1024;
    protected int alphadec;
    protected static final int RADBIASSHIFT = 8;
    protected static final int RADBIAS = 256;
    protected static final int ALPHARADBSHIFT = 18;
    protected static final int ALPHARADBIAS = 262144;
    protected byte[] thepicture;
    protected int lengthcount;
    protected int samplefac;
    protected int[][] network;
    protected int[] netindex = new int[256];
    protected int[] bias = new int[256];
    protected int[] freq = new int[256];
    protected int[] radpower = new int[32];

    public NeuQuant(byte[] thepic, int len, int sample) {
        this.thepicture = thepic;
        this.lengthcount = len;
        this.samplefac = sample;
        this.network = new int[256][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.network[i2] = new int[4];
            int[] p = this.network[i2];
            p[1] = p[2] = (i2 << 12) / 256;
            p[0] = p[2];
            this.freq[i2] = 256;
            this.bias[i2] = 0;
        }
    }

    public byte[] colorMap() {
        byte[] map2 = new byte[768];
        int[] index = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            index[this.network[i2][3]] = i2;
        }
        int k = 0;
        for (int i3 = 0; i3 < 256; ++i3) {
            int j = index[i3];
            map2[k++] = (byte)this.network[j][0];
            map2[k++] = (byte)this.network[j][1];
            map2[k++] = (byte)this.network[j][2];
        }
        return map2;
    }

    public void inxbuild() {
        int j;
        int previouscol = 0;
        int startpos = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            int[] q;
            int[] p = this.network[i2];
            int smallpos = i2;
            int smallval = p[1];
            for (j = i2 + 1; j < 256; ++j) {
                q = this.network[j];
                if (q[1] >= smallval) continue;
                smallpos = j;
                smallval = q[1];
            }
            q = this.network[smallpos];
            if (i2 != smallpos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval == previouscol) continue;
            this.netindex[previouscol] = startpos + i2 >> 1;
            for (j = previouscol + 1; j < smallval; ++j) {
                this.netindex[j] = i2;
            }
            previouscol = smallval;
            startpos = i2;
        }
        this.netindex[previouscol] = startpos + 255 >> 1;
        for (j = previouscol + 1; j < 256; ++j) {
            this.netindex[j] = 255;
        }
    }

    public void learn() {
        int i2;
        if (this.lengthcount < 1509) {
            this.samplefac = 1;
        }
        this.alphadec = 30 + (this.samplefac - 1) / 3;
        byte[] p = this.thepicture;
        int pix = 0;
        int lim = this.lengthcount;
        int samplepixels = this.lengthcount / (3 * this.samplefac);
        int delta = samplepixels / 100;
        int alpha = 1024;
        int radius = 2048;
        int rad = radius >> 6;
        for (i2 = 0; i2 < rad; ++i2) {
            this.radpower[i2] = alpha * ((rad * rad - i2 * i2) * 256 / (rad * rad));
        }
        int step = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
        i2 = 0;
        while (i2 < samplepixels) {
            int b = (p[pix] & 0xFF) << 4;
            int g = (p[pix + 1] & 0xFF) << 4;
            int r = (p[pix + 2] & 0xFF) << 4;
            int j = this.contest(b, g, r);
            this.altersingle(alpha, j, b, g, r);
            if (rad != 0) {
                this.alterneigh(rad, j, b, g, r);
            }
            if ((pix += step) >= lim) {
                pix -= this.lengthcount;
            }
            ++i2;
            if (delta == 0) {
                delta = 1;
            }
            if (i2 % delta != 0) continue;
            alpha -= alpha / this.alphadec;
            if ((rad = (radius -= radius / 30) >> 6) <= 1) {
                rad = 0;
            }
            for (j = 0; j < rad; ++j) {
                this.radpower[j] = alpha * ((rad * rad - j * j) * 256 / (rad * rad));
            }
        }
    }

    public int map(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        int i2 = this.netindex[g];
        int j = i2 - 1;
        while (i2 < 256 || j >= 0) {
            int a;
            int dist;
            int[] p;
            if (i2 < 256) {
                p = this.network[i2];
                dist = p[1] - g;
                if (dist >= bestd) {
                    i2 = 256;
                } else {
                    ++i2;
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestd) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            bestd = dist;
                            best = p[3];
                        }
                    }
                }
            }
            if (j < 0) continue;
            p = this.network[j];
            dist = g - p[1];
            if (dist >= bestd) {
                j = -1;
                continue;
            }
            --j;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            if ((dist += a) >= bestd) continue;
            a = p[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) >= bestd) continue;
            bestd = dist;
            best = p[3];
        }
        return best;
    }

    public byte[] process() {
        this.learn();
        this.unbiasnet();
        this.inxbuild();
        return this.colorMap();
    }

    public void unbiasnet() {
        for (int i2 = 0; i2 < 256; ++i2) {
            int[] nArray = this.network[i2];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[i2];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[i2];
            nArray3[2] = nArray3[2] >> 4;
            this.network[i2][3] = i2;
        }
    }

    protected void alterneigh(int rad, int i2, int b, int g, int r) {
        int hi;
        int lo = i2 - rad;
        if (lo < -1) {
            lo = -1;
        }
        if ((hi = i2 + rad) > 256) {
            hi = 256;
        }
        int j = i2 + 1;
        int k = i2 - 1;
        int m = 1;
        while (j < hi || k > lo) {
            int[] p;
            int a = this.radpower[m++];
            if (j < hi) {
                p = this.network[j++];
                try {
                    p[0] = p[0] - a * (p[0] - b) / 262144;
                    p[1] = p[1] - a * (p[1] - g) / 262144;
                    p[2] = p[2] - a * (p[2] - r) / 262144;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (k <= lo) continue;
            p = this.network[k--];
            try {
                p[0] = p[0] - a * (p[0] - b) / 262144;
                p[1] = p[1] - a * (p[1] - g) / 262144;
                p[2] = p[2] - a * (p[2] - r) / 262144;
            }
            catch (Exception exception) {}
        }
    }

    protected void altersingle(int alpha, int i2, int b, int g, int r) {
        int[] n = this.network[i2];
        n[0] = n[0] - alpha * (n[0] - b) / 1024;
        n[1] = n[1] - alpha * (n[1] - g) / 1024;
        n[2] = n[2] - alpha * (n[2] - r) / 1024;
    }

    protected int contest(int b, int g, int r) {
        int bestpos;
        int bestd;
        int bestbiasd = bestd = Integer.MAX_VALUE;
        int bestbiaspos = bestpos = -1;
        int i2 = 0;
        while (i2 < 256) {
            int biasdist;
            int a;
            int[] n = this.network[i2];
            int dist = n[0] - b;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i2;
            }
            if ((biasdist = dist - (this.bias[i2] >> 12)) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i2;
            }
            int betafreq = this.freq[i2] >> 10;
            int n2 = i2;
            this.freq[n2] = this.freq[n2] - betafreq;
            int n3 = i2++;
            this.bias[n3] = this.bias[n3] + (betafreq << 10);
        }
        int n = bestpos;
        this.freq[n] = this.freq[n] + 64;
        int n4 = bestpos;
        this.bias[n4] = this.bias[n4] - 65536;
        return bestbiaspos;
    }
}

