/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.net.URL;

public class ClassPathResource
extends UrlResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathResource(String path2) {
        this(path2, null, null);
    }

    public ClassPathResource(String path2, ClassLoader classLoader) {
        this(path2, classLoader, null);
    }

    public ClassPathResource(String path2, Class<?> clazz) {
        this(path2, null, clazz);
    }

    public ClassPathResource(String pathBaseClassLoader, ClassLoader classLoader, Class<?> clazz) {
        super((URL)null);
        String path2;
        Assert.notNull(pathBaseClassLoader, "Path must not be null", new Object[0]);
        this.path = path2 = this.normalizePath(pathBaseClassLoader);
        this.name = StrUtil.isBlank(path2) ? null : FileUtil.getName(path2);
        this.classLoader = ObjectUtil.defaultIfNull(classLoader, ClassUtil::getClassLoader);
        this.clazz = clazz;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final String getAbsolutePath() {
        if (FileUtil.isAbsolutePath(this.path)) {
            return this.path;
        }
        return FileUtil.normalize(URLUtil.getDecodedPath(this.url));
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new NoResourceException("Resource of path [{}] not exist!", this.path);
        }
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : "classpath:" + this.path;
    }

    private String normalizePath(String path2) {
        path2 = FileUtil.normalize(path2);
        path2 = StrUtil.removePrefix(path2, "/");
        Assert.isFalse(FileUtil.isAbsolutePath(path2), "Path [{}] must be a relative path !", path2);
        return path2;
    }
}

