/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtil {
    public static String readUtf8Str(String resource2) {
        return ResourceUtil.getResourceObj(resource2).readUtf8Str();
    }

    public static String readStr(String resource2, Charset charset) {
        return ResourceUtil.getResourceObj(resource2).readStr(charset);
    }

    public static byte[] readBytes(String resource2) {
        return ResourceUtil.getResourceObj(resource2).readBytes();
    }

    public static InputStream getStream(String resource2) throws NoResourceException {
        return ResourceUtil.getResourceObj(resource2).getStream();
    }

    public static InputStream getStreamSafe(String resource2) {
        try {
            return ResourceUtil.getResourceObj(resource2).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    public static BufferedReader getUtf8Reader(String resource2) {
        return ResourceUtil.getReader(resource2, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(String resource2, Charset charset) {
        return ResourceUtil.getResourceObj(resource2).getReader(charset);
    }

    public static URL getResource(String resource2) throws IORuntimeException {
        return ResourceUtil.getResource(resource2, null);
    }

    public static List<URL> getResources(String resource2) {
        return ResourceUtil.getResources(resource2, null);
    }

    public static List<URL> getResources(String resource2, Filter<URL> filter2) {
        return IterUtil.filterToList(ResourceUtil.getResourceIter(resource2), filter2);
    }

    public static EnumerationIter<URL> getResourceIter(String resource2) {
        return ResourceUtil.getResourceIter(resource2, null);
    }

    public static EnumerationIter<URL> getResourceIter(String resource2, ClassLoader classLoader) {
        Enumeration<URL> resources2;
        try {
            resources2 = ObjUtil.defaultIfNull(classLoader, ClassLoaderUtil::getClassLoader).getResources(resource2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new EnumerationIter<URL>(resources2);
    }

    public static URL getResource(String resource2, Class<?> baseClass) {
        resource2 = StrUtil.nullToEmpty(resource2);
        return null != baseClass ? baseClass.getResource(resource2) : ClassLoaderUtil.getClassLoader().getResource(resource2);
    }

    public static Resource getResourceObj(String path2) {
        if (StrUtil.isNotBlank(path2) && (path2.startsWith("file:") || FileUtil.isAbsolutePath(path2))) {
            return new FileResource(path2);
        }
        return new ClassPathResource(path2);
    }
}

