/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.hash.Hash32;
import cn.hutool.core.util.HashUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Hash32<Object> hashFunc;
    private final int numberOfReplicas;
    private final SortedMap<Integer, T> circle = new TreeMap<Integer, T>();

    public ConsistentHash(int numberOfReplicas, Collection<T> nodes) {
        this.numberOfReplicas = numberOfReplicas;
        this.hashFunc = key2 -> HashUtil.fnvHash(key2.toString());
        for (T node2 : nodes) {
            this.add(node2);
        }
    }

    public ConsistentHash(Hash32<Object> hashFunc, int numberOfReplicas, Collection<T> nodes) {
        this.numberOfReplicas = numberOfReplicas;
        this.hashFunc = hashFunc;
        for (T node2 : nodes) {
            this.add(node2);
        }
    }

    public void add(T node2) {
        for (int i2 = 0; i2 < this.numberOfReplicas; ++i2) {
            this.circle.put(this.hashFunc.hash32(node2.toString() + i2), node2);
        }
    }

    public void remove(T node2) {
        for (int i2 = 0; i2 < this.numberOfReplicas; ++i2) {
            this.circle.remove(this.hashFunc.hash32(node2.toString() + i2));
        }
    }

    public T get(Object key2) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.hashFunc.hash32(key2);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Integer, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (T)this.circle.get(hash);
    }
}

