/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConsoleTable {
    private static final char ROW_LINE = '\uff0d';
    private static final char COLUMN_LINE = '|';
    private static final char CORNER = '+';
    private static final char SPACE = '\u3000';
    private static final char LF = '\n';
    private boolean isSBCMode = true;
    private final List<List<String>> headerList = new ArrayList<List<String>>();
    private final List<List<String>> bodyList = new ArrayList<List<String>>();
    private List<Integer> columnCharNumber;

    public static ConsoleTable create() {
        return new ConsoleTable();
    }

    public ConsoleTable setSBCMode(boolean isSBCMode) {
        this.isSBCMode = isSBCMode;
        return this;
    }

    public ConsoleTable addHeader(String ... titles) {
        if (this.columnCharNumber == null) {
            this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
        }
        ArrayList<String> l = new ArrayList<String>();
        this.fillColumns(l, titles);
        this.headerList.add(l);
        return this;
    }

    public ConsoleTable addBody(String ... values2) {
        ArrayList<String> l = new ArrayList<String>();
        this.bodyList.add(l);
        this.fillColumns(l, values2);
        return this;
    }

    private void fillColumns(List<String> l, String[] columns) {
        for (int i2 = 0; i2 < columns.length; ++i2) {
            String column2 = columns[i2];
            if (this.isSBCMode) {
                column2 = Convert.toSBC(column2);
            }
            l.add(column2);
            int width = column2.length();
            if (width <= this.columnCharNumber.get(i2)) continue;
            this.columnCharNumber.set(i2, width);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.fillBorder(sb);
        this.fillRows(sb, this.headerList);
        this.fillBorder(sb);
        this.fillRows(sb, this.bodyList);
        this.fillBorder(sb);
        return sb.toString();
    }

    private void fillRows(StringBuilder sb, List<List<String>> list2) {
        for (List<String> row2 : list2) {
            sb.append('|');
            this.fillRow(sb, row2);
            sb.append('\n');
        }
    }

    private void fillRow(StringBuilder sb, List<String> row2) {
        int size = row2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String value = row2.get(i2);
            sb.append('\u3000');
            sb.append(value);
            int length = value.length();
            int sbcCount = this.sbcCount(value);
            if (sbcCount % 2 == 1) {
                sb.append(' ');
            }
            sb.append('\u3000');
            int maxLength = this.columnCharNumber.get(i2);
            for (int j = 0; j < maxLength - length + sbcCount / 2; ++j) {
                sb.append('\u3000');
            }
            sb.append('|');
        }
    }

    private void fillBorder(StringBuilder sb) {
        sb.append('+');
        for (Integer width : this.columnCharNumber) {
            sb.append(StrUtil.repeat('\uff0d', width + 2));
            sb.append('+');
        }
        sb.append('\n');
    }

    public void print() {
        Console.print(this.toString());
    }

    private int sbcCount(String value) {
        int count = 0;
        for (int i2 = 0; i2 < value.length(); ++i2) {
            if (value.charAt(i2) >= '\u007f') continue;
            ++count;
        }
        return count;
    }
}

