/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.BasicTypeGetter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.func.LambdaUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Dict
extends LinkedHashMap<String, Object>
implements BasicTypeGetter<String> {
    private static final long serialVersionUID = 6135423866861206530L;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private boolean caseInsensitive;

    public static Dict create() {
        return new Dict();
    }

    public static <T> Dict parse(T bean) {
        return Dict.create().parseBean(bean);
    }

    @SafeVarargs
    public static Dict of(Pair<String, Object> ... pairs) {
        Dict dict = Dict.create();
        for (Pair<String, Object> pair : pairs) {
            dict.put(pair.getKey(), pair.getValue());
        }
        return dict;
    }

    public static Dict of(Object ... keysAndValues) {
        Dict dict = Dict.create();
        String key2 = null;
        for (int i2 = 0; i2 < keysAndValues.length; ++i2) {
            if (i2 % 2 == 0) {
                key2 = Convert.toStr(keysAndValues[i2]);
                continue;
            }
            dict.put(key2, keysAndValues[i2]);
        }
        return dict;
    }

    public Dict() {
        this(false);
    }

    public Dict(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dict(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dict(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dict(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dict(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(initialCapacity, loadFactor);
        this.caseInsensitive = caseInsensitive;
    }

    public Dict(Map<String, Object> m) {
        super(null == m ? new HashMap() : m);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanUtil.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanUtil.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanUtil.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.toBean(this, clazz);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanUtil.toBeanIgnoreCase(this, clazz, false);
    }

    public <T> Dict parseBean(T bean) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanUtil.beanToMap(bean, new String[0]));
        return this;
    }

    public <T> Dict parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanUtil.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dict> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollUtil.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || !Objects.equals(value = this.get(entry.getKey()), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict filter(String ... keys2) {
        Dict result2 = new Dict(keys2.length, 1.0f);
        for (String key2 : keys2) {
            if (!this.containsKey(key2)) continue;
            result2.put(key2, this.get(key2));
        }
        return result2;
    }

    public Dict set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dict setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObj(String key2) {
        return super.get(key2);
    }

    public <T> T getBean(String attr) {
        return this.get(attr, null);
    }

    public <T> T get(String attr, T defaultValue) {
        Object result2 = this.get(attr);
        return (T)(result2 != null ? result2 : defaultValue);
    }

    @Override
    public String getStr(String attr) {
        return Convert.toStr(this.get(attr), null);
    }

    @Override
    public Integer getInt(String attr) {
        return Convert.toInt(this.get(attr), null);
    }

    @Override
    public Long getLong(String attr) {
        return Convert.toLong(this.get(attr), null);
    }

    @Override
    public Float getFloat(String attr) {
        return Convert.toFloat(this.get(attr), null);
    }

    @Override
    public Short getShort(String attr) {
        return Convert.toShort(this.get(attr), null);
    }

    @Override
    public Character getChar(String attr) {
        return Convert.toChar(this.get(attr), null);
    }

    @Override
    public Double getDouble(String attr) {
        return Convert.toDouble(this.get(attr), null);
    }

    @Override
    public Byte getByte(String attr) {
        return Convert.toByte(this.get(attr), null);
    }

    @Override
    public Boolean getBool(String attr) {
        return Convert.toBool(this.get(attr), null);
    }

    @Override
    public BigDecimal getBigDecimal(String attr) {
        return Convert.toBigDecimal(this.get(attr));
    }

    @Override
    public BigInteger getBigInteger(String attr) {
        return Convert.toBigInteger(this.get(attr));
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key2) {
        return Convert.toEnum(clazz, this.get(key2));
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    public <T> T getByPath(String expression) {
        return (T)BeanPath.create(expression).get(this);
    }

    public <T> T getByPath(String expression, Class<T> resultType) {
        return Convert.convert(resultType, this.getByPath(expression));
    }

    @Override
    public boolean containsKey(Object key2) {
        return super.containsKey(this.customKey((String)key2));
    }

    @Override
    public Object get(Object key2) {
        return super.get(this.customKey((String)key2));
    }

    @Override
    public Object put(String key2, Object value) {
        return super.put(this.customKey(key2), value);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public Dict clone() {
        return (Dict)super.clone();
    }

    @Override
    public Object remove(Object key2) {
        return super.remove(this.customKey((String)key2));
    }

    @Override
    public boolean remove(Object key2, Object value) {
        return super.remove(this.customKey((String)key2), value);
    }

    @Override
    public boolean replace(String key2, Object oldValue, Object newValue) {
        return super.replace(this.customKey(key2), oldValue, newValue);
    }

    @Override
    public Object replace(String key2, Object value) {
        return super.replace(this.customKey(key2), value);
    }

    @Override
    public Object getOrDefault(Object key2, Object defaultValue) {
        return super.getOrDefault(this.customKey((String)key2), defaultValue);
    }

    @Override
    public Object computeIfPresent(String key2, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return super.computeIfPresent(this.customKey(key2), remappingFunction);
    }

    @Override
    public Object compute(String key2, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return super.compute(this.customKey(key2), remappingFunction);
    }

    @Override
    public Object merge(String key2, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return super.merge(this.customKey(key2), value, remappingFunction);
    }

    @Override
    public Object putIfAbsent(String key2, Object value) {
        return super.putIfAbsent(this.customKey(key2), value);
    }

    @Override
    public Object computeIfAbsent(String key2, Function<? super String, ?> mappingFunction) {
        return super.computeIfAbsent(this.customKey(key2), mappingFunction);
    }

    private String customKey(String key2) {
        if (this.caseInsensitive && null != key2) {
            key2 = key2.toLowerCase();
        }
        return key2;
    }

    public Dict setFields(Func0<?> ... fields2) {
        Arrays.stream(fields2).forEach((? super T f) -> this.set(LambdaUtil.getFieldName(f), f.callWithRuntimeException()));
        return this;
    }
}

