/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.caller;

import cn.hutool.core.lang.caller.Caller;
import cn.hutool.core.lang.caller.SecurityManagerCaller;
import cn.hutool.core.lang.caller.StackTraceCaller;

public class CallerUtil {
    private static final Caller INSTANCE = CallerUtil.tryCreateCaller();

    public static Class<?> getCaller() {
        return INSTANCE.getCaller();
    }

    public static Class<?> getCallerCaller() {
        return INSTANCE.getCallerCaller();
    }

    public static Class<?> getCaller(int depth) {
        return INSTANCE.getCaller(depth);
    }

    public static boolean isCalledBy(Class<?> clazz) {
        return INSTANCE.isCalledBy(clazz);
    }

    public static String getCallerMethodName(boolean isFullName) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String methodName = stackTraceElement.getMethodName();
        if (!isFullName) {
            return methodName;
        }
        return stackTraceElement.getClassName() + "." + methodName;
    }

    private static Caller tryCreateCaller() {
        Caller caller2;
        try {
            caller2 = new SecurityManagerCaller();
            if (null != caller2.getCaller() && null != caller2.getCallerCaller()) {
                return caller2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        caller2 = new StackTraceCaller();
        return caller2;
    }
}

