/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.reflect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class ActualTypeMapperPool {
    private static final WeakConcurrentMap<Type, Map<Type, Type>> CACHE = new WeakConcurrentMap();

    public static Map<Type, Type> get(Type type2) {
        return CACHE.computeIfAbsent(type2, key2 -> ActualTypeMapperPool.createTypeMap(type2));
    }

    public static Map<String, Type> getStrKeyMap(Type type2) {
        return Convert.toMap(String.class, Type.class, ActualTypeMapperPool.get(type2));
    }

    public static Type getActualType(Type type2, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = ActualTypeMapperPool.get(type2);
        Type result2 = typeTypeMap.get(typeVariable);
        while (result2 instanceof TypeVariable) {
            result2 = typeTypeMap.get(result2);
        }
        return result2;
    }

    public static Type[] getActualTypes(Type type2, Type ... typeVariables) {
        Type[] result2 = new Type[typeVariables.length];
        for (int i2 = 0; i2 < typeVariables.length; ++i2) {
            result2[i2] = typeVariables[i2] instanceof TypeVariable ? ActualTypeMapperPool.getActualType(type2, (TypeVariable)typeVariables[i2]) : typeVariables[i2];
        }
        return result2;
    }

    private static Map<Type, Type> createTypeMap(Type type2) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type2 && null != (parameterizedType = TypeUtil.toParameterizedType(type2))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters2 = rawType.getTypeParameters();
            for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                Type value = typeArguments[i2];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters2[i2], value);
            }
            type2 = rawType;
        }
        return typeMap;
    }
}

