/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.reflect;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.reflect.LookupFactory;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public class MethodHandleUtil {
    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return LookupFactory.lookup(callerClass);
    }

    public static MethodHandle findMethod(Class<?> callerClass, String name, MethodType type2) {
        if (StrUtil.isBlank(name)) {
            return MethodHandleUtil.findConstructor(callerClass, type2);
        }
        MethodHandle handle = null;
        MethodHandles.Lookup lookup2 = MethodHandleUtil.lookup(callerClass);
        try {
            handle = lookup2.findVirtual(callerClass, name, type2);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (null == handle) {
            try {
                handle = lookup2.findStatic(callerClass, name, type2);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (null == handle) {
            try {
                handle = lookup2.findSpecial(callerClass, name, type2, callerClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new UtilException(e);
            }
        }
        return handle;
    }

    public static MethodHandle findConstructor(Class<?> callerClass, Class<?> ... args) {
        return MethodHandleUtil.findConstructor(callerClass, MethodType.methodType(Void.TYPE, args));
    }

    public static MethodHandle findConstructor(Class<?> callerClass, MethodType type2) {
        MethodHandles.Lookup lookup2 = MethodHandleUtil.lookup(callerClass);
        try {
            return lookup2.findConstructor(callerClass, type2);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invokeSpecial(Object obj, String methodName, Object ... args) {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new UtilException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return MethodHandleUtil.invokeSpecial(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) {
        return MethodHandleUtil.invoke(false, obj, method, args);
    }

    public static <T> T invokeSpecial(Object obj, Method method, Object ... args) {
        return MethodHandleUtil.invoke(true, obj, method, args);
    }

    public static <T> T invoke(boolean isSpecial, Object obj, Method method, Object ... args) {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup2 = MethodHandleUtil.lookup(declaringClass);
        try {
            MethodHandle handle;
            MethodHandle methodHandle = handle = isSpecial ? lookup2.unreflectSpecial(method, declaringClass) : lookup2.unreflect(method);
            if (null != obj) {
                handle = handle.bindTo(obj);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new UtilException(e);
        }
    }
}

