/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeBuilder<E>
implements Builder<Tree<E>> {
    private static final long serialVersionUID = 1L;
    private final Tree<E> root;
    private final Map<E, Tree<E>> idTreeMap;
    private boolean isBuild;

    public static <T> TreeBuilder<T> of(T rootId) {
        return TreeBuilder.of(rootId, null);
    }

    public static <T> TreeBuilder<T> of(T rootId, TreeNodeConfig config2) {
        return new TreeBuilder<T>(rootId, config2);
    }

    public TreeBuilder(E rootId, TreeNodeConfig config2) {
        this.root = new Tree(config2);
        this.root.setId((Object)rootId);
        this.idTreeMap = new LinkedHashMap<E, Tree<E>>();
    }

    public TreeBuilder<E> setId(E id) {
        this.root.setId((Object)id);
        return this;
    }

    public TreeBuilder<E> setParentId(E parentId) {
        this.root.setParentId((Object)parentId);
        return this;
    }

    public TreeBuilder<E> setName(CharSequence name) {
        this.root.setName(name);
        return this;
    }

    public TreeBuilder<E> setWeight(Comparable<?> weight) {
        this.root.setWeight((Comparable)weight);
        return this;
    }

    public TreeBuilder<E> putExtra(String key2, Object value) {
        Assert.notEmpty(key2, "Key must be not empty !", new Object[0]);
        this.root.put(key2, value);
        return this;
    }

    public TreeBuilder<E> append(Map<E, Tree<E>> map2) {
        this.checkBuilt();
        this.idTreeMap.putAll(map2);
        return this;
    }

    public TreeBuilder<E> append(Iterable<Tree<E>> trees) {
        this.checkBuilt();
        for (Tree<E> tree : trees) {
            this.idTreeMap.put(tree.getId(), tree);
        }
        return this;
    }

    public <T> TreeBuilder<E> append(List<T> list2, NodeParser<T, E> nodeParser) {
        return this.append(list2, null, nodeParser);
    }

    public <T> TreeBuilder<E> append(List<T> list2, E rootId, NodeParser<T, E> nodeParser) {
        this.checkBuilt();
        TreeNodeConfig config2 = this.root.getConfig();
        LinkedHashMap map2 = new LinkedHashMap(list2.size(), 1.0f);
        for (T t : list2) {
            Tree node2 = new Tree(config2);
            nodeParser.parse(t, node2);
            if (null != rootId && !rootId.getClass().equals(node2.getId().getClass())) {
                throw new IllegalArgumentException("rootId type is node.getId().getClass()!");
            }
            map2.put(node2.getId(), node2);
        }
        return this.append(map2);
    }

    public TreeBuilder<E> reset() {
        this.idTreeMap.clear();
        this.root.setChildren(null);
        this.isBuild = false;
        return this;
    }

    @Override
    public Tree<E> build() {
        this.checkBuilt();
        this.buildFromMap();
        this.cutTree();
        this.isBuild = true;
        this.idTreeMap.clear();
        return this.root;
    }

    public List<Tree<E>> buildList() {
        if (this.isBuild) {
            return this.root.getChildren();
        }
        return ((Tree)this.build()).getChildren();
    }

    private void buildFromMap() {
        if (MapUtil.isEmpty(this.idTreeMap)) {
            return;
        }
        Map<E, Tree<E>> eTreeMap = MapUtil.sortByValue(this.idTreeMap, false);
        for (Tree<E> node2 : eTreeMap.values()) {
            if (null == node2) continue;
            E parentId = node2.getParentId();
            if (ObjectUtil.equals(this.root.getId(), parentId)) {
                this.root.addChildren(node2);
                continue;
            }
            Tree<E> parentNode = eTreeMap.get(parentId);
            if (null == parentNode) continue;
            parentNode.addChildren(node2);
        }
    }

    private void cutTree() {
        TreeNodeConfig config2 = this.root.getConfig();
        Integer deep = config2.getDeep();
        if (null == deep || deep < 0) {
            return;
        }
        this.cutTree(this.root, 0, deep);
    }

    private void cutTree(Tree<E> tree, int currentDepp, int maxDeep) {
        if (null == tree) {
            return;
        }
        if (currentDepp == maxDeep) {
            tree.setChildren(null);
            return;
        }
        List<Tree<E>> children = tree.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            for (Tree<E> child : children) {
                this.cutTree(child, currentDepp + 1, maxDeep);
            }
        }
    }

    private void checkBuilt() {
        Assert.isFalse(this.isBuild, "Current tree has been built.", new Object[0]);
    }
}

