/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeBuilder;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.DefaultNodeParser;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TreeUtil {
    public static Tree<Integer> buildSingle(List<TreeNode<Integer>> list2) {
        return TreeUtil.buildSingle(list2, Integer.valueOf(0));
    }

    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list2) {
        return TreeUtil.build(list2, Integer.valueOf(0));
    }

    public static <E> Tree<E> buildSingle(List<TreeNode<E>> list2, E parentId) {
        return TreeUtil.buildSingle(list2, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <E> List<Tree<E>> build(List<TreeNode<E>> list2, E parentId) {
        return TreeUtil.build(list2, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> Tree<E> buildSingle(List<T> list2, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list2, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list2, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list2, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list2, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list2, rootId, treeNodeConfig, nodeParser).getChildren();
    }

    public static <T, E> Tree<E> buildSingle(List<T> list2, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, treeNodeConfig).append(list2, rootId, nodeParser).build();
    }

    public static <E> List<Tree<E>> build(Map<E, Tree<E>> map2, E rootId) {
        return TreeUtil.buildSingle(map2, rootId).getChildren();
    }

    public static <E> Tree<E> buildSingle(Map<E, Tree<E>> map2, E rootId) {
        Tree<E> tree = IterUtil.getFirstNoneNull(map2.values());
        if (null != tree) {
            TreeNodeConfig config2 = tree.getConfig();
            return TreeBuilder.of(rootId, config2).append(map2).build();
        }
        return TreeUtil.createEmptyNode(rootId);
    }

    public static <T> Tree<T> getNode(Tree<T> node2, T id) {
        if (ObjectUtil.equal(id, node2.getId())) {
            return node2;
        }
        List<Tree<T>> children = node2.getChildren();
        if (null == children) {
            return null;
        }
        for (Tree<T> child : children) {
            Tree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(Tree<T> node2, boolean includeCurrentNode) {
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        if (null == node2) {
            return result2;
        }
        if (includeCurrentNode) {
            result2.add(node2.getName());
        }
        for (Tree<T> parent = node2.getParent(); null != parent; parent = parent.getParent()) {
            result2.add(parent.getName());
        }
        return result2;
    }

    public static <E> Tree<E> createEmptyNode(E id) {
        return new Tree().setId(id);
    }
}

