/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.MapWrapper;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BiMap<K, V>
extends MapWrapper<K, V> {
    private static final long serialVersionUID = 1L;
    private Map<V, K> inverse;

    public BiMap(Map<K, V> raw) {
        super(raw);
    }

    @Override
    public V put(K key2, V value) {
        if (null != this.inverse) {
            this.inverse.put(value, key2);
        }
        return super.put(key2, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        if (null != this.inverse) {
            m.forEach((? super K key2, ? super V value) -> this.inverse.put(value, key2));
        }
    }

    @Override
    public V remove(Object key2) {
        Object v = super.remove(key2);
        if (null != this.inverse && null != v) {
            this.inverse.remove(v);
        }
        return v;
    }

    @Override
    public boolean remove(Object key2, Object value) {
        return super.remove(key2, value) && null != this.inverse && this.inverse.remove(value, key2);
    }

    @Override
    public void clear() {
        super.clear();
        this.inverse = null;
    }

    public Map<V, K> getInverse() {
        if (null == this.inverse) {
            this.inverse = MapUtil.inverse(this.getRaw());
        }
        return this.inverse;
    }

    public K getKey(V value) {
        return this.getInverse().get(value);
    }

    @Override
    public V putIfAbsent(K key2, V value) {
        if (null != this.inverse) {
            this.inverse.putIfAbsent(value, key2);
        }
        return super.putIfAbsent(key2, value);
    }

    @Override
    public V computeIfAbsent(K key2, Function<? super K, ? extends V> mappingFunction) {
        V result2 = super.computeIfAbsent(key2, mappingFunction);
        this.resetInverseMap();
        return result2;
    }

    @Override
    public V computeIfPresent(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result2 = super.computeIfPresent(key2, remappingFunction);
        this.resetInverseMap();
        return result2;
    }

    @Override
    public V compute(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result2 = super.compute(key2, remappingFunction);
        this.resetInverseMap();
        return result2;
    }

    @Override
    public V merge(K key2, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result2 = super.merge(key2, value, remappingFunction);
        this.resetInverseMap();
        return result2;
    }

    private void resetInverseMap() {
        if (null != this.inverse) {
            this.inverse = null;
        }
    }
}

