/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.CamelCaseLinkedMap;
import cn.hutool.core.map.CamelCaseMap;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapProxy;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map2) {
        return null == map2 || map2.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map2) {
        return null != map2 && false == map2.isEmpty();
    }

    public static <K, V> Map<K, V> emptyIfNull(Map<K, V> set2) {
        return null == set2 ? Collections.emptyMap() : set2;
    }

    public static <T extends Map<K, V>, K, V> T defaultIfEmpty(T map2, T defaultMap) {
        return MapUtil.isEmpty(map2) ? defaultMap : map2;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return MapUtil.newHashMap(16, isLinked);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map2, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtil.isEmpty(map2)) {
            treeMap.putAll(map2);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        int initCapacity = size <= 0 ? 16 : size;
        return new ConcurrentHashMap(initCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map2) {
        if (MapUtil.isEmpty(map2)) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap<K, V>(map2);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (null == mapType || mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            return (Map)ReflectUtil.newInstance(mapType, new Object[0]);
        }
        catch (UtilException e) {
            return new HashMap();
        }
    }

    public static <K, V> HashMap<K, V> of(K key2, V value) {
        return MapUtil.of(key2, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key2, V value, boolean isOrder) {
        HashMap<K, V> map2 = MapUtil.newHashMap(isOrder);
        map2.put(key2, value);
        return map2;
    }

    @SafeVarargs
    @Deprecated
    public static <K, V> Map<K, V> of(Pair<K, V> ... pairs) {
        HashMap<K, V> map2 = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map2.put(pair.getKey(), pair.getValue());
        }
        return map2;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> ofEntries(Map.Entry<K, V> ... entries) {
        HashMap<K, V> map2 = new HashMap<K, V>();
        for (Map.Entry<K, V> pair : entries) {
            map2.put(pair.getKey(), pair.getValue());
        }
        return map2;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i2 = 0; i2 < array.length; ++i2) {
            Object value;
            Object key2;
            Iterator iter;
            Object[] entry;
            Object object = array[i2];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map2.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map2.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key2 = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map2.put(key2, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key2 = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map2.put(key2, value);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format("Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i2, object));
        }
        return map2;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<K, ArrayList<Object>> resultMap = new HashMap<K, ArrayList<Object>>();
        if (CollUtil.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map2 : mapList) {
            Set<Map.Entry<K, V>> entrySet = map2.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key2 = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key2);
                if (null == valueList) {
                    valueList = CollUtil.newArrayList(entry.getValue());
                    resultMap.put(key2, valueList);
                    continue;
                }
                valueList.add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        boolean isEnd;
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapUtil.isEmpty(listMap)) {
            return resultList;
        }
        int index = 0;
        do {
            isEnd = true;
            HashMap map2 = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollUtil.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map2.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map2.isEmpty()) {
                resultList.add(map2);
            }
            ++index;
        } while (!isEnd);
        return resultList;
    }

    public static <K, V> Map<K, List<V>> grouping(Iterable<Map.Entry<K, V>> entries) {
        HashMap<Object, List> map2 = new HashMap<Object, List>();
        if (CollUtil.isEmpty(entries)) {
            return map2;
        }
        for (Map.Entry<K, V> pair : entries) {
            List values2 = map2.computeIfAbsent(pair.getKey(), k -> new ArrayList());
            values2.add(pair.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map2) {
        return map2 instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map2) : new CamelCaseMap<K, V>(map2);
    }

    public static Object[][] toObjectArray(Map<?, ?> map2) {
        if (map2 == null) {
            return null;
        }
        Object[][] result2 = new Object[map2.size()][2];
        if (map2.isEmpty()) {
            return result2;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            result2[index][0] = entry.getKey();
            result2[index][1] = entry.getValue();
            ++index;
        }
        return result2;
    }

    public static <K, V> String join(Map<K, V> map2, String separator2, String keyValueSeparator, String ... otherParams) {
        return MapUtil.join(map2, separator2, keyValueSeparator, false, otherParams);
    }

    public static String sortJoin(Map<?, ?> params, String separator2, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapUtil.join(MapUtil.sort(params), separator2, keyValueSeparator, isIgnoreNull, otherParams);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map2, String separator2, String keyValueSeparator, String ... otherParams) {
        return MapUtil.join(map2, separator2, keyValueSeparator, true, otherParams);
    }

    public static <K, V> String join(Map<K, V> map2, String separator2, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        StringBuilder strBuilder = StrUtil.builder();
        boolean isFirst = true;
        if (MapUtil.isNotEmpty(map2)) {
            for (Map.Entry entry : map2.entrySet()) {
                if (isIgnoreNull && (entry.getKey() == null || entry.getValue() == null)) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    strBuilder.append(separator2);
                }
                strBuilder.append(Convert.toStr(entry.getKey())).append(keyValueSeparator).append(Convert.toStr(entry.getValue()));
            }
        }
        if (ArrayUtil.isNotEmpty(otherParams)) {
            for (String otherParam : otherParams) {
                strBuilder.append(otherParam);
            }
        }
        return strBuilder.toString();
    }

    public static <K, V> Map<K, V> edit(Map<K, V> map2, Editor<Map.Entry<K, V>> editor) {
        if (null == map2 || null == editor) {
            return map2;
        }
        HashMap<K, V> map22 = (HashMap<K, V>)ReflectUtil.newInstanceIfPossible(map2.getClass());
        if (null == map22) {
            map22 = new HashMap<K, V>(map2.size(), 1.0f);
        }
        if (MapUtil.isEmpty(map2)) {
            return map22;
        }
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map22.put(modified.getKey(), modified.getValue());
        }
        return map22;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map2, Filter<Map.Entry<K, V>> filter2) {
        if (null == map2 || null == filter2) {
            return map2;
        }
        return MapUtil.edit(map2, t -> filter2.accept((Map.Entry)t) ? t : null);
    }

    public static <K, V, R> Map<K, R> map(Map<K, V> map2, BiFunction<K, V, R> biFunction) {
        if (null == map2 || null == biFunction) {
            return MapUtil.newHashMap();
        }
        return map2.entrySet().stream().collect(CollectorUtil.toMap(Map.Entry::getKey, m -> biFunction.apply(m.getKey(), m.getValue()), (l, r) -> l));
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map2, K ... keys2) {
        if (null == map2 || null == keys2) {
            return map2;
        }
        HashMap<K, V> map22 = (HashMap<K, V>)ReflectUtil.newInstanceIfPossible(map2.getClass());
        if (null == map22) {
            map22 = new HashMap<K, V>(map2.size(), 1.0f);
        }
        if (MapUtil.isEmpty(map2)) {
            return map22;
        }
        for (K key2 : keys2) {
            if (!map2.containsKey(key2)) continue;
            map22.put(key2, map2.get(key2));
        }
        return map22;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map2) {
        return MapUtil.edit(map2, t -> new Map.Entry<T, T>((Map.Entry)t){
            final /* synthetic */ Map.Entry val$t;
            {
                this.val$t = entry;
            }

            @Override
            public T getKey() {
                return this.val$t.getValue();
            }

            @Override
            public T getValue() {
                return this.val$t.getKey();
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Unsupported setValue method !");
            }
        });
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map2) {
        Map result2 = MapUtil.createMap(map2.getClass());
        map2.forEach((key2, value) -> result2.put(value, key2));
        return result2;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map2) {
        return MapUtil.sort(map2, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map2, Comparator<? super K> comparator) {
        if (null == map2) {
            return null;
        }
        if (map2 instanceof TreeMap) {
            TreeMap result2 = (TreeMap)map2;
            if (null == comparator || comparator.equals(result2.comparator())) {
                return result2;
            }
        }
        return MapUtil.newTreeMap(map2, comparator);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map2, boolean isDesc) {
        LinkedHashMap result2 = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        if (isDesc) {
            entryComparator = entryComparator.reversed();
        }
        map2.entrySet().stream().sorted(entryComparator).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result2.put(e.getKey(), e.getValue());
        });
        return result2;
    }

    public static MapProxy createProxy(Map<?, ?> map2) {
        return MapProxy.create(map2);
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map2) {
        return new MapWrapper<K, V>(map2);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map2) {
        return Collections.unmodifiableMap(map2);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtil.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map2) {
        return new MapBuilder<K, V>(map2);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapUtil.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map2, K ... keys2) {
        return MapUtil.filter(map2, entry -> ArrayUtil.contains(keys2, entry.getKey()));
    }

    public static <K, V> Map<K, V> removeAny(Map<K, V> map2, K ... keys2) {
        for (K key2 : keys2) {
            map2.remove(key2);
        }
        return map2;
    }

    public static String getStr(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, String.class);
    }

    public static String getStr(Map<?, ?> map2, Object key2, String defaultValue) {
        return MapUtil.get(map2, key2, String.class, defaultValue);
    }

    public static Integer getInt(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Integer.class);
    }

    public static Integer getInt(Map<?, ?> map2, Object key2, Integer defaultValue) {
        return MapUtil.get(map2, key2, Integer.class, defaultValue);
    }

    public static Double getDouble(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Double.class);
    }

    public static Double getDouble(Map<?, ?> map2, Object key2, Double defaultValue) {
        return MapUtil.get(map2, key2, Double.class, defaultValue);
    }

    public static Float getFloat(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Float.class);
    }

    public static Float getFloat(Map<?, ?> map2, Object key2, Float defaultValue) {
        return MapUtil.get(map2, key2, Float.class, defaultValue);
    }

    public static Short getShort(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Short.class);
    }

    public static Short getShort(Map<?, ?> map2, Object key2, Short defaultValue) {
        return MapUtil.get(map2, key2, Short.class, defaultValue);
    }

    public static Boolean getBool(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Boolean.class);
    }

    public static Boolean getBool(Map<?, ?> map2, Object key2, Boolean defaultValue) {
        return MapUtil.get(map2, key2, Boolean.class, defaultValue);
    }

    public static Character getChar(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Character.class);
    }

    public static Character getChar(Map<?, ?> map2, Object key2, Character defaultValue) {
        return MapUtil.get(map2, key2, Character.class, defaultValue);
    }

    public static Long getLong(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Long.class);
    }

    public static Long getLong(Map<?, ?> map2, Object key2, Long defaultValue) {
        return MapUtil.get(map2, key2, Long.class, defaultValue);
    }

    public static Date getDate(Map<?, ?> map2, Object key2) {
        return MapUtil.get(map2, key2, Date.class);
    }

    public static Date getDate(Map<?, ?> map2, Object key2, Date defaultValue) {
        return MapUtil.get(map2, key2, Date.class, defaultValue);
    }

    public static <T> T get(Map<?, ?> map2, Object key2, Class<T> type2) {
        return MapUtil.get(map2, key2, type2, null);
    }

    public static <T> T get(Map<?, ?> map2, Object key2, Class<T> type2, T defaultValue) {
        return null == map2 ? defaultValue : Convert.convert(type2, map2.get(key2), defaultValue);
    }

    public static <T> T getQuietly(Map<?, ?> map2, Object key2, Class<T> type2, T defaultValue) {
        return null == map2 ? defaultValue : Convert.convertQuietly(type2, map2.get(key2), defaultValue);
    }

    public static <T> T get(Map<?, ?> map2, Object key2, TypeReference<T> type2) {
        return MapUtil.get(map2, key2, type2, null);
    }

    public static <T> T get(Map<?, ?> map2, Object key2, TypeReference<T> type2, T defaultValue) {
        return null == map2 ? defaultValue : Convert.convert(type2, map2.get(key2), defaultValue);
    }

    public static <T> T getQuietly(Map<?, ?> map2, Object key2, TypeReference<T> type2, T defaultValue) {
        return null == map2 ? defaultValue : Convert.convertQuietly(type2, map2.get(key2), defaultValue);
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map2, K oldKey, K newKey) {
        if (MapUtil.isNotEmpty(map2) && map2.containsKey(oldKey)) {
            if (map2.containsKey(newKey)) {
                throw new IllegalArgumentException(StrUtil.format("The key '{}' exist !", newKey));
            }
            map2.put(newKey, map2.remove(oldKey));
        }
        return map2;
    }

    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map2) {
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        Iterator<Map.Entry<K, V>> iter = map2.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            if (null != entry.getValue()) continue;
            iter.remove();
        }
        return map2;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V, T extends Map<K, V>> T empty(Class<?> mapClass) {
        if (null == mapClass) {
            return (T)Collections.emptyMap();
        }
        if (NavigableMap.class == mapClass) {
            return (T)Collections.emptyNavigableMap();
        }
        if (SortedMap.class == mapClass) {
            return (T)Collections.emptySortedMap();
        }
        if (Map.class == mapClass) {
            return (T)Collections.emptyMap();
        }
        throw new IllegalArgumentException(StrUtil.format("[{}] is not support to get empty!", mapClass));
    }

    public static void clear(Map<?, ?> ... maps) {
        for (Map<?, ?> map2 : maps) {
            if (!MapUtil.isNotEmpty(map2)) continue;
            map2.clear();
        }
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map2, Iterator<K> keys2) {
        ArrayList<V> values2 = new ArrayList<V>();
        while (keys2.hasNext()) {
            values2.add(map2.get(keys2.next()));
        }
        return values2;
    }

    public static <K, V> Map.Entry<K, V> entry(K key2, V value) {
        return MapUtil.entry(key2, value, true);
    }

    public static <K, V> Map.Entry<K, V> entry(K key2, V value, boolean isImmutable) {
        return isImmutable ? new AbstractMap.SimpleImmutableEntry<K, V>(key2, value) : new AbstractMap.SimpleEntry<K, V>(key2, value);
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map2, K key2, Function<? super K, ? extends V> mappingFunction) {
        V value = map2.get(key2);
        if (null == value) {
            map2.putIfAbsent(key2, mappingFunction.apply(key2));
            value = map2.get(key2);
        }
        return value;
    }
}

