/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReferenceUtil;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReferenceConcurrentMap<K, V>
implements ConcurrentMap<K, V>,
Iterable<Map.Entry<K, V>>,
Serializable {
    final ConcurrentMap<Reference<K>, V> raw;
    private final ReferenceQueue<K> lastQueue;
    private final ReferenceUtil.ReferenceType keyType;
    private BiConsumer<Reference<? extends K>, V> purgeListener;

    public ReferenceConcurrentMap(ConcurrentMap<Reference<K>, V> raw, ReferenceUtil.ReferenceType referenceType) {
        this.raw = raw;
        this.keyType = referenceType;
        this.lastQueue = new ReferenceQueue();
    }

    public void setPurgeListener(BiConsumer<Reference<? extends K>, V> purgeListener) {
        this.purgeListener = purgeListener;
    }

    @Override
    public int size() {
        this.purgeStaleKeys();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public V get(Object key2) {
        this.purgeStaleKeys();
        return this.raw.get(this.ofKey(key2, null));
    }

    @Override
    public boolean containsKey(Object key2) {
        this.purgeStaleKeys();
        return this.raw.containsKey(this.ofKey(key2, null));
    }

    @Override
    public boolean containsValue(Object value) {
        this.purgeStaleKeys();
        return this.raw.containsValue(value);
    }

    @Override
    public V put(K key2, V value) {
        this.purgeStaleKeys();
        return this.raw.put(this.ofKey(key2, this.lastQueue), value);
    }

    @Override
    public V putIfAbsent(K key2, V value) {
        this.purgeStaleKeys();
        return this.raw.putIfAbsent(this.ofKey(key2, this.lastQueue), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public V replace(K key2, V value) {
        this.purgeStaleKeys();
        return this.raw.replace(this.ofKey(key2, this.lastQueue), value);
    }

    @Override
    public boolean replace(K key2, V oldValue, V newValue) {
        this.purgeStaleKeys();
        return this.raw.replace(this.ofKey(key2, this.lastQueue), oldValue, newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.purgeStaleKeys();
        this.raw.replaceAll((kWeakKey, value) -> function.apply((Object)kWeakKey.get(), (Object)value));
    }

    @Override
    public V computeIfAbsent(K key2, Function<? super K, ? extends V> mappingFunction) {
        this.purgeStaleKeys();
        return (V)this.raw.computeIfAbsent(this.ofKey(key2, this.lastQueue), (? super K kWeakKey) -> mappingFunction.apply((Object)key2));
    }

    @Override
    public V computeIfPresent(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.purgeStaleKeys();
        return (V)this.raw.computeIfPresent(this.ofKey(key2, this.lastQueue), (kWeakKey, value) -> remappingFunction.apply((Object)key2, (Object)value));
    }

    public V computeIfAbsent(K key2, Func0<? extends V> supplier) {
        return (V)this.computeIfAbsent(key2, (? super K keyParam) -> supplier.callWithRuntimeException());
    }

    @Override
    public V remove(Object key2) {
        this.purgeStaleKeys();
        return this.raw.remove(this.ofKey(key2, null));
    }

    @Override
    public boolean remove(Object key2, Object value) {
        this.purgeStaleKeys();
        return this.raw.remove(this.ofKey(key2, null), value);
    }

    @Override
    public void clear() {
        this.raw.clear();
        while (this.lastQueue.poll() != null) {
        }
    }

    @Override
    public Set<K> keySet() {
        Collection<Object> trans = CollUtil.trans(this.raw.keySet(), reference -> null == reference ? null : reference.get());
        return new HashSet<Object>(trans);
    }

    @Override
    public Collection<V> values() {
        this.purgeStaleKeys();
        return this.raw.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.purgeStaleKeys();
        return this.raw.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(((Reference)entry.getKey()).get(), entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        this.purgeStaleKeys();
        this.raw.forEach((? super K key2, ? super V value) -> action2.accept((Object)key2.get(), (Object)value));
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public V compute(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.purgeStaleKeys();
        return (V)this.raw.compute(this.ofKey(key2, this.lastQueue), (kWeakKey, value) -> remappingFunction.apply((Object)key2, (Object)value));
    }

    @Override
    public V merge(K key2, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.purgeStaleKeys();
        return this.raw.merge((Reference<Reference<K>>)this.ofKey(key2, this.lastQueue), (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    private void purgeStaleKeys() {
        Reference<K> reference;
        while ((reference = this.lastQueue.poll()) != null) {
            Object value = this.raw.remove(reference);
            if (null == this.purgeListener) continue;
            this.purgeListener.accept(reference, value);
        }
    }

    private Reference<K> ofKey(K key2, ReferenceQueue<? super K> queue) {
        switch (this.keyType) {
            case WEAK: {
                return new WeakKey<K>(key2, queue);
            }
            case SOFT: {
                return new SoftKey<K>(key2, queue);
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + (Object)((Object)this.keyType));
    }

    private static class SoftKey<K>
    extends SoftReference<K> {
        private final int hashCode;

        SoftKey(K key2, ReferenceQueue<? super K> queue) {
            super(key2, queue);
            this.hashCode = key2.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof SoftKey) {
                return ObjectUtil.equals(((SoftKey)other).get(), this.get());
            }
            return false;
        }
    }

    private static class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        WeakKey(K key2, ReferenceQueue<? super K> queue) {
            super(key2, queue);
            this.hashCode = key2.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeakKey) {
                return ObjectUtil.equals(((WeakKey)other).get(), this.get());
            }
            return false;
        }
    }
}

