/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map.multi;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.collection.ComputeIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.TransIter;
import cn.hutool.core.map.AbsEntry;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.multi.AbsTable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RowKeyTable<R, C, V>
extends AbsTable<R, C, V> {
    final Map<R, Map<C, V>> raw;
    final Builder<? extends Map<C, V>> columnBuilder;
    private Map<C, Map<R, V>> columnMap;
    private Set<C> columnKeySet;

    public RowKeyTable() {
        this(new HashMap());
    }

    public RowKeyTable(boolean isLinked) {
        this(MapUtil.newHashMap(isLinked), () -> MapUtil.newHashMap(isLinked));
    }

    public RowKeyTable(Map<R, Map<C, V>> raw) {
        this(raw, HashMap::new);
    }

    public RowKeyTable(Map<R, Map<C, V>> raw, Builder<? extends Map<C, V>> columnMapBuilder) {
        this.raw = raw;
        this.columnBuilder = null == columnMapBuilder ? HashMap::new : columnMapBuilder;
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        return this.raw;
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        return this.raw.computeIfAbsent(rowKey, key2 -> this.columnBuilder.build()).put(columnKey, value);
    }

    @Override
    public V remove(R rowKey, C columnKey) {
        Map map2 = this.getRow(rowKey);
        if (null == map2) {
            return null;
        }
        Object value = map2.remove(columnKey);
        if (map2.isEmpty()) {
            this.raw.remove(rowKey);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    @Override
    public boolean containsColumn(C columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map<C, V> map2 : this.raw.values()) {
            if (null == map2 || !map2.containsKey(columnKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap result2 = this.columnMap;
        return result2 == null ? (this.columnMap = new ColumnMap()) : result2;
    }

    @Override
    public Set<C> columnKeySet() {
        ColumnKeySet result2 = this.columnKeySet;
        return result2 == null ? (this.columnKeySet = new ColumnKeySet()) : result2;
    }

    @Override
    public List<C> columnKeys() {
        Collection<Map<C, V>> values2 = this.raw.values();
        ArrayList result2 = new ArrayList(values2.size() * 16);
        for (Map<C, Object> map2 : values2) {
            map2.forEach((? super K key2, ? super V value) -> result2.add(key2));
        }
        return result2;
    }

    @Override
    public Map<R, V> getColumn(C columnKey) {
        return new Column(columnKey);
    }

    private class Column
    extends AbstractMap<R, V> {
        final C columnKey;

        Column(C columnKey) {
            this.columnKey = columnKey;
        }

        @Override
        public Set<Map.Entry<R, V>> entrySet() {
            return new EntrySet();
        }

        private class EntrySetIterator
        extends ComputeIter<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            private EntrySetIterator() {
                this.iterator = RowKeyTable.this.raw.entrySet().iterator();
            }

            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    final Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    return new AbsEntry<R, V>(){

                        @Override
                        public R getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)entry.getValue()).get(Column.this.columnKey);
                        }

                        @Override
                        public V setValue(V value) {
                            return ((Map)entry.getValue()).put(Column.this.columnKey, value);
                        }
                    };
                }
                return null;
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<R, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (Map map2 : RowKeyTable.this.raw.values()) {
                    if (!map2.containsKey(Column.this.columnKey)) continue;
                    ++size;
                }
                return size;
            }
        }
    }

    private class ColumnKeyIterator
    extends ComputeIter<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = RowKeyTable.this.columnBuilder.build();
            this.mapIterator = RowKeyTable.this.raw.values().iterator();
            this.entryIterator = IterUtil.empty();
        }

        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return entry.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return null;
        }
    }

    private class ColumnKeySet
    extends AbstractSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return new ColumnKeyIterator();
        }

        @Override
        public int size() {
            return IterUtil.size(this.iterator());
        }
    }

    private class ColumnMapEntrySet
    extends AbstractSet<Map.Entry<C, Map<R, V>>> {
        private final Set<C> columnKeySet;

        private ColumnMapEntrySet() {
            this.columnKeySet = RowKeyTable.this.columnKeySet();
        }

        @Override
        public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
            return new TransIter<Object, Map.Entry>(this.columnKeySet.iterator(), c -> MapUtil.entry(c, RowKeyTable.this.getColumn(c)));
        }

        @Override
        public int size() {
            return this.columnKeySet.size();
        }
    }

    private class ColumnMap
    extends AbstractMap<C, Map<R, V>> {
        private ColumnMap() {
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> entrySet() {
            return new ColumnMapEntrySet();
        }
    }
}

