/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Combination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] datas;

    public Combination(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n, int m) {
        if (0 == m || n == m) {
            return 1L;
        }
        return n > m ? NumberUtil.factorial(n, n - m) / NumberUtil.factorial(m) : 0L;
    }

    public static long countAll(int n) {
        if (n < 0 || n > 63) {
            throw new IllegalArgumentException(StrUtil.format("countAll must have n >= 0 and n <= 63, but got n={}", n));
        }
        return n == 63 ? Long.MAX_VALUE : (1L << n) - 1L;
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result2 = new ArrayList<String[]>((int)Combination.count(this.datas.length, m));
        this.select(0, new String[m], 0, result2);
        return result2;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result2 = new ArrayList<String[]>((int)Combination.countAll(this.datas.length));
        for (int i2 = 1; i2 <= this.datas.length; ++i2) {
            result2.addAll(this.select(i2));
        }
        return result2;
    }

    private void select(int dataIndex, String[] resultList, int resultIndex, List<String[]> result2) {
        int resultCount = resultIndex + 1;
        int resultLen = resultList.length;
        if (resultCount > resultLen) {
            result2.add(Arrays.copyOf(resultList, resultList.length));
            return;
        }
        for (int i2 = dataIndex; i2 < this.datas.length + resultCount - resultLen; ++i2) {
            resultList[resultIndex] = this.datas[i2];
            this.select(i2 + 1, resultList, resultIndex + 1, result2);
        }
    }
}

