/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.net.MaskBit;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public class Ipv4Util {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    public static String formatIpBlock(String ip, String mask) {
        return ip + IP_MASK_SPLIT_MARK + Ipv4Util.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains(IP_SPLIT_MARK)) {
            String[] range = StrUtil.splitToArray((CharSequence)ipRange, IP_SPLIT_MARK);
            return Ipv4Util.list(range[0], range[1]);
        }
        if (ipRange.contains(IP_MASK_SPLIT_MARK)) {
            String[] param2 = StrUtil.splitToArray((CharSequence)ipRange, IP_MASK_SPLIT_MARK);
            return Ipv4Util.list(param2[0], Integer.parseInt(param2[1]), isAll);
        }
        return ListUtil.toList(ipRange);
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        if (maskBit == 32) {
            ArrayList<String> list2 = new ArrayList<String>();
            if (isAll) {
                list2.add(ip);
            }
            return list2;
        }
        String startIp = Ipv4Util.getBeginIpStr(ip, maskBit);
        String endIp = Ipv4Util.getEndIpStr(ip, maskBit);
        if (isAll) {
            return Ipv4Util.list(startIp, endIp);
        }
        int lastDotIndex = startIp.lastIndexOf(46) + 1;
        startIp = StrUtil.subPre(startIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(startIp, lastDotIndex))) + 1);
        lastDotIndex = endIp.lastIndexOf(46) + 1;
        endIp = StrUtil.subPre(endIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(endIp, lastDotIndex))) - 1);
        return Ipv4Util.list(startIp, endIp);
    }

    public static List<String> list(String ipFrom, String ipTo) {
        int count = Ipv4Util.countByIpRange(ipFrom, ipTo);
        int[] from = Convert.convert(int[].class, (Object)StrUtil.splitToArray((CharSequence)ipFrom, '.'));
        int[] to = Convert.convert(int[].class, (Object)StrUtil.splitToArray((CharSequence)ipTo, '.'));
        ArrayList<String> ips = new ArrayList<String>(count);
        boolean aIsStart = true;
        boolean bIsStart = true;
        boolean cIsStart = true;
        int aEnd = to[0];
        for (int a = from[0]; a <= aEnd; ++a) {
            int b;
            boolean aIsEnd = a == aEnd;
            int bEnd = aIsEnd ? to[1] : 255;
            int n = b = aIsStart ? from[1] : 0;
            while (b <= bEnd) {
                int c;
                boolean bIsEnd = aIsEnd && b == bEnd;
                int cEnd = bIsEnd ? to[2] : 255;
                int n2 = c = bIsStart ? from[2] : 0;
                while (c <= cEnd) {
                    int d;
                    boolean cIsEnd = bIsEnd && c == cEnd;
                    int dEnd = cIsEnd ? to[3] : 255;
                    int n3 = d = cIsStart ? from[3] : 0;
                    while (d <= dEnd) {
                        ips.add(a + "." + b + "." + c + "." + d);
                        ++d;
                    }
                    cIsStart = false;
                    ++c;
                }
                bIsStart = false;
                ++b;
            }
            aIsStart = false;
        }
        return ips;
    }

    public static String longToIpv4(long longIP) {
        StringBuilder sb = StrUtil.builder();
        sb.append(longIP >> 24 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 16 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 8 & 0xFFL);
        sb.append('.');
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        Matcher matcher = PatternPool.IPV4.matcher(strIP);
        if (matcher.matches()) {
            return Ipv4Util.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Invalid IPv4 address!");
    }

    public static long ipv4ToLong(String strIP, long defaultValue) {
        return Validator.isIpv4(strIP) ? Ipv4Util.ipv4ToLong(strIP) : defaultValue;
    }

    public static String getBeginIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getBeginIpLong(ip, maskBit));
    }

    public static Long getBeginIpLong(String ip, int maskBit) {
        return Ipv4Util.ipv4ToLong(ip) & Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(maskBit));
    }

    public static String getEndIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getEndIpLong(ip, maskBit));
    }

    public static int getMaskBitByMask(String mask) {
        Integer maskBit = MaskBit.getMaskBit(mask);
        if (maskBit == null) {
            throw new IllegalArgumentException("Invalid netmask " + mask);
        }
        return maskBit;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        if (!(isAll || maskBit > 0 && maskBit < 32)) {
            return 0;
        }
        int count = (int)Math.pow(2.0, 32 - maskBit);
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        return MaskBit.get(maskBit);
    }

    public static String getMaskByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        Assert.isTrue(fromIpLong < toIpLong, "to IP must be greater than from IP!", new Object[0]);
        String[] fromIpSplit = StrUtil.splitToArray((CharSequence)fromIp, '.');
        String[] toIpSplit = StrUtil.splitToArray((CharSequence)toIp, '.');
        StringBuilder mask = new StringBuilder();
        for (int i2 = 0; i2 < toIpSplit.length; ++i2) {
            mask.append(255 - Integer.parseInt(toIpSplit[i2]) + Integer.parseInt(fromIpSplit[i2])).append('.');
        }
        return mask.substring(0, mask.length() - 1);
    }

    public static int countByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        if (fromIpLong > toIpLong) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        int count = 1;
        int[] fromIpSplit = StrUtil.split((CharSequence)fromIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        int[] toIpSplit = StrUtil.split((CharSequence)toIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        for (int i2 = fromIpSplit.length - 1; i2 >= 0; --i2) {
            count = (int)((double)count + (double)(toIpSplit[i2] - fromIpSplit[i2]) * Math.pow(256.0, fromIpSplit.length - i2 - 1));
        }
        return count;
    }

    public static boolean isMaskValid(String mask) {
        return MaskBit.getMaskBit(mask) != null;
    }

    public static boolean isMaskBitValid(int maskBit) {
        return MaskBit.get(maskBit) != null;
    }

    public static boolean isInnerIP(String ipAddress) {
        long ipNum = Ipv4Util.ipv4ToLong(ipAddress);
        long aBegin = Ipv4Util.ipv4ToLong("10.0.0.0");
        long aEnd = Ipv4Util.ipv4ToLong("10.255.255.255");
        long bBegin = Ipv4Util.ipv4ToLong("172.16.0.0");
        long bEnd = Ipv4Util.ipv4ToLong("172.31.255.255");
        long cBegin = Ipv4Util.ipv4ToLong("192.168.0.0");
        long cEnd = Ipv4Util.ipv4ToLong("192.168.255.255");
        boolean isInnerIp = Ipv4Util.isInner(ipNum, aBegin, aEnd) || Ipv4Util.isInner(ipNum, bBegin, bEnd) || Ipv4Util.isInner(ipNum, cBegin, cEnd) || LOCAL_IP.equals(ipAddress);
        return isInnerIp;
    }

    public static Long getEndIpLong(String ip, int maskBit) {
        return Ipv4Util.getBeginIpLong(ip, maskBit) + (Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(maskBit)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long matchAddress(Matcher matcher) {
        long addr = 0L;
        for (int i2 = 1; i2 <= 4; ++i2) {
            addr |= Long.parseLong(matcher.group(i2)) << 8 * (4 - i2);
        }
        return addr;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

