/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrMatcher {
    List<String> patterns;

    public StrMatcher(String pattern) {
        this.patterns = StrMatcher.parse(pattern);
    }

    public Map<String, String> match(String text2) {
        HashMap<String, String> result2 = MapUtil.newHashMap(true);
        int from = 0;
        String key2 = null;
        for (String part : this.patterns) {
            if (StrUtil.isWrap((CharSequence)part, "${", "}")) {
                key2 = StrUtil.sub(part, 2, part.length() - 1);
                continue;
            }
            int to = text2.indexOf(part, from);
            if (to < 0) {
                return MapUtil.empty();
            }
            if (null != key2 && to > from) {
                result2.put(key2, text2.substring(from, to));
            }
            from = to + part.length();
            key2 = null;
        }
        if (null != key2 && from < text2.length()) {
            result2.put(key2, text2.substring(from));
        }
        return result2;
    }

    private static List<String> parse(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        int length = pattern.length();
        char c = '\u0000';
        boolean inVar = false;
        StringBuilder part = StrUtil.builder();
        for (int i2 = 0; i2 < length; ++i2) {
            char pre = c;
            c = pattern.charAt(i2);
            if (inVar) {
                part.append(c);
                if ('}' != c) continue;
                inVar = false;
                patterns.add(part.toString());
                part.setLength(0);
                continue;
            }
            if ('{' == c && '$' == pre) {
                inVar = true;
                String preText = part.substring(0, part.length() - 1);
                if (StrUtil.isNotEmpty(preText)) {
                    patterns.add(preText);
                }
                part.setLength(0);
                part.append(pre).append(c);
                continue;
            }
            part.append(c);
        }
        if (part.length() > 0) {
            patterns.add(part.toString());
        }
        return patterns;
    }
}

