/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.text.finder.CharFinder;
import cn.hutool.core.text.finder.CharMatcherFinder;
import cn.hutool.core.text.finder.LengthFinder;
import cn.hutool.core.text.finder.PatternFinder;
import cn.hutool.core.text.finder.StrFinder;
import cn.hutool.core.text.split.SplitIter;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

public class StrSplitter {
    public static List<String> splitPath(CharSequence str) {
        return StrSplitter.splitPath(str, 0);
    }

    public static String[] splitPathToArray(CharSequence str) {
        return StrSplitter.toArray(StrSplitter.splitPath(str));
    }

    public static List<String> splitPath(CharSequence str, int limit) {
        return StrSplitter.split(str, '/', limit, true, true);
    }

    public static String[] splitPathToArray(CharSequence str, int limit) {
        return StrSplitter.toArray(StrSplitter.splitPath(str, limit));
    }

    public static List<String> splitTrim(CharSequence str, char separator2, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, 0, true, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator2, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, 0, isTrim, ignoreEmpty);
    }

    public static List<String> splitTrim(CharSequence str, char separator2, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, limit, true, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, char separator2, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, limit, isTrim, ignoreEmpty, false);
    }

    public static <R> List<R> split(CharSequence str, char separator2, int limit, boolean ignoreEmpty, Function<String, R> mapping) {
        return StrSplitter.split(str, separator2, limit, ignoreEmpty, false, mapping);
    }

    public static List<String> splitIgnoreCase(CharSequence text2, char separator2, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(text2, separator2, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> split(CharSequence text2, char separator2, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return StrSplitter.split(text2, separator2, limit, ignoreEmpty, ignoreCase, StrSplitter.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence text2, char separator2, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        if (null == text2) {
            return new ArrayList(0);
        }
        SplitIter splitIter = new SplitIter(text2, new CharFinder(separator2, ignoreCase), limit, ignoreEmpty);
        return splitIter.toList(mapping);
    }

    public static String[] splitToArray(CharSequence str, char separator2, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separator2, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(CharSequence str, String separator2, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(CharSequence str, String separator2, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, true, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, String separator2, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(CharSequence str, String separator2, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, limit, true, ignoreEmpty);
    }

    public static List<String> splitIgnoreCase(CharSequence str, String separator2, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(CharSequence str, String separator2, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator2, limit, true, ignoreEmpty, true);
    }

    public static List<String> split(CharSequence text2, String separator2, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (null == text2) {
            return new ArrayList<String>(0);
        }
        SplitIter splitIter = new SplitIter(text2, new StrFinder(separator2, ignoreCase), limit, ignoreEmpty);
        return splitIter.toList(isTrim);
    }

    public static String[] splitToArray(CharSequence str, String separator2, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separator2, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(CharSequence text2, int limit) {
        if (null == text2) {
            return new ArrayList<String>(0);
        }
        SplitIter splitIter = new SplitIter(text2, new CharMatcherFinder(CharUtil::isBlankChar), limit, true);
        return splitIter.toList(false);
    }

    public static String[] splitToArray(String str, int limit) {
        return StrSplitter.toArray(StrSplitter.split(str, limit));
    }

    public static List<String> splitByRegex(String text2, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        Pattern pattern = PatternPool.get(separatorRegex);
        return StrSplitter.split(text2, pattern, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(String text2, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == text2) {
            return new ArrayList<String>(0);
        }
        SplitIter splitIter = new SplitIter(text2, new PatternFinder(separatorPattern), limit, ignoreEmpty);
        return splitIter.toList(isTrim);
    }

    public static String[] splitToArray(String str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitByLength(CharSequence text2, int len) {
        if (null == text2) {
            return new String[0];
        }
        SplitIter splitIter = new SplitIter(text2, new LengthFinder(len), -1, false);
        return splitIter.toArray(false);
    }

    private static String[] toArray(List<String> list2) {
        return list2.toArray(new String[0]);
    }

    private static Function<String, String> trimFunc(boolean isTrim) {
        return str -> isTrim ? StrUtil.trim(str) : str;
    }
}

