/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class TextSimilarity {
    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = TextSimilarity.removeSign(strB);
            newStrB = TextSimilarity.removeSign(strA);
        } else {
            newStrA = TextSimilarity.removeSign(strA);
            newStrB = TextSimilarity.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int commonLength = TextSimilarity.longestCommonSubstringLength(newStrA, newStrB);
        return NumberUtil.div((float)commonLength, (float)temp);
    }

    public static String similar(String strA, String strB, int scale2) {
        return NumberUtil.formatPercent(TextSimilarity.similar(strA, strB), scale2);
    }

    public static String longestCommonSubstring(String strA, String strB) {
        int[][] matrix = TextSimilarity.generateMatrix(strA, strB);
        int m = strA.length();
        int n = strB.length();
        char[] result2 = new char[matrix[m][n]];
        int currentIndex = result2.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result2[currentIndex] = strA.charAt(m - 1);
            --currentIndex;
            --n;
            --m;
        }
        return new String(result2);
    }

    private static String removeSign(String str) {
        int length = str.length();
        StringBuilder sb = StrUtil.builder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c = str.charAt(i2);
            if (!TextSimilarity.isValidChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isValidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static int longestCommonSubstringLength(String strA, String strB) {
        int m = strA.length();
        int n = strB.length();
        return TextSimilarity.generateMatrix(strA, strB)[m][n];
    }

    private static int[][] generateMatrix(String strA, String strB) {
        int m = strA.length();
        int n = strB.length();
        int[][] matrix = new int[m + 1][n + 1];
        for (int i2 = 1; i2 <= m; ++i2) {
            for (int j = 1; j <= n; ++j) {
                matrix[i2][j] = strA.charAt(i2 - 1) == strB.charAt(j - 1) ? matrix[i2 - 1][j - 1] + 1 : Math.max(matrix[i2][j - 1], matrix[i2 - 1][j]);
            }
        }
        return matrix;
    }
}

