/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;

public class UnicodeUtil {
    public static String toString(String unicode) {
        int i2;
        if (StrUtil.isBlank(unicode)) {
            return unicode;
        }
        int len = unicode.length();
        StringBuilder sb = new StringBuilder(len);
        int pos = 0;
        while ((i2 = StrUtil.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
            sb.append(unicode, pos, i2);
            pos = i2;
            if (i2 + 5 >= len) break;
            try {
                char c = (char)Integer.parseInt(unicode.substring(i2 + 2, i2 + 6), 16);
                sb.append(c);
                pos = i2 + 6;
            }
            catch (NumberFormatException e) {
                sb.append(unicode, pos, i2 + 2);
                pos = i2 + 2;
            }
        }
        if (pos < len) {
            sb.append(unicode, pos, len);
        }
        return sb.toString();
    }

    public static String toUnicode(char c) {
        return HexUtil.toUnicodeHex(c);
    }

    public static String toUnicode(int c) {
        return HexUtil.toUnicodeHex(c);
    }

    public static String toUnicode(String str) {
        return UnicodeUtil.toUnicode(str, true);
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder unicode = new StringBuilder(str.length() * 6);
        for (int i2 = 0; i2 < len; ++i2) {
            char c = str.charAt(i2);
            if (isSkipAscii && CharUtil.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexUtil.toUnicodeHex(c));
        }
        return unicode.toString();
    }
}

