/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvParser;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvRowHandler;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CsvBaseReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private final CsvReadConfig config;

    public CsvBaseReader() {
        this(null);
    }

    public CsvBaseReader(CsvReadConfig config2) {
        this.config = ObjectUtil.defaultIfNull(config2, CsvReadConfig::defaultConfig);
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.config.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws IORuntimeException {
        return this.read(file, DEFAULT_CHARSET);
    }

    public CsvData readFromStr(String csvStr) {
        return this.read(new StringReader(csvStr));
    }

    public void readFromStr(String csvStr, CsvRowHandler rowHandler) {
        this.read(this.parse(new StringReader(csvStr)), rowHandler);
    }

    public CsvData read(File file, Charset charset) throws IORuntimeException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path2) throws IORuntimeException {
        return this.read(path2, DEFAULT_CHARSET);
    }

    public CsvData read(Path path2, Charset charset) throws IORuntimeException {
        Assert.notNull(path2, "path must not be null", new Object[0]);
        return this.read(FileUtil.getReader(path2, charset));
    }

    public CsvData read(Reader reader) throws IORuntimeException {
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        this.read(csvParser, rows::add);
        List<String> header = this.config.headerLineNo > -1L ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    public List<Map<String, String>> readMapList(Reader reader) throws IORuntimeException {
        this.config.setContainsHeader(true);
        ArrayList<Map<String, String>> result2 = new ArrayList<Map<String, String>>();
        this.read(reader, (CsvRow row2) -> result2.add(row2.getFieldMap()));
        return result2;
    }

    public <T> List<T> read(Reader reader, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result2 = new ArrayList();
        this.read(reader, (CsvRow row2) -> result2.add(row2.toBean(clazz)));
        return result2;
    }

    public <T> List<T> read(String csvStr, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result2 = new ArrayList();
        this.read((Reader)new StringReader(csvStr), (CsvRow row2) -> result2.add(row2.toBean(clazz)));
        return result2;
    }

    public void read(Reader reader, CsvRowHandler rowHandler) throws IORuntimeException {
        this.read(this.parse(reader), rowHandler);
    }

    private void read(CsvParser csvParser, CsvRowHandler rowHandler) throws IORuntimeException {
        try {
            while (csvParser.hasNext()) {
                rowHandler.handle((CsvRow)csvParser.next());
            }
        }
        finally {
            IoUtil.close(csvParser);
        }
    }

    protected CsvParser parse(Reader reader) throws IORuntimeException {
        return new CsvParser(reader, this.config);
    }
}

