/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.csv.CsvBaseReader;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvRowHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CsvReader
extends CsvBaseReader
implements Iterable<CsvRow>,
Closeable {
    private static final long serialVersionUID = 1L;
    private final Reader reader;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config2) {
        this((Reader)null, config2);
    }

    public CsvReader(File file, CsvReadConfig config2) {
        this(file, DEFAULT_CHARSET, config2);
    }

    public CsvReader(Path path2, CsvReadConfig config2) {
        this(path2, DEFAULT_CHARSET, config2);
    }

    public CsvReader(File file, Charset charset, CsvReadConfig config2) {
        this(FileUtil.getReader(file, charset), config2);
    }

    public CsvReader(Path path2, Charset charset, CsvReadConfig config2) {
        this(FileUtil.getReader(path2, charset), config2);
    }

    public CsvReader(Reader reader, CsvReadConfig config2) {
        super(config2);
        this.reader = reader;
    }

    public CsvData read() throws IORuntimeException {
        return this.read(this.reader);
    }

    public void read(CsvRowHandler rowHandler) throws IORuntimeException {
        this.read(this.reader, rowHandler);
    }

    public Stream<CsvRow> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        });
    }

    @Override
    public Iterator<CsvRow> iterator() {
        return this.parse(this.reader);
    }

    @Override
    public void close() throws IOException {
        IoUtil.close(this.reader);
    }
}

