/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.finder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.finder.TextFinder;
import cn.hutool.core.util.NumberUtil;

public class CharFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final char c;
    private final boolean caseInsensitive;

    public CharFinder(char c) {
        this(c, false);
    }

    public CharFinder(char c, boolean caseInsensitive) {
        this.c = c;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int limit = this.getValidEndIndex();
        if (this.negative) {
            for (int i2 = from; i2 > limit; --i2) {
                if (!NumberUtil.equals(this.c, this.text.charAt(i2), this.caseInsensitive)) continue;
                return i2;
            }
        } else {
            for (int i3 = from; i3 < limit; ++i3) {
                if (!NumberUtil.equals(this.c, this.text.charAt(i3), this.caseInsensitive)) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public int end(int start2) {
        if (start2 < 0) {
            return -1;
        }
        return start2 + 1;
    }
}

